/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.list;

import io.delilaheve.CustomAnvil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.config.MainConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.ElementListConfigGui;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;

public abstract class MappedElementListConfigGui<T, S>
extends ElementListConfigGui<T> {
    protected final HashMap<T, S> elementGuiMap = new HashMap();

    protected MappedElementListConfigGui(@NotNull String title) {
        super(title, (Gui)MainConfigGui.getInstance());
    }

    @Override
    protected GuiItem prepareCreateNewItem() {
        ItemStack createItem = new ItemStack(Material.PAPER);
        ItemMeta createMeta = createItem.getItemMeta();
        assert (createMeta != null);
        createMeta.setDisplayName("\u00a7aCreate new " + this.genericDisplayedName());
        createMeta.setLore(Arrays.asList("\u00a77Create a new " + this.genericDisplayedName() + ".", "\u00a77You will be asked to name the " + this.genericDisplayedName() + " in chat.", "\u00a77Then, you should edit the " + this.genericDisplayedName() + " config as you need"));
        createItem.setItemMeta(createMeta);
        return new GuiItem(createItem, clickEvent -> {
            clickEvent.setCancelled(true);
            HumanEntity player = clickEvent.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage("\u00a7cYou do not have permission to edit the config");
                return;
            }
            player.closeInventory();
            player.sendMessage("\u00a7eWrite the " + this.genericDisplayedName() + " name you want to create in the chat.\n\u00a7eOr write \u00a7ccancel \u00a7eto go back to " + this.genericDisplayedName() + " config menu");
            CustomAnvil.Companion.getChatListener().setListenedCallback(player, this.prepareCreateItemConsumer(player));
        }, (Plugin)CustomAnvil.instance);
    }

    @Override
    protected void updateGeneric(T generic, ItemStack usedItem) {
        S element = this.elementGuiMap.get(generic);
        if (element == null) {
            GuiItem guiItem = new GuiItem(usedItem, (Plugin)CustomAnvil.instance);
            element = this.newElementRequested(generic, guiItem);
            this.elementGuiMap.put(generic, element);
            this.addToPage(guiItem);
        } else {
            GuiItem guiItem = this.findItemFromElement(generic, element);
            guiItem.setItem(usedItem);
        }
        this.updateElement(generic, element);
    }

    protected abstract void updateElement(T var1, S var2);

    protected abstract S newElementRequested(T var1, GuiItem var2);

    protected abstract GuiItem findItemFromElement(T var1, S var2);

    @Override
    protected GuiItem findGuiItemForRemoval(T generic) {
        S element = this.elementGuiMap.get(generic);
        if (element == null) {
            return null;
        }
        this.elementGuiMap.remove(generic);
        return this.findGuiItemForRemoval(generic, element);
    }

    protected abstract GuiItem findGuiItemForRemoval(T var1, S var2);

    protected abstract Consumer<String> prepareCreateItemConsumer(HumanEntity var1);

    protected abstract String genericDisplayedName();
}

