/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import io.delilaheve.util.ConfigOptions;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.config.WorkPenaltyType;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.global.BasicConfigGui;
import xyz.alexcrea.cuanvil.gui.config.settings.AbstractSettingGui;
import xyz.alexcrea.cuanvil.util.AnvilUseType;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class WorkPenaltyTypeSettingGui
extends AbstractSettingGui {
    private static final String INCREASING_EXPLANATION = "\u00a7eIncreasing\u00a77: will penalty be increased (in item)";
    private static final String ADDING_EXPLANATION = "\u00a7eAdditive\u00a77: will penalty be added to the cost";
    private static final String SHARED_EXPLANATION = "\u00a7eShared\u00a77: Vanilla, shared penalty. it will be kept from before the plugin installation.";
    private static final String EXCLUSIVE_EXPLANATION = "\u00a7eExclusive\u00a77: Custom, per anvil use type penalty. it will be lost after plugin uninstallation";
    @NotNull
    private final WorkPenaltyType currentType = ConfigOptions.INSTANCE.getWorkPenaltyType();
    @NotNull
    private final Map<AnvilUseType, WorkPenaltyType.WorkPenaltyPart> items = new EnumMap<AnvilUseType, WorkPenaltyType.WorkPenaltyPart>((Map<AnvilUseType, WorkPenaltyType.WorkPenaltyPart>)this.currentType.getPartMap());
    private static final Map<AnvilUseType, String> useTypes = Map.of(AnvilUseType.RENAME_ONLY, "a1z9Z", AnvilUseType.MERGE, "b2y8Y", AnvilUseType.UNIT_REPAIR, "c3x7X", AnvilUseType.CUSTOM_CRAFT, "d4w6W");

    public WorkPenaltyTypeSettingGui(@NotNull BasicConfigGui parent) {
        super(4, "\u00a78Work Penalty Type", (ValueUpdatableGui)parent);
        for (AnvilUseType type : useTypes.keySet()) {
            this.updateGuiForType(type);
        }
    }

    public static GuiItem getDisplayItem(@NotNull BasicConfigGui parent, @NotNull Material itemMat, @NotNull String name) {
        ArrayList<String> displayLore = new ArrayList<String>();
        displayLore.add("\u00a77Work penalty increase the price for every anvil use.");
        displayLore.add("\u00a77This config allow you to choose the comportment of work penalty.");
        displayLore.add(INCREASING_EXPLANATION);
        displayLore.add(ADDING_EXPLANATION);
        displayLore.add("");
        displayLore.add("\u00a77About shared/exclusive penalty:");
        displayLore.add(SHARED_EXPLANATION);
        displayLore.add(EXCLUSIVE_EXPLANATION);
        ItemStack item = new ItemStack(itemMat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(displayLore);
        item.setItemMeta(meta);
        return new GuiItem(item, event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage("\u00a7cYou do not have permission to edit the config");
                return;
            }
            new WorkPenaltyTypeSettingGui(parent).show(player);
        }, (Plugin)CustomAnvil.instance);
    }

    @Override
    protected Pattern getGuiPattern() {
        return new Pattern(new String[]{"00a1z9Z00", "00b2y8Y00", "00c3x7X00", "B004w600S"});
    }

    public void updateGuiForType(AnvilUseType type) {
        PatternPane pane = this.getPane();
        String typeVals = useTypes.get((Object)type);
        char increment = typeVals.charAt(0);
        char additive = typeVals.charAt(1);
        char display = typeVals.charAt(2);
        char exclusiveIncrement = typeVals.charAt(3);
        char exclusiveAdditive = typeVals.charAt(4);
        WorkPenaltyType.WorkPenaltyPart part = this.items.get((Object)type);
        String increasingStr = (part.penaltyIncrease() ? "\u00a7a" : "\u00a7c") + "Increasing";
        String additiveStr = (part.penaltyAdditive() ? "\u00a7a" : "\u00a7c") + "Additive";
        String exclusiveIncreasingStr = (part.exclusivePenaltyIncrease() ? "\u00a7a" : "\u00a7c") + "Increasing";
        String exclusiveAdditiveStr = (part.exclusivePenaltyAdditive() ? "\u00a7a" : "\u00a7c") + "Additive";
        ItemStack displayItem = new ItemStack(type.getDisplayMat());
        ArrayList<CallSite> displayLore = new ArrayList<CallSite>();
        displayLore.add((CallSite)((Object)("\u00a7eShared\u00a77: " + additiveStr + " \u00a77| " + increasingStr)));
        displayLore.add((CallSite)((Object)("\u00a7eExclusive\u00a77: " + exclusiveAdditiveStr + " \u00a77| " + exclusiveIncreasingStr)));
        ItemMeta meta = displayItem.getItemMeta();
        meta.setDisplayName("\u00a7e" + type.getDisplayName());
        meta.setLore(displayLore);
        displayItem.setItemMeta(meta);
        pane.bindItem(display, new GuiItem(displayItem, event -> event.setCancelled(true)));
        ItemStack incrementItem = new ItemStack(part.penaltyIncrease() ? Material.GREEN_TERRACOTTA : Material.RED_TERRACOTTA);
        meta = incrementItem.getItemMeta();
        meta.setDisplayName(increasingStr);
        meta.setLore(List.of(INCREASING_EXPLANATION));
        meta.setLore(List.of(SHARED_EXPLANATION));
        incrementItem.setItemMeta(meta);
        pane.bindItem(increment, new GuiItem(incrementItem, event -> {
            event.setCancelled(true);
            WorkPenaltyType.WorkPenaltyPart newPart = new WorkPenaltyType.WorkPenaltyPart(!part.penaltyIncrease(), part.penaltyAdditive(), part.exclusivePenaltyIncrease(), part.exclusivePenaltyAdditive());
            this.items.replace(type, newPart);
            this.updateGuiForType(type);
            this.update();
        }));
        ItemStack additiveItem = new ItemStack(part.penaltyAdditive() ? Material.GREEN_TERRACOTTA : Material.RED_TERRACOTTA);
        meta = additiveItem.getItemMeta();
        meta.setDisplayName(additiveStr);
        meta.setLore(List.of(ADDING_EXPLANATION));
        meta.setLore(List.of(SHARED_EXPLANATION));
        additiveItem.setItemMeta(meta);
        pane.bindItem(additive, new GuiItem(additiveItem, event -> {
            event.setCancelled(true);
            WorkPenaltyType.WorkPenaltyPart newPart = new WorkPenaltyType.WorkPenaltyPart(part.penaltyIncrease(), !part.penaltyAdditive(), part.exclusivePenaltyIncrease(), part.exclusivePenaltyAdditive());
            this.items.replace(type, newPart);
            this.updateGuiForType(type);
            this.update();
        }));
        ItemStack exclusiveIncrementItem = new ItemStack(part.exclusivePenaltyIncrease() ? Material.GREEN_TERRACOTTA : Material.RED_TERRACOTTA);
        meta = exclusiveIncrementItem.getItemMeta();
        meta.setDisplayName(exclusiveIncreasingStr);
        meta.setLore(List.of(INCREASING_EXPLANATION));
        meta.setLore(List.of(EXCLUSIVE_EXPLANATION));
        exclusiveIncrementItem.setItemMeta(meta);
        pane.bindItem(exclusiveIncrement, new GuiItem(exclusiveIncrementItem, event -> {
            event.setCancelled(true);
            WorkPenaltyType.WorkPenaltyPart newPart = new WorkPenaltyType.WorkPenaltyPart(part.penaltyIncrease(), part.penaltyAdditive(), !part.exclusivePenaltyIncrease(), part.exclusivePenaltyAdditive());
            this.items.replace(type, newPart);
            this.updateGuiForType(type);
            this.update();
        }));
        ItemStack exclusiveAdditiveItem = new ItemStack(part.exclusivePenaltyAdditive() ? Material.GREEN_TERRACOTTA : Material.RED_TERRACOTTA);
        meta = exclusiveAdditiveItem.getItemMeta();
        meta.setDisplayName(exclusiveAdditiveStr);
        meta.setLore(List.of(ADDING_EXPLANATION));
        meta.setLore(List.of(EXCLUSIVE_EXPLANATION));
        exclusiveAdditiveItem.setItemMeta(meta);
        pane.bindItem(exclusiveAdditive, new GuiItem(exclusiveAdditiveItem, event -> {
            event.setCancelled(true);
            WorkPenaltyType.WorkPenaltyPart newPart = new WorkPenaltyType.WorkPenaltyPart(part.penaltyIncrease(), part.penaltyAdditive(), part.exclusivePenaltyIncrease(), !part.exclusivePenaltyAdditive());
            this.items.replace(type, newPart);
            this.updateGuiForType(type);
            this.update();
        }));
    }

    @Override
    public boolean onSave() {
        return WorkPenaltyTypeSettingGui.saveWorkPenalty(this.items);
    }

    public static boolean saveWorkPenalty(Map<AnvilUseType, WorkPenaltyType.WorkPenaltyPart> partEnum) {
        ConfigHolder.DefaultConfigHolder configHolder = ConfigHolder.DEFAULT_CONFIG;
        FileConfiguration config = configHolder.getConfig();
        partEnum.forEach((key, value) -> {
            String partPath = key.getPath();
            if (key.getDefaultPenalty().equals(value)) {
                config.set(partPath, null);
                return;
            }
            config.set(partPath + ".shared_increase", (Object)value.penaltyIncrease());
            config.set(partPath + ".shared_additive", (Object)value.penaltyAdditive());
            config.set(partPath + ".exclusive_increase", (Object)value.exclusivePenaltyIncrease());
            config.set(partPath + ".exclusive_additive", (Object)value.exclusivePenaltyAdditive());
        });
        return configHolder.saveToDisk(true);
    }

    @Override
    public boolean hadChange() {
        for (AnvilUseType type : this.items.keySet()) {
            if (this.currentType.getPenaltyInfo(type).equals(this.items.get((Object)type))) continue;
            return true;
        }
        return false;
    }
}

