/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.recipe;

import io.delilaheve.CustomAnvil;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.util.AnvilUseType;
import xyz.alexcrea.cuanvil.util.AnvilXpUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 32\u00020\u0001:\u00013BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010&\u001a\u00020\u0005J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005J\b\u0010'\u001a\u00020(H\u0007J\u0006\u0010+\u001a\u00020(J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u000b2\b\u0010.\u001a\u0004\u0018\u00010\u000bJ\b\u0010/\u001a\u00020\u0003H\u0016J\u001e\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001f\"\u0004\b%\u0010!\u00a8\u00064"}, d2={"Lxyz/alexcrea/cuanvil/recipe/AnvilCustomRecipe;", "", "name", "", "exactCount", "", "levelCostPerCraft", "", "XpCostPerCraft", "removeExactLinearXp", "leftItem", "Lorg/bukkit/inventory/ItemStack;", "rightItem", "resultItem", "<init>", "(Ljava/lang/String;ZIIZLorg/bukkit/inventory/ItemStack;Lorg/bukkit/inventory/ItemStack;Lorg/bukkit/inventory/ItemStack;)V", "getName", "()Ljava/lang/String;", "getExactCount", "()Z", "setExactCount", "(Z)V", "getLevelCostPerCraft", "()I", "setLevelCostPerCraft", "(I)V", "getXpCostPerCraft", "setXpCostPerCraft", "getRemoveExactLinearXp", "setRemoveExactLinearXp", "getLeftItem", "()Lorg/bukkit/inventory/ItemStack;", "setLeftItem", "(Lorg/bukkit/inventory/ItemStack;)V", "getRightItem", "setRightItem", "getResultItem", "setResultItem", "validate", "saveToFile", "", "writeFile", "doBackup", "updateFromFile", "testItem", "item1", "item2", "toString", "determineCost", "amount", "first", "Companion", "CustomAnvil"})
public final class AnvilCustomRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private boolean exactCount;
    private int levelCostPerCraft;
    private int XpCostPerCraft;
    private boolean removeExactLinearXp;
    @Nullable
    private ItemStack leftItem;
    @Nullable
    private ItemStack rightItem;
    @Nullable
    private ItemStack resultItem;
    @NotNull
    public static final String EXACT_COUNT_CONFIG = "exact_count";
    @NotNull
    public static final String XP_LEVEL_COST_CONFIG = "xp_cost";
    @NotNull
    public static final String LINEAR_XP_COST_CONFIG = "linear_xp_cost";
    @NotNull
    public static final String REMOVE_EXACT_XP_CONFIG = "remove_exact_linear_xp";
    @NotNull
    public static final String LEFT_ITEM_CONFIG = "left_item";
    @NotNull
    public static final String RIGHT_ITEM_CONFIG = "right_item";
    @NotNull
    public static final String RESULT_ITEM_CONFIG = "result_item";
    public static final boolean DEFAULT_EXACT_COUNT_CONFIG = true;
    public static final int DEFAULT_XP_LEVEL_COST_CONFIG = 1;
    public static final int DEFAULT_LINEAR_XP_COST_CONFIG = 0;
    public static final boolean DEFAULT_REMOVE_EXACT_XP_CONFIG = false;
    @Nullable
    private static final ItemStack DEFAULT_LEFT_ITEM_CONFIG;
    @Nullable
    private static final ItemStack DEFAULT_RIGHT_ITEM_CONFIG;
    @Nullable
    private static final ItemStack DEFAULT_RESULT_ITEM_CONFIG;
    @NotNull
    private static final IntRange XP_COST_CONFIG_RANGE;

    public AnvilCustomRecipe(@NotNull String name, boolean exactCount, int levelCostPerCraft, int XpCostPerCraft, boolean removeExactLinearXp, @Nullable ItemStack leftItem, @Nullable ItemStack rightItem, @Nullable ItemStack resultItem) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.exactCount = exactCount;
        this.levelCostPerCraft = levelCostPerCraft;
        this.XpCostPerCraft = XpCostPerCraft;
        this.removeExactLinearXp = removeExactLinearXp;
        this.leftItem = leftItem;
        this.rightItem = rightItem;
        this.resultItem = resultItem;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getExactCount() {
        return this.exactCount;
    }

    public final void setExactCount(boolean bl) {
        this.exactCount = bl;
    }

    public final int getLevelCostPerCraft() {
        return this.levelCostPerCraft;
    }

    public final void setLevelCostPerCraft(int n) {
        this.levelCostPerCraft = n;
    }

    public final int getXpCostPerCraft() {
        return this.XpCostPerCraft;
    }

    public final void setXpCostPerCraft(int n) {
        this.XpCostPerCraft = n;
    }

    public final boolean getRemoveExactLinearXp() {
        return this.removeExactLinearXp;
    }

    public final void setRemoveExactLinearXp(boolean bl) {
        this.removeExactLinearXp = bl;
    }

    @Nullable
    public final ItemStack getLeftItem() {
        return this.leftItem;
    }

    public final void setLeftItem(@Nullable ItemStack itemStack) {
        this.leftItem = itemStack;
    }

    @Nullable
    public final ItemStack getRightItem() {
        return this.rightItem;
    }

    public final void setRightItem(@Nullable ItemStack itemStack) {
        this.rightItem = itemStack;
    }

    @Nullable
    public final ItemStack getResultItem() {
        return this.resultItem;
    }

    public final void setResultItem(@Nullable ItemStack itemStack) {
        this.resultItem = itemStack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validate() {
        if (this.leftItem == null) return false;
        ItemStack itemStack = this.leftItem;
        Intrinsics.checkNotNull((Object)itemStack);
        if (itemStack.getType().isAir()) return false;
        ItemStack itemStack2 = this.leftItem;
        Intrinsics.checkNotNull((Object)itemStack2);
        if (itemStack2.getAmount() <= 0) return false;
        if (this.rightItem != null) {
            ItemStack itemStack3 = this.rightItem;
            Intrinsics.checkNotNull((Object)itemStack3);
            if (itemStack3.getType().isAir()) return false;
            ItemStack itemStack4 = this.rightItem;
            Intrinsics.checkNotNull((Object)itemStack4);
            if (itemStack4.getAmount() <= 0) return false;
        }
        if (this.resultItem == null) return false;
        ItemStack itemStack5 = this.resultItem;
        Intrinsics.checkNotNull((Object)itemStack5);
        if (itemStack5.getType().isAir()) return false;
        ItemStack itemStack6 = this.resultItem;
        Intrinsics.checkNotNull((Object)itemStack6);
        if (itemStack6.getAmount() <= 0) return false;
        return true;
    }

    public final void saveToFile(boolean writeFile, boolean doBackup) {
        FileConfiguration fileConfig = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig();
        fileConfig.set(this.name + ".exact_count", (Object)this.exactCount);
        fileConfig.set(this.name + ".xp_cost", (Object)this.levelCostPerCraft);
        fileConfig.set(this.name + ".linear_xp_cost", (Object)this.XpCostPerCraft);
        fileConfig.set(this.name + ".remove_exact_linear_xp", (Object)this.removeExactLinearXp);
        fileConfig.set(this.name + ".left_item", (Object)this.leftItem);
        fileConfig.set(this.name + ".right_item", (Object)this.rightItem);
        fileConfig.set(this.name + ".result_item", (Object)this.resultItem);
        if (writeFile) {
            ConfigHolder.CUSTOM_RECIPE_HOLDER.saveToDisk(doBackup);
        }
    }

    @Deprecated(message="Should use saveToFile(Boolean, Boolean) instead")
    public final void saveToFile() {
        this.saveToFile(true, true);
    }

    public final void updateFromFile() {
        this.exactCount = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig().getBoolean(this.name + ".exact_count", true);
        this.levelCostPerCraft = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig().getInt(this.name + ".xp_cost", 1);
        this.XpCostPerCraft = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig().getInt(this.name + ".linear_xp_cost", 0);
        this.removeExactLinearXp = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig().getBoolean(this.name + ".remove_exact_linear_xp", false);
        ItemStack leftItem = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig().getItemStack(this.name + ".left_item", DEFAULT_LEFT_ITEM_CONFIG);
        this.rightItem = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig().getItemStack(this.name + ".right_item", DEFAULT_RIGHT_ITEM_CONFIG);
        this.resultItem = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig().getItemStack(this.name + ".result_item", DEFAULT_RESULT_ITEM_CONFIG);
        ConfigHolder.CUSTOM_RECIPE_HOLDER.getRecipeManager().cleanSetLeftItem(this, leftItem);
    }

    public final boolean testItem(@NotNull ItemStack item1, @Nullable ItemStack item2) {
        Intrinsics.checkNotNullParameter((Object)item1, (String)"item1");
        CustomAnvil.Companion.verboseLog("Testing " + this.name + " " + this.leftItem);
        if (!this.validate()) {
            return false;
        }
        ItemStack itemStack = this.leftItem;
        Intrinsics.checkNotNull((Object)itemStack);
        boolean leftSimilar = itemStack.isSimilar(item1);
        CustomAnvil.Companion.verboseLog("Validated test !");
        if (!leftSimilar) {
            return false;
        }
        if (this.exactCount) {
            ItemStack itemStack2 = this.leftItem;
            Intrinsics.checkNotNull((Object)itemStack2);
            if (itemStack2.getAmount() != item1.getAmount()) {
                return false;
            }
        } else {
            int n = item1.getAmount();
            ItemStack itemStack3 = this.leftItem;
            Intrinsics.checkNotNull((Object)itemStack3);
            if (n < itemStack3.getAmount()) {
                return false;
            }
        }
        CustomAnvil.Companion.verboseLog("Left item passed !");
        if (this.rightItem == null) {
            if (item2 != null) {
                return false;
            }
        } else {
            ItemStack itemStack4 = this.rightItem;
            Intrinsics.checkNotNull((Object)itemStack4);
            boolean rightSimilar = itemStack4.isSimilar(item2);
            CustomAnvil.Companion.verboseLog("Right similar: " + rightSimilar);
            if (!rightSimilar) {
                return false;
            }
            if (this.exactCount) {
                ItemStack itemStack5 = this.rightItem;
                Intrinsics.checkNotNull((Object)itemStack5);
                int n = itemStack5.getAmount();
                ItemStack itemStack6 = item2;
                Intrinsics.checkNotNull((Object)itemStack6);
                if (n != itemStack6.getAmount()) {
                    return false;
                }
            } else {
                ItemStack itemStack7 = item2;
                Intrinsics.checkNotNull((Object)itemStack7);
                int n = itemStack7.getAmount();
                ItemStack itemStack8 = this.rightItem;
                Intrinsics.checkNotNull((Object)itemStack8);
                if (n < itemStack8.getAmount()) {
                    return false;
                }
            }
        }
        CustomAnvil.Companion.verboseLog("Right item passed !");
        return true;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public final int determineCost(int amount, @NotNull ItemStack first, @NotNull ItemStack resultItem) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)resultItem, (String)"resultItem");
        int levelCost = this.levelCostPerCraft * amount;
        int xpCost = AnvilXpUtil.INSTANCE.calculateXpForLevel(levelCost += AnvilXpUtil.INSTANCE.calculatePenalty(first, null, resultItem, AnvilUseType.CUSTOM_CRAFT));
        return xpCost += this.XpCostPerCraft * amount;
    }

    static {
        XP_COST_CONFIG_RANGE = new IntRange(0, 255);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lxyz/alexcrea/cuanvil/recipe/AnvilCustomRecipe$Companion;", "", "<init>", "()V", "EXACT_COUNT_CONFIG", "", "XP_LEVEL_COST_CONFIG", "LINEAR_XP_COST_CONFIG", "REMOVE_EXACT_XP_CONFIG", "LEFT_ITEM_CONFIG", "RIGHT_ITEM_CONFIG", "RESULT_ITEM_CONFIG", "DEFAULT_EXACT_COUNT_CONFIG", "", "DEFAULT_XP_LEVEL_COST_CONFIG", "", "DEFAULT_LINEAR_XP_COST_CONFIG", "DEFAULT_REMOVE_EXACT_XP_CONFIG", "DEFAULT_LEFT_ITEM_CONFIG", "Lorg/bukkit/inventory/ItemStack;", "getDEFAULT_LEFT_ITEM_CONFIG", "()Lorg/bukkit/inventory/ItemStack;", "DEFAULT_RIGHT_ITEM_CONFIG", "getDEFAULT_RIGHT_ITEM_CONFIG", "DEFAULT_RESULT_ITEM_CONFIG", "getDEFAULT_RESULT_ITEM_CONFIG", "XP_COST_CONFIG_RANGE", "Lkotlin/ranges/IntRange;", "getXP_COST_CONFIG_RANGE", "()Lkotlin/ranges/IntRange;", "getFromConfig", "Lxyz/alexcrea/cuanvil/recipe/AnvilCustomRecipe;", "name", "configSection", "Lorg/bukkit/configuration/ConfigurationSection;", "CustomAnvil"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ItemStack getDEFAULT_LEFT_ITEM_CONFIG() {
            return DEFAULT_LEFT_ITEM_CONFIG;
        }

        @Nullable
        public final ItemStack getDEFAULT_RIGHT_ITEM_CONFIG() {
            return DEFAULT_RIGHT_ITEM_CONFIG;
        }

        @Nullable
        public final ItemStack getDEFAULT_RESULT_ITEM_CONFIG() {
            return DEFAULT_RESULT_ITEM_CONFIG;
        }

        @NotNull
        public final IntRange getXP_COST_CONFIG_RANGE() {
            return XP_COST_CONFIG_RANGE;
        }

        @Nullable
        public final AnvilCustomRecipe getFromConfig(@NotNull String name, @Nullable ConfigurationSection configSection) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (configSection == null) {
                return null;
            }
            return new AnvilCustomRecipe(name, configSection.getBoolean(AnvilCustomRecipe.EXACT_COUNT_CONFIG, true), configSection.getInt(AnvilCustomRecipe.XP_LEVEL_COST_CONFIG, 1), configSection.getInt(AnvilCustomRecipe.LINEAR_XP_COST_CONFIG, 0), configSection.getBoolean(AnvilCustomRecipe.REMOVE_EXACT_XP_CONFIG, false), configSection.getItemStack(AnvilCustomRecipe.LEFT_ITEM_CONFIG, this.getDEFAULT_LEFT_ITEM_CONFIG()), configSection.getItemStack(AnvilCustomRecipe.RIGHT_ITEM_CONFIG, this.getDEFAULT_RIGHT_ITEM_CONFIG()), configSection.getItemStack(AnvilCustomRecipe.RESULT_ITEM_CONFIG, this.getDEFAULT_RESULT_ITEM_CONFIG()));
        }

        @Nullable
        public final AnvilCustomRecipe getFromConfig(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getFromConfig(name, ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig().getConfigurationSection(name));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

