/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.update.plugin;

import io.delilaheve.CustomAnvil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.update.UpdateUtils;
import xyz.alexcrea.cuanvil.update.Update_1_21;
import xyz.alexcrea.cuanvil.update.Update_1_21_9;
import xyz.alexcrea.cuanvil.update.Version;
import xyz.alexcrea.cuanvil.update.plugin.PUpdate_1_11_0;
import xyz.alexcrea.cuanvil.update.plugin.PUpdate_1_15_5;
import xyz.alexcrea.cuanvil.update.plugin.PUpdate_1_6_2;
import xyz.alexcrea.cuanvil.update.plugin.PUpdate_1_6_7;
import xyz.alexcrea.cuanvil.update.plugin.PUpdate_1_8_0;

public class PluginUpdates {
    private static final String CONFIG_VERSION_PATH = "configVersion";
    private static final Map<Version, Consumer<Set<ConfigHolder>>> updateMap = Map.of(new Version(1, 6, 2), PUpdate_1_6_2::handleUpdate, new Version(1, 6, 7), PUpdate_1_6_7::handleUpdate, new Version(1, 8, 0), PUpdate_1_8_0::handleUpdate, new Version(1, 11, 0), PUpdate_1_11_0::handleUpdate, new Version(1, 15, 5), PUpdate_1_15_5::handleUpdate);

    public static void handleUpdates() {
        PluginUpdates.handleMCVersionUpdate();
        PluginUpdates.handlePluginUpdate();
    }

    private static void handlePluginUpdate() {
        String versionString = ConfigHolder.DEFAULT_CONFIG.getConfig().getString(CONFIG_VERSION_PATH);
        Version current = versionString == null ? new Version(0) : Version.fromString(versionString);
        HashSet<ConfigHolder> toSave = new HashSet<ConfigHolder>();
        AtomicReference<Object> latest = new AtomicReference<Object>(null);
        updateMap.forEach((ver, consumer) -> {
            if (ver.greaterThan(current)) {
                CustomAnvil.log("handling plugin update to " + String.valueOf(ver));
                consumer.accept(toSave);
                latest.set(ver);
            }
        });
        if (latest.get() != null) {
            PluginUpdates.finishConfiguration(((Version)latest.get()).toString(), toSave);
        }
    }

    public static void handleMCVersionUpdate() {
        Version current = UpdateUtils.currentMinecraftVersion();
        boolean hadUpdate = false;
        hadUpdate |= Update_1_21.handleUpdate(current);
        if (hadUpdate |= Update_1_21_9.handleUpdate(current)) {
            CustomAnvil.instance.getLogger().info("Updating Done !");
        }
    }

    private static void finishConfiguration(@Nonnull String newVersion, @Nonnull Set<ConfigHolder> toSave) {
        CustomAnvil.instance.getLogger().info("Configuration file updated to " + newVersion);
        ConfigHolder.DEFAULT_CONFIG.getConfig().set(CONFIG_VERSION_PATH, (Object)newVersion);
        toSave.add(ConfigHolder.DEFAULT_CONFIG);
        for (ConfigHolder configHolder : toSave) {
            configHolder.saveToDisk(true);
        }
        for (ConfigHolder configHolder : toSave) {
            configHolder.reload();
        }
    }
}

