/*
 * Decompiled with CFR 0.152.
 */
package io.delilaheve.util;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\u0016\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b*\u00020\u0006J\u001e\u0010\u000b\u001a\u00020\f*\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u000eJ\u001a\u0010\u000f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u001a\u0010\u0012\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0018"}, d2={"Lio/delilaheve/util/ItemUtil;", "", "<init>", "()V", "isEnchantedBook", "", "Lorg/bukkit/inventory/ItemStack;", "findEnchantments", "", "Lxyz/alexcrea/cuanvil/enchant/CAEnchantment;", "", "setEnchantmentsUnsafe", "", "enchantments", "", "repairFrom", "first", "second", "unitRepair", "unitAmount", "percentPerUnit", "", "canMergeWith", "other", "CustomAnvil"})
@SourceDebugExtension(value={"SMAP\nItemUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemUtil.kt\nio/delilaheve/util/ItemUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,95:1\n216#2,2:96\n*S KotlinDebug\n*F\n+ 1 ItemUtil.kt\nio/delilaheve/util/ItemUtil\n*L\n32#1:96,2\n*E\n"})
public final class ItemUtil {
    @NotNull
    public static final ItemUtil INSTANCE = new ItemUtil();

    private ItemUtil() {
    }

    public final boolean isEnchantedBook(@NotNull ItemStack $this$isEnchantedBook) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnchantedBook, (String)"<this>");
        return $this$isEnchantedBook.getType() == Material.ENCHANTED_BOOK;
    }

    @NotNull
    public final Map<CAEnchantment, Integer> findEnchantments(@NotNull ItemStack $this$findEnchantments) {
        Intrinsics.checkNotNullParameter((Object)$this$findEnchantments, (String)"<this>");
        Map<CAEnchantment, Integer> map = CAEnchantment.getEnchants($this$findEnchantments);
        Intrinsics.checkNotNullExpressionValue(map, (String)"getEnchants(...)");
        return map;
    }

    public final void setEnchantmentsUnsafe(@NotNull ItemStack $this$setEnchantmentsUnsafe, @NotNull Map<CAEnchantment, Integer> enchantments) {
        Intrinsics.checkNotNullParameter((Object)$this$setEnchantmentsUnsafe, (String)"<this>");
        Intrinsics.checkNotNullParameter(enchantments, (String)"enchantments");
        CAEnchantment.clearEnchants($this$setEnchantmentsUnsafe);
        Map<CAEnchantment, Integer> $this$forEach$iv = enchantments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CAEnchantment, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CAEnchantment, Integer> element$iv;
            Map.Entry<CAEnchantment, Integer> entry = element$iv = iterator.next();
            boolean bl = false;
            CAEnchantment enchantment = entry.getKey();
            int level = ((Number)entry.getValue()).intValue();
            enchantment.addEnchantmentUnsafe($this$setEnchantmentsUnsafe, level);
        }
    }

    public final boolean repairFrom(@NotNull ItemStack $this$repairFrom, @NotNull ItemStack first, @NotNull ItemStack second) {
        Damageable damageable;
        Intrinsics.checkNotNullParameter((Object)$this$repairFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        ItemMeta itemMeta = $this$repairFrom.getItemMeta();
        Damageable damageable2 = damageable = itemMeta instanceof Damageable ? (Damageable)itemMeta : null;
        if (damageable != null) {
            int firstDamage;
            Damageable it = damageable;
            boolean bl = false;
            short durability = $this$repairFrom.getType().getMaxDurability();
            ItemMeta itemMeta2 = first.getItemMeta();
            Damageable damageable3 = itemMeta2 instanceof Damageable ? (Damageable)itemMeta2 : null;
            int n = firstDamage = damageable3 != null ? damageable3.getDamage() : 0;
            if (firstDamage == 0) {
                return false;
            }
            int firstDurability = durability - firstDamage;
            ItemMeta itemMeta3 = second.getItemMeta();
            Damageable damageable4 = itemMeta3 instanceof Damageable ? (Damageable)itemMeta3 : null;
            int secondDamage = damageable4 != null ? damageable4.getDamage() : 0;
            int secondDurability = durability - secondDamage;
            int combinedDurability = firstDurability + secondDurability;
            int newDurability = Math.min(combinedDurability, durability);
            it.setDamage(durability - newDurability);
            $this$repairFrom.setItemMeta((ItemMeta)it);
            return true;
        }
        return false;
    }

    public final int unitRepair(@NotNull ItemStack $this$unitRepair, int unitAmount, double percentPerUnit) {
        Damageable damageable;
        Intrinsics.checkNotNullParameter((Object)$this$unitRepair, (String)"<this>");
        ItemMeta itemMeta = $this$unitRepair.getItemMeta();
        Damageable damageable2 = damageable = itemMeta instanceof Damageable ? (Damageable)itemMeta : null;
        if (damageable != null) {
            Damageable it = damageable;
            boolean bl = false;
            short durability = $this$unitRepair.getType().getMaxDurability();
            int firstDamage = it.getDamage();
            if (firstDamage == 0) {
                return 0;
            }
            int unitCount = 0;
            int damage = firstDamage;
            while (unitCount < unitAmount && damage > 0) {
                damage = (int)Math.ceil((double)firstDamage - (double)durability * percentPerUnit * (double)(++unitCount));
            }
            it.setDamage(Math.max(damage, 0));
            $this$unitRepair.setItemMeta((ItemMeta)it);
            return unitCount;
        }
        return 0;
    }

    public final boolean canMergeWith(@NotNull ItemStack $this$canMergeWith, @Nullable ItemStack other) {
        Intrinsics.checkNotNullParameter((Object)$this$canMergeWith, (String)"<this>");
        return other != null && ($this$canMergeWith.getType() == other.getType() || this.isEnchantedBook(other));
    }
}

