/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.api;

import io.delilaheve.CustomAnvil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.CAEnchantmentRegistry;
import xyz.alexcrea.cuanvil.enchant.EnchantmentRarity;
import xyz.alexcrea.cuanvil.enchant.bulk.BulkCleanEnchantOperation;
import xyz.alexcrea.cuanvil.enchant.bulk.BulkGetEnchantOperation;
import xyz.alexcrea.cuanvil.enchant.wrapped.CABukkitEnchantment;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantCostConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantLimitConfigGui;

public class EnchantmentApi {
    private static Object saveChangeTask = null;

    private EnchantmentApi() {
    }

    public static boolean registerEnchantment(@NotNull CAEnchantment enchantment) {
        if (!CAEnchantmentRegistry.getInstance().register(enchantment)) {
            return false;
        }
        if (EnchantCostConfigGui.getInstance() != null) {
            EnchantCostConfigGui.getInstance().updateValueForGeneric(enchantment, true);
        }
        if (EnchantLimitConfigGui.getInstance() != null) {
            EnchantLimitConfigGui.getInstance().updateValueForGeneric(enchantment, true);
        }
        EnchantmentApi.writeDefaultConfig(enchantment, false);
        return true;
    }

    public static boolean registerEnchantment(@NotNull Enchantment enchantment, @Nullable EnchantmentRarity defaultRarity) {
        if (defaultRarity == null) {
            return EnchantmentApi.registerEnchantment(new CABukkitEnchantment(enchantment));
        }
        return EnchantmentApi.registerEnchantment(new CABukkitEnchantment(enchantment, defaultRarity));
    }

    public static boolean registerEnchantment(@NotNull Enchantment enchantment) {
        return EnchantmentApi.registerEnchantment(new CABukkitEnchantment(enchantment));
    }

    public static boolean unregisterEnchantment(@Nullable CAEnchantment enchantment) {
        if (EnchantCostConfigGui.getInstance() != null) {
            EnchantCostConfigGui.getInstance().removeGeneric(enchantment);
        }
        if (EnchantLimitConfigGui.getInstance() != null) {
            EnchantLimitConfigGui.getInstance().removeGeneric(enchantment);
        }
        return CAEnchantmentRegistry.getInstance().unregister(enchantment);
    }

    public static boolean unregisterEnchantment(@NotNull NamespacedKey key) {
        CAEnchantment enchantment = CAEnchantment.getByKey(key);
        return EnchantmentApi.unregisterEnchantment(enchantment);
    }

    public static boolean unregisterEnchantment(@NotNull Enchantment enchantment) {
        return EnchantmentApi.unregisterEnchantment(enchantment.getKey());
    }

    @Nullable
    public static CAEnchantment getByKey(@NotNull NamespacedKey key) {
        return CAEnchantment.getByKey(key);
    }

    @Deprecated(since="1.6.3")
    @Nullable
    public static CAEnchantment getByName(@NotNull String name) {
        return CAEnchantment.getByName(name);
    }

    public static List<CAEnchantment> getListByName(@NotNull String name) {
        return CAEnchantment.getListByName(name);
    }

    @NotNull
    public static Map<NamespacedKey, CAEnchantment> getRegisteredEnchantments() {
        return Collections.unmodifiableMap(CAEnchantmentRegistry.getInstance().registeredEnchantments());
    }

    public static boolean writeDefaultConfig(CAEnchantment enchantment, boolean override) {
        FileConfiguration config = ConfigHolder.DEFAULT_CONFIG.getConfig();
        if (EnchantmentApi.tryWriteDefaultConfig(config, enchantment, override)) {
            EnchantmentApi.prepareSaveTask();
        }
        return true;
    }

    private static boolean tryWriteDefaultConfig(FileConfiguration defaultConfig, CAEnchantment enchantment, boolean override) {
        boolean hasChange = false;
        String levelPath = "enchant_limits." + String.valueOf(enchantment.getKey());
        if (override || !defaultConfig.isSet(levelPath)) {
            defaultConfig.set(levelPath, (Object)enchantment.defaultMaxLevel());
            hasChange = true;
        }
        String basePath = "enchant_values." + String.valueOf(enchantment.getKey());
        EnchantmentRarity rarity = enchantment.defaultRarity();
        String itemPath = basePath + ".item";
        String bookPath = basePath + ".book";
        if (override || !defaultConfig.isSet(itemPath)) {
            defaultConfig.set(itemPath, (Object)rarity.getItemValue());
            hasChange = true;
        }
        if (override || !defaultConfig.isSet(bookPath)) {
            defaultConfig.set(bookPath, (Object)rarity.getBookValue());
            hasChange = true;
        }
        return hasChange;
    }

    private static void prepareSaveTask() {
        if (saveChangeTask != null) {
            return;
        }
        saveChangeTask = DependencyManager.scheduler.scheduleGlobally((Plugin)CustomAnvil.instance, () -> {
            ConfigHolder.DEFAULT_CONFIG.saveToDisk(true);
            saveChangeTask = null;
        });
    }

    public static void addBulkGet(@NotNull BulkGetEnchantOperation operation) {
        CAEnchantmentRegistry.getInstance().getOptimisedGetOperators().add(operation);
    }

    public static void addBulkClean(@NotNull BulkCleanEnchantOperation operation) {
        CAEnchantmentRegistry.getInstance().getOptimisedCleanOperators().add(operation);
    }
}

