/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.command;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.api.event.CAConfigReadyEvent;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.gui.config.global.BasicConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.CustomRecipeConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantConflictGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantCostConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantLimitConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.GroupConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.UnitRepairConfigGui;
import xyz.alexcrea.cuanvil.update.plugin.PluginUpdates;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Lxyz/alexcrea/cuanvil/command/ReloadExecutor;", "Lorg/bukkit/command/CommandExecutor;", "<init>", "()V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "cmd", "Lorg/bukkit/command/Command;", "cmdstr", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "commandBody", "hardfail", "CustomAnvil"})
public final class ReloadExecutor
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String cmdstr, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)cmdstr, (String)"cmdstr");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!sender.hasPermission("ca.command.reload")) {
            sender.sendMessage("\u00a7cYou do not have permission to reload the config");
            return false;
        }
        sender.sendMessage("\u00a7eReloading config...");
        boolean hardfail = !(args.length == 0) && StringsKt.equals((String)"hard", (String)args[0], (boolean)true);
        boolean commandSuccess = this.commandBody(hardfail);
        if (commandSuccess) {
            sender.sendMessage("\u00a7aConfig reloaded !");
        } else {
            sender.sendMessage("\u00a7cConfig was not able to be reloaded...");
            if (hardfail) {
                sender.sendMessage("\u00a74Hard fail, plugin disabled");
            }
        }
        return commandSuccess;
    }

    private final boolean commandBody(boolean hardfail) {
        try {
            if (!ConfigHolder.reloadAllFromDisk(hardfail)) {
                return false;
            }
            BasicConfigGui basicConfigGui = BasicConfigGui.getInstance();
            if (basicConfigGui != null) {
                basicConfigGui.updateGuiValues();
            }
            EnchantCostConfigGui enchantCostConfigGui = EnchantCostConfigGui.getInstance();
            if (enchantCostConfigGui != null) {
                enchantCostConfigGui.updateGuiValues();
            }
            EnchantLimitConfigGui enchantLimitConfigGui = EnchantLimitConfigGui.getInstance();
            if (enchantLimitConfigGui != null) {
                enchantLimitConfigGui.updateGuiValues();
            }
            EnchantConflictGui enchantConflictGui = EnchantConflictGui.getCurrentInstance();
            if (enchantConflictGui != null) {
                enchantConflictGui.reloadValues();
            }
            GroupConfigGui groupConfigGui = GroupConfigGui.getCurrentInstance();
            if (groupConfigGui != null) {
                groupConfigGui.reloadValues();
            }
            UnitRepairConfigGui unitRepairConfigGui = UnitRepairConfigGui.getCurrentInstance();
            if (unitRepairConfigGui != null) {
                unitRepairConfigGui.reloadValues();
            }
            CustomRecipeConfigGui customRecipeConfigGui = CustomRecipeConfigGui.getCurrentInstance();
            if (customRecipeConfigGui != null) {
                customRecipeConfigGui.reloadValues();
            }
            PluginUpdates.handleMCVersionUpdate();
            DependencyManager.INSTANCE.handleConfigReload();
            CAConfigReadyEvent configReadyEvent = new CAConfigReadyEvent();
            Bukkit.getServer().getPluginManager().callEvent((Event)configReadyEvent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

