/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.config;

import com.google.common.io.Files;
import io.delilaheve.CustomAnvil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.group.EnchantConflictManager;
import xyz.alexcrea.cuanvil.group.ItemGroupManager;
import xyz.alexcrea.cuanvil.recipe.CustomAnvilRecipeManager;

public abstract class ConfigHolder {
    public static DefaultConfigHolder DEFAULT_CONFIG;
    public static ItemGroupConfigHolder ITEM_GROUP_HOLDER;
    public static ConflictConfigHolder CONFLICT_HOLDER;
    public static UnitRepairHolder UNIT_REPAIR_HOLDER;
    public static CustomAnvilCraftHolder CUSTOM_RECIPE_HOLDER;
    private static final File BACKUP_FOLDER;
    protected FileConfiguration configuration;

    public static boolean loadDefaultConfig() {
        DEFAULT_CONFIG = new DefaultConfigHolder();
        return DEFAULT_CONFIG.reloadFromDisk(true);
    }

    public static boolean loadNonDefaultConfig() {
        ITEM_GROUP_HOLDER = new ItemGroupConfigHolder();
        CONFLICT_HOLDER = new ConflictConfigHolder();
        UNIT_REPAIR_HOLDER = new UnitRepairHolder();
        CUSTOM_RECIPE_HOLDER = new CustomAnvilCraftHolder();
        return ConfigHolder.removeNonDefaultFromDisk(true);
    }

    public static boolean reloadAllFromDisk(boolean hardfail) {
        boolean sucess = DEFAULT_CONFIG.reloadFromDisk(hardfail);
        if (!sucess) {
            return false;
        }
        return ConfigHolder.removeNonDefaultFromDisk(hardfail);
    }

    private static boolean removeNonDefaultFromDisk(boolean hardfail) {
        boolean sucess = ITEM_GROUP_HOLDER.reloadFromDisk(hardfail);
        if (!sucess) {
            return false;
        }
        sucess = CONFLICT_HOLDER.reloadFromDisk(hardfail);
        if (!sucess) {
            return false;
        }
        sucess = UNIT_REPAIR_HOLDER.reloadFromDisk(hardfail);
        if (!sucess) {
            return false;
        }
        sucess = CUSTOM_RECIPE_HOLDER.reloadFromDisk(hardfail);
        return sucess;
    }

    protected ConfigHolder() {
    }

    public abstract boolean reloadFromDisk(boolean var1);

    public abstract void reload();

    public FileConfiguration getConfig() {
        return this.configuration;
    }

    protected abstract String getConfigFileName();

    protected String getConfigFileExtension() {
        return ".yml";
    }

    protected File getConfigFile() {
        return new File(CustomAnvil.instance.getDataFolder(), this.getConfigFileName() + this.getConfigFileExtension());
    }

    protected File getFirstBackup() {
        return new File(BACKUP_FOLDER, this.getConfigFileName() + "-first" + this.getConfigFileExtension());
    }

    protected File getLastBackup() {
        return new File(BACKUP_FOLDER, this.getConfigFileName() + "-latest" + this.getConfigFileExtension());
    }

    public boolean saveToDisk(boolean doBackup) {
        CustomAnvil.Companion.log("Saving " + this.getConfigFileName());
        if (doBackup && !this.saveBackup()) {
            CustomAnvil.instance.getLogger().severe("Could not save backup. see above.");
            return false;
        }
        File base = this.getConfigFile();
        if (base.exists() && !base.delete()) {
            CustomAnvil.instance.getLogger().severe("Could not save config: can't delete existing file.");
            return false;
        }
        FileConfiguration config = this.getConfig();
        try {
            config.save(base);
        }
        catch (IOException e) {
            e.printStackTrace();
            CustomAnvil.instance.getLogger().severe("Could not save config...");
            return false;
        }
        CustomAnvil.Companion.log(this.getConfigFileName() + " saved successfully");
        return true;
    }

    protected boolean saveBackup() {
        File lastBackup;
        File base = this.getConfigFile();
        if (!base.exists()) {
            return true;
        }
        boolean sufficientSuccess = false;
        BACKUP_FOLDER.mkdirs();
        File firstBackup = this.getFirstBackup();
        if (!firstBackup.exists()) {
            try {
                Files.copy((File)base, (File)firstBackup);
                sufficientSuccess = true;
            }
            catch (IOException e) {
                CustomAnvil.instance.getLogger().log(Level.WARNING, "Could not copy backup saving config " + base.getName(), e);
            }
        }
        if ((lastBackup = this.getLastBackup()).exists() && !lastBackup.delete()) {
            return sufficientSuccess;
        }
        try {
            Files.move((File)base, (File)lastBackup);
            sufficientSuccess = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sufficientSuccess;
    }

    static {
        BACKUP_FOLDER = new File(CustomAnvil.instance.getDataFolder(), "backup");
    }

    public static class DefaultConfigHolder
    extends ConfigHolder {
        @Override
        protected String getConfigFileName() {
            return "config";
        }

        @Override
        public boolean reloadFromDisk(boolean hardFail) {
            CustomAnvil.instance.saveDefaultConfig();
            CustomAnvil.instance.reloadConfig();
            this.configuration = CustomAnvil.instance.getConfig();
            return true;
        }

        @Override
        public void reload() {
        }
    }

    public static class ItemGroupConfigHolder
    extends DeletableResource {
        private static final String FILE_NAME = "item_groups";
        ItemGroupManager itemGroupsManager;

        private ItemGroupConfigHolder() {
            super(FILE_NAME);
        }

        public ItemGroupManager getItemGroupsManager() {
            return this.itemGroupsManager;
        }

        @Override
        public void reload() {
            this.itemGroupsManager = new ItemGroupManager();
            this.itemGroupsManager.prepareGroups((ConfigurationSection)this.configuration);
            if (CONFLICT_HOLDER.getConfig() != null) {
                CONFLICT_HOLDER.reload();
            }
        }
    }

    public static class ConflictConfigHolder
    extends DeletableResource {
        private static final String FILE_NAME = "enchant_conflict";
        EnchantConflictManager conflictManager;

        private ConflictConfigHolder() {
            super(FILE_NAME);
        }

        public EnchantConflictManager getConflictManager() {
            return this.conflictManager;
        }

        @Override
        public void reload() {
            this.conflictManager = new EnchantConflictManager();
            this.conflictManager.prepareConflicts((ConfigurationSection)this.configuration, ITEM_GROUP_HOLDER.getItemGroupsManager());
        }
    }

    public static class UnitRepairHolder
    extends DeletableResource {
        private static final String ITEM_GROUP_FILE_NAME = "unit_repair_item";

        private UnitRepairHolder() {
            super(ITEM_GROUP_FILE_NAME);
        }

        @Override
        public void reload() {
        }
    }

    public static class CustomAnvilCraftHolder
    extends DeletableResource {
        private static final String CUSTOM_RECIPE_FILE_NAME = "custom_recipes";
        CustomAnvilRecipeManager recipeManager;

        private CustomAnvilCraftHolder() {
            super(CUSTOM_RECIPE_FILE_NAME);
        }

        public CustomAnvilRecipeManager getRecipeManager() {
            return this.recipeManager;
        }

        @Override
        public void reload() {
            this.recipeManager = new CustomAnvilRecipeManager();
            this.recipeManager.prepareRecipes(this.configuration);
        }
    }

    public static abstract class DeletableResource
    extends ResourceConfigHolder {
        private static final String DELETED_FOLDER_PATH = "deleted";
        @NotNull
        private final File parent = new File(CustomAnvil.instance.getDataFolder(), "deleted");
        @NotNull
        private final File deletedConfigFile;
        @Nullable
        private YamlConfiguration deletedListConfig;

        private DeletableResource(String resourceName) {
            super(resourceName);
            this.deletedConfigFile = new File(this.parent, "deleted_" + resourceName + this.getConfigFileExtension());
        }

        @Override
        public boolean reloadFromDisk(boolean hardFail) {
            if (!super.reloadFromDisk(hardFail)) {
                return false;
            }
            this.loadDeletedListFile(hardFail);
            return true;
        }

        private void loadDeletedListFile(boolean hardFail) {
            this.deletedListConfig = CustomAnvil.instance.reloadResource(this.deletedConfigFile, hardFail);
        }

        public boolean isDeleted(String objectPath) {
            if (this.deletedListConfig == null) {
                return false;
            }
            return this.deletedListConfig.getBoolean(objectPath, false);
        }

        public boolean delete(String objectPath) {
            return this.delete(objectPath, false, false);
        }

        public boolean delete(String objectPath, boolean doSave, boolean doBackup) {
            if (this.deletedListConfig == null) {
                this.parent.mkdirs();
                try {
                    this.deletedConfigFile.createNewFile();
                }
                catch (IOException e) {
                    CustomAnvil.instance.getLogger().log(Level.WARNING, "Could not create " + this.deletedConfigFile.getPath(), e);
                }
                this.loadDeletedListFile(false);
                if (this.deletedListConfig == null) {
                    return false;
                }
            }
            this.deletedListConfig.set(objectPath, (Object)true);
            this.getConfig().set(objectPath, null);
            if (doSave) {
                return this.saveToDisk(doBackup);
            }
            return true;
        }

        @Override
        public boolean saveToDisk(boolean doBackup) {
            boolean deletedSaveSuccess = this.saveDeletedList();
            return super.saveToDisk(doBackup) && deletedSaveSuccess;
        }

        public boolean saveDeletedList() {
            if (this.deletedListConfig == null) {
                return true;
            }
            try {
                this.deletedListConfig.save(this.deletedConfigFile);
            }
            catch (IOException e) {
                CustomAnvil.instance.getLogger().log(Level.WARNING, "Could not save " + this.deletedConfigFile.getPath(), e);
                return false;
            }
            return true;
        }
    }

    public static abstract class ResourceConfigHolder
    extends ConfigHolder {
        String resourceName;

        private ResourceConfigHolder(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        protected String getConfigFileName() {
            return this.resourceName;
        }

        @Override
        public boolean reloadFromDisk(boolean hardFail) {
            YamlConfiguration configuration = CustomAnvil.instance.reloadResource(this.getConfigFileName() + this.getConfigFileExtension(), hardFail);
            if (configuration == null) {
                return false;
            }
            this.configuration = configuration;
            this.reload();
            return true;
        }
    }
}

