/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.enchant.wrapped;

import com.willfp.ecoenchants.enchantments.EcoEnchant;
import com.willfp.ecoenchants.enchantments.meta.EnchantmentTarget;
import com.willfp.ecoenchants.enchantments.meta.EnchantmentType;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.enchant.AdditionalTestEnchantment;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.EnchantmentRarity;
import xyz.alexcrea.cuanvil.enchant.wrapped.CABukkitEnchantment;

public class CALegacyEcoEnchant
extends CABukkitEnchantment
implements AdditionalTestEnchantment {
    @NotNull
    private final EcoEnchant ecoEnchant;

    public CALegacyEcoEnchant(@NotNull EcoEnchant ecoEnchant, @NotNull Enchantment enchantment) {
        super(enchantment, EnchantmentRarity.COMMON);
        this.ecoEnchant = ecoEnchant;
    }

    @Override
    public boolean isEnchantConflict(@NotNull Map<CAEnchantment, Integer> enchantments, @NotNull Material itemMat) {
        if (enchantments.isEmpty()) {
            return false;
        }
        EnchantmentType type = this.ecoEnchant.getType();
        boolean isSingular = type.isSingular();
        for (CAEnchantment other : enchantments.keySet()) {
            CABukkitEnchantment otherVanilla;
            if (other instanceof CABukkitEnchantment && this.ecoEnchant.conflictsWith((otherVanilla = (CABukkitEnchantment)other).getEnchant())) {
                return true;
            }
            if (!isSingular || other == this || !(other instanceof CALegacyEcoEnchant)) continue;
            CALegacyEcoEnchant otherEco = (CALegacyEcoEnchant)other;
            if (!type.equals(otherEco.ecoEnchant.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isItemConflict(@NotNull Map<CAEnchantment, Integer> enchantments, @NotNull Material itemMat, @NotNull ItemStack item) {
        if (Material.ENCHANTED_BOOK.equals((Object)itemMat)) {
            return false;
        }
        for (EnchantmentTarget target : this.ecoEnchant.getTargets()) {
            if (!target.getMaterials().contains(itemMat)) continue;
            return false;
        }
        return true;
    }
}

