/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.group;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.enchant.AdditionalTestEnchantment;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.CAEnchantmentRegistry;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;
import xyz.alexcrea.cuanvil.group.ConflictType;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;
import xyz.alexcrea.cuanvil.group.IncludeGroup;
import xyz.alexcrea.cuanvil.group.ItemGroupManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J \u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001cJ$\u0010*\u001a\u00020(2\u0006\u0010'\u001a\u00020(2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020&0%H\u0002R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lxyz/alexcrea/cuanvil/group/EnchantConflictManager;", "", "<init>", "()V", "conflictList", "Ljava/util/ArrayList;", "Lxyz/alexcrea/cuanvil/group/EnchantConflictGroup;", "getConflictList", "()Ljava/util/ArrayList;", "setConflictList", "(Ljava/util/ArrayList;)V", "prepareConflicts", "", "config", "Lorg/bukkit/configuration/ConfigurationSection;", "itemManager", "Lxyz/alexcrea/cuanvil/group/ItemGroupManager;", "addConflict", "conflict", "removeConflict", "addConflictToEnchantments", "removeConflictFromEnchantments", "createConflict", "section", "conflictName", "", "getEnchantByIdentifier", "", "Lxyz/alexcrea/cuanvil/enchant/CAEnchantment;", "enchantName", "createConflictObject", "findGroup", "Lxyz/alexcrea/cuanvil/group/AbstractMaterialGroup;", "groupName", "isConflicting", "Lxyz/alexcrea/cuanvil/group/ConflictType;", "appliedEnchants", "", "", "item", "Lorg/bukkit/inventory/ItemStack;", "newEnchant", "createPartialResult", "enchantments", "Companion", "CustomAnvil"})
@SourceDebugExtension(value={"SMAP\nEnchantConflictManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantConflictManager.kt\nxyz/alexcrea/cuanvil/group/EnchantConflictManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,266:1\n1863#2,2:267\n1863#2,2:269\n216#3,2:271\n*S KotlinDebug\n*F\n+ 1 EnchantConflictManager.kt\nxyz/alexcrea/cuanvil/group/EnchantConflictManager\n*L\n73#1:267,2\n80#1:269,2\n231#1:271,2\n*E\n"})
public final class EnchantConflictManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public ArrayList<EnchantConflictGroup> conflictList;
    @NotNull
    public static final String ENCH_LIST_PATH = "enchantments";
    @NotNull
    public static final String CONFLICT_GROUP_PATH = "notAffectedGroups";
    @NotNull
    public static final String ENCH_MAX_PATH = "maxEnchantmentBeforeConflict";
    @NotNull
    private static final String FUTURE_USE_PATH = "useInFuture";
    @NotNull
    public static final String DEFAULT_GROUP_NAME = "joinedGroup";
    private static final List<CAEnchantment> SWEEPING_EDGE_ENCHANT;

    @NotNull
    public final ArrayList<EnchantConflictGroup> getConflictList() {
        ArrayList<EnchantConflictGroup> arrayList = this.conflictList;
        if (arrayList != null) {
            return arrayList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"conflictList");
        return null;
    }

    public final void setConflictList(@NotNull ArrayList<EnchantConflictGroup> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.conflictList = arrayList;
    }

    public final void prepareConflicts(@NotNull ConfigurationSection config, @NotNull ItemGroupManager itemManager) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)itemManager, (String)"itemManager");
        this.setConflictList(new ArrayList<EnchantConflictGroup>());
        for (CAEnchantment enchant : CAEnchantmentRegistry.getInstance().values()) {
            enchant.clearConflict();
        }
        Set set = config.getKeys(false);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getKeys(...)");
        Set keys = set;
        for (String key : keys) {
            ConfigurationSection section;
            Intrinsics.checkNotNull((Object)config.getConfigurationSection(key));
            Intrinsics.checkNotNull((Object)key);
            EnchantConflictGroup conflict = this.createConflict(section, itemManager, key);
            this.addConflict(conflict);
        }
    }

    public final void addConflict(@NotNull EnchantConflictGroup conflict) {
        Intrinsics.checkNotNullParameter((Object)conflict, (String)"conflict");
        this.addConflictToEnchantments(conflict);
        this.getConflictList().add(conflict);
    }

    public final void removeConflict(@NotNull EnchantConflictGroup conflict) {
        Intrinsics.checkNotNullParameter((Object)conflict, (String)"conflict");
        this.removeConflictFromEnchantments(conflict);
        this.getConflictList().remove(conflict);
    }

    private final void addConflictToEnchantments(EnchantConflictGroup conflict) {
        Iterable $this$forEach$iv = conflict.getEnchants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CAEnchantment enchant = (CAEnchantment)element$iv;
            boolean bl = false;
            enchant.addConflict(conflict);
        }
    }

    private final void removeConflictFromEnchantments(EnchantConflictGroup conflict) {
        Iterable $this$forEach$iv = conflict.getEnchants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CAEnchantment enchant = (CAEnchantment)element$iv;
            boolean bl = false;
            enchant.removeConflict(conflict);
        }
    }

    private final EnchantConflictGroup createConflict(ConfigurationSection section, ItemGroupManager itemManager, String conflictName) {
        boolean futureUse = section.getBoolean(FUTURE_USE_PATH, false);
        EnchantConflictGroup conflict = this.createConflictObject(section, itemManager, conflictName);
        List list = section.getStringList(ENCH_LIST_PATH);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringList(...)");
        List enchantList = list;
        for (String enchantName : enchantList) {
            Intrinsics.checkNotNull((Object)enchantName);
            List<CAEnchantment> enchants = this.getEnchantByIdentifier(enchantName);
            if (enchants.isEmpty()) {
                if (futureUse) continue;
                CustomAnvil.Companion.getInstance().getLogger().warning("Enchantment " + enchantName + " do not exist but was asked for conflict " + conflictName);
                continue;
            }
            conflict.addEnchantments(enchants);
        }
        if (conflict.getEnchants().isEmpty() && !futureUse) {
            CustomAnvil.Companion.getInstance().getLogger().warning("Conflict " + conflictName + " do not have valid enchantment, it will not do anything");
        }
        return conflict;
    }

    /*
     * Unable to fully structure code
     */
    private final List<CAEnchantment> getEnchantByIdentifier(String enchantName) {
        key = NamespacedKey.fromString((String)enchantName);
        if (key != null && (enchantment = CAEnchantment.getByKey(key)) != null) {
            v0 = Collections.singletonList(enchantment);
            Intrinsics.checkNotNullExpressionValue(v0, (String)"singletonList(...)");
            return v0;
        }
        var3_3 = enchantName;
        switch (var3_3.hashCode()) {
            case 816230563: {
                if (!var3_3.equals("minecraft:sweeping")) {
                    break;
                }
                ** GOTO lbl22
            }
            case -1056264474: {
                if (!var3_3.equals("sweeping_edge")) {
                    break;
                }
                ** GOTO lbl22
            }
            case -1214815271: {
                if (!var3_3.equals("minecraft:sweeping_edge")) {
                    break;
                }
                ** GOTO lbl22
            }
            case -213257866: {
                if (!var3_3.equals("sweeping")) break;
lbl22:
                // 4 sources

                v1 = EnchantConflictManager.SWEEPING_EDGE_ENCHANT;
                Intrinsics.checkNotNullExpressionValue(v1, (String)"SWEEPING_EDGE_ENCHANT");
                return v1;
            }
        }
        v2 = CAEnchantment.getListByName(enchantName);
        Intrinsics.checkNotNullExpressionValue(v2, (String)"getListByName(...)");
        return v2;
    }

    private final EnchantConflictGroup createConflictObject(ConfigurationSection section, ItemGroupManager itemManager, String conflictName) {
        int minBeforeBlock = section.getInt(ENCH_MAX_PATH, 0);
        if (minBeforeBlock < 0) {
            minBeforeBlock = 0;
            CustomAnvil.Companion.getInstance().getLogger().warning("Conflict " + conflictName + " have an invalid value of maxEnchantmentBeforeConflict");
            CustomAnvil.Companion.getInstance().getLogger().warning("It should be more or equal to 0. default to 0");
        }
        List list = section.getStringList(CONFLICT_GROUP_PATH);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringList(...)");
        List groupList = list;
        IncludeGroup finalGroup = new IncludeGroup(DEFAULT_GROUP_NAME);
        for (String groupName : groupList) {
            Intrinsics.checkNotNull((Object)groupName);
            finalGroup.addToPolicy(this.findGroup(groupName, itemManager, conflictName));
        }
        return new EnchantConflictGroup(conflictName, finalGroup, minBeforeBlock);
    }

    private final AbstractMaterialGroup findGroup(String groupName, ItemGroupManager itemManager, String conflictName) {
        AbstractMaterialGroup group = itemManager.get(groupName);
        if (group == null) {
            CustomAnvil.Companion.getInstance().getLogger().warning("Material group " + groupName + " do not exist but is ask by conflict " + conflictName);
            return new IncludeGroup("error_placeholder");
        }
        return group;
    }

    @NotNull
    public final ConflictType isConflicting(@NotNull Map<CAEnchantment, Integer> appliedEnchants, @NotNull ItemStack item, @NotNull CAEnchantment newEnchant) {
        Intrinsics.checkNotNullParameter(appliedEnchants, (String)"appliedEnchants");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)newEnchant, (String)"newEnchant");
        Material material = item.getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        Material mat = material;
        CustomAnvil.Companion.verboseLog("Testing conflict for " + newEnchant.getKey() + " on " + mat.getKey());
        Collection<EnchantConflictGroup> collection = newEnchant.getConflicts();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getConflicts(...)");
        Collection<EnchantConflictGroup> conflictList = collection;
        ConflictType result = ConflictType.NO_CONFLICT;
        for (EnchantConflictGroup enchantConflictGroup : conflictList) {
            boolean isBigConflict;
            boolean bl = isBigConflict = enchantConflictGroup.getEnchants().size() > 1;
            if (result == ConflictType.ITEM_CONFLICT && !isBigConflict) {
                CustomAnvil.Companion.verboseLog("skipping small conflict " + enchantConflictGroup.getName());
                continue;
            }
            boolean allowed = enchantConflictGroup.allowed(appliedEnchants.keySet(), mat);
            CustomAnvil.Companion.verboseLog("Was against " + enchantConflictGroup + " and conflicting: " + !allowed + " ");
            if (allowed) continue;
            if (enchantConflictGroup.getEnchants().size() <= 1) {
                result = ConflictType.ITEM_CONFLICT;
                CustomAnvil.Companion.verboseLog("Small conflict (" + enchantConflictGroup.getName() + "), continuing");
                continue;
            }
            CustomAnvil.Companion.verboseLog("Big conflict (" + enchantConflictGroup.getName() + "), stopping");
            return ConflictType.ENCHANTMENT_CONFLICT;
        }
        Map<CAEnchantment, Integer> immutableEnchants = Collections.unmodifiableMap(appliedEnchants);
        for (CAEnchantment appliedEnchant : appliedEnchants.keySet()) {
            boolean doConflict;
            if (!(appliedEnchant instanceof AdditionalTestEnchantment) || !(doConflict = ((AdditionalTestEnchantment)((Object)appliedEnchant)).isEnchantConflict(immutableEnchants, mat))) continue;
            CustomAnvil.Companion.verboseLog("Big conflict by additional test, stopping");
            return ConflictType.ENCHANTMENT_CONFLICT;
        }
        if (result != ConflictType.ITEM_CONFLICT && newEnchant instanceof AdditionalTestEnchantment) {
            Intrinsics.checkNotNull(immutableEnchants);
            ItemStack itemStack = this.createPartialResult(item, immutableEnchants);
            if (((AdditionalTestEnchantment)((Object)newEnchant)).isItemConflict(immutableEnchants, mat, itemStack)) {
                return ConflictType.ITEM_CONFLICT;
            }
        }
        return result;
    }

    private final ItemStack createPartialResult(ItemStack item, Map<CAEnchantment, Integer> enchantments) {
        ItemStack itemStack = item.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack newItem = itemStack;
        CAEnchantment.clearEnchants(newItem);
        Map<CAEnchantment, Integer> $this$forEach$iv = enchantments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CAEnchantment, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CAEnchantment, Integer> element$iv;
            Map.Entry<CAEnchantment, Integer> enchantment = element$iv = iterator.next();
            boolean bl = false;
            enchantment.getKey().addEnchantmentUnsafe(newItem, ((Number)enchantment.getValue()).intValue());
        }
        return newItem;
    }

    static {
        CAEnchantment cAEnchantment = CAEnchantment.getByKey(NamespacedKey.minecraft((String)"sweeping_edge"));
        if (cAEnchantment == null) {
            cAEnchantment = CAEnchantment.getByKey(Enchantment.SWEEPING_EDGE.getKey());
        }
        SWEEPING_EDGE_ENCHANT = Collections.singletonList(cAEnchantment);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R4\u0010\n\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lxyz/alexcrea/cuanvil/group/EnchantConflictManager$Companion;", "", "<init>", "()V", "ENCH_LIST_PATH", "", "CONFLICT_GROUP_PATH", "ENCH_MAX_PATH", "FUTURE_USE_PATH", "DEFAULT_GROUP_NAME", "SWEEPING_EDGE_ENCHANT", "", "Lxyz/alexcrea/cuanvil/enchant/CAEnchantment;", "kotlin.jvm.PlatformType", "", "Ljava/util/List;", "CustomAnvil"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

