/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config;

import io.delilaheve.CustomAnvil;
import java.util.Collections;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import xyz.alexcrea.cuanvil.dependency.packet.PacketManager;
import xyz.alexcrea.cuanvil.gui.config.global.BasicConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.CustomRecipeConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantConflictGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantCostConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantLimitConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantMergeLimitConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.GroupConfigGui;
import xyz.alexcrea.cuanvil.gui.config.global.UnitRepairConfigGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.ChestGui;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.Pane;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class MainConfigGui
extends ChestGui {
    private static final MainConfigGui INSTANCE = new MainConfigGui();

    public static MainConfigGui getInstance() {
        return INSTANCE;
    }

    private MainConfigGui() {
        super(3, "\u00a78Anvil Config", (Plugin)CustomAnvil.instance);
    }

    public void init(PacketManager packetManager) {
        Pattern pattern = new Pattern(new String[]{"000000000", "012345678", "Q00000000"});
        PatternPane pane = new PatternPane(0, 0, 9, 3, pattern);
        this.addPane((Pane)pane);
        GuiGlobalItems.addBackgroundItem(pane);
        ItemStack basicConfigItemstack = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta basicConfigMeta = basicConfigItemstack.getItemMeta();
        assert (basicConfigMeta != null);
        basicConfigMeta.setDisplayName("\u00a7aBasic Config Menu");
        basicConfigMeta.setLore(Collections.singletonList("\u00a77Click here to open basic config menu"));
        basicConfigItemstack.setItemMeta(basicConfigMeta);
        GuiItem basicConfigItem = GuiGlobalItems.goToGuiItem(basicConfigItemstack, (Gui)new BasicConfigGui(packetManager));
        pane.bindItem('1', basicConfigItem);
        ItemStack enchantLimitItemstack = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta enchantLimitMeta = enchantLimitItemstack.getItemMeta();
        assert (enchantLimitMeta != null);
        enchantLimitMeta.setDisplayName("\u00a7aEnchantment Level Limit");
        enchantLimitMeta.setLore(Collections.singletonList("\u00a77Click here to open enchantment level limit menu"));
        enchantLimitItemstack.setItemMeta(enchantLimitMeta);
        GuiItem enchantLimitItem = GuiGlobalItems.goToGuiItem(enchantLimitItemstack, (Gui)new EnchantLimitConfigGui());
        pane.bindItem('2', enchantLimitItem);
        ItemStack enchantMergeLimitItemstack = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta enchantMergeLimitMeta = enchantMergeLimitItemstack.getItemMeta();
        assert (enchantMergeLimitMeta != null);
        enchantMergeLimitMeta.setDisplayName("\u00a7aEnchantment Merge Limit");
        enchantMergeLimitMeta.setLore(Collections.singletonList("\u00a77Click here to open enchantment merge limit menu"));
        enchantMergeLimitItemstack.setItemMeta(enchantMergeLimitMeta);
        GuiItem enchantMergeLimitItem = GuiGlobalItems.goToGuiItem(enchantMergeLimitItemstack, (Gui)new EnchantMergeLimitConfigGui());
        pane.bindItem('3', enchantMergeLimitItem);
        ItemStack enchantCostItemstack = new ItemStack(Material.EXPERIENCE_BOTTLE);
        ItemMeta enchantCostMeta = enchantCostItemstack.getItemMeta();
        assert (enchantCostMeta != null);
        enchantCostMeta.setDisplayName("\u00a7aEnchantment Cost");
        enchantCostMeta.setLore(Collections.singletonList("\u00a77Click here to open enchantment costs menu"));
        enchantCostItemstack.setItemMeta(enchantCostMeta);
        GuiItem enchantCostItem = GuiGlobalItems.goToGuiItem(enchantCostItemstack, (Gui)new EnchantCostConfigGui());
        pane.bindItem('4', enchantCostItem);
        ItemStack enchantConflictItemstack = new ItemStack(Material.OAK_FENCE);
        ItemMeta enchantConflictMeta = enchantConflictItemstack.getItemMeta();
        assert (enchantConflictMeta != null);
        enchantConflictMeta.setDisplayName("\u00a7aEnchantment Conflict");
        enchantConflictMeta.setLore(Collections.singletonList("\u00a77Click here to open enchantment conflict menu"));
        enchantConflictItemstack.setItemMeta(enchantConflictMeta);
        GuiItem enchantConflictItem = GuiGlobalItems.goToGuiItem(enchantConflictItemstack, (Gui)EnchantConflictGui.getInstance());
        pane.bindItem('5', enchantConflictItem);
        ItemStack groupItemstack = new ItemStack(Material.CHEST);
        ItemMeta groupMeta = groupItemstack.getItemMeta();
        assert (groupMeta != null);
        groupMeta.setDisplayName("\u00a7aItem Groups");
        groupMeta.setLore(Collections.singletonList("\u00a77Click here to open item group menu"));
        groupItemstack.setItemMeta(groupMeta);
        GuiItem groupConfigItem = GuiGlobalItems.goToGuiItem(groupItemstack, (Gui)GroupConfigGui.getInstance());
        pane.bindItem('6', groupConfigItem);
        ItemStack unirRepairItemstack = new ItemStack(Material.DIAMOND);
        ItemMeta unitRepairMeta = unirRepairItemstack.getItemMeta();
        assert (unitRepairMeta != null);
        unitRepairMeta.setDisplayName("\u00a7aUnit Repair");
        unitRepairMeta.setLore(Collections.singletonList("\u00a77Click here to open anvil unit repair menu"));
        unirRepairItemstack.setItemMeta(unitRepairMeta);
        GuiItem unitRepairItem = GuiGlobalItems.goToGuiItem(unirRepairItemstack, (Gui)UnitRepairConfigGui.getInstance());
        pane.bindItem('7', unitRepairItem);
        ItemStack customRecipeItemstack = new ItemStack(Material.CRAFTING_TABLE);
        ItemMeta customRecipeMeta = customRecipeItemstack.getItemMeta();
        assert (customRecipeMeta != null);
        customRecipeMeta.setDisplayName("\u00a7aCustom recipes");
        customRecipeMeta.setLore(Collections.singletonList("\u00a77Click here to open anvil custom recipe menu"));
        customRecipeItemstack.setItemMeta(customRecipeMeta);
        GuiItem customRecipeItem = GuiGlobalItems.goToGuiItem(customRecipeItemstack, (Gui)CustomRecipeConfigGui.getInstance());
        pane.bindItem('8', customRecipeItem);
        ItemStack quitItemstack = new ItemStack(Material.BARRIER);
        ItemMeta quitMeta = quitItemstack.getItemMeta();
        assert (quitMeta != null);
        quitMeta.setDisplayName("\u00a7cQuit");
        quitItemstack.setItemMeta(quitMeta);
        GuiItem quitItem = new GuiItem(quitItemstack, event -> {
            event.setCancelled(true);
            event.getWhoClicked().closeInventory();
        }, (Plugin)CustomAnvil.instance);
        pane.bindItem('Q', quitItem);
    }
}

