/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.ask;

import io.delilaheve.CustomAnvil;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.config.ask.AbstractAskGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.cuanvil.gui.util.GuiSharedConstant;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class ConfirmActionGui
extends AbstractAskGui {
    public ConfirmActionGui(@NotNull String title, String actionDescription, Gui backOnCancel, Gui backOnConfirm, Supplier<Boolean> onConfirm, boolean permanent) {
        super(3, title, backOnCancel);
        this.pane.bindItem('S', new GuiItem(permanent ? GuiSharedConstant.CONFIRM_PERMANENT_ITEM : GuiSharedConstant.CONFIRM_ITEM, event -> {
            boolean success;
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage("\u00a7cYou do not have permission to edit the config");
                return;
            }
            try {
                success = (Boolean)onConfirm.get();
            }
            catch (Exception e) {
                CustomAnvil.instance.getLogger().log(Level.WARNING, "Could not process confirmation supplier.", e);
                success = false;
            }
            if (!success) {
                event.getWhoClicked().sendMessage("\u00a7cAction could not be completed. ");
            }
            backOnConfirm.show(player);
        }, (Plugin)CustomAnvil.instance));
        ItemStack infoItem = new ItemStack(Material.PAPER);
        ItemMeta infoMeta = infoItem.getItemMeta();
        infoMeta.setDisplayName("\u00a7eAre you sure ?");
        if (actionDescription != null) {
            infoMeta.setLore(Arrays.asList(actionDescription.split("\n")));
        }
        infoItem.setItemMeta(infoMeta);
        this.pane.bindItem('I', new GuiItem(infoItem, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance));
    }

    public ConfirmActionGui(@NotNull String title, String actionDescription, Gui backOnCancel, Gui backOnConfirm, Supplier<Boolean> onConfirm) {
        this(title, actionDescription, backOnCancel, backOnConfirm, onConfirm, true);
    }

    @Override
    protected Pattern getGuiPattern() {
        return new Pattern(new String[]{"000000000", "00B0I0S00", "000000000"});
    }
}

