/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.global;

import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.config.list.MappedGuiListConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.elements.CustomRecipeSubSettingGui;
import xyz.alexcrea.cuanvil.recipe.AnvilCustomRecipe;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;

public class CustomRecipeConfigGui
extends MappedGuiListConfigGui<AnvilCustomRecipe, MappedGuiListConfigGui.LazyElement<CustomRecipeSubSettingGui>> {
    private static CustomRecipeConfigGui INSTANCE = new CustomRecipeConfigGui();

    @Nullable
    public static CustomRecipeConfigGui getCurrentInstance() {
        return INSTANCE;
    }

    @NotNull
    public static CustomRecipeConfigGui getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomRecipeConfigGui();
        }
        return INSTANCE;
    }

    private CustomRecipeConfigGui() {
        super("Custom Recipe Config");
        this.init();
    }

    @Override
    protected ItemStack createItemForGeneric(AnvilCustomRecipe recipe) {
        ItemStack craftResultItem = recipe.getResultItem();
        ItemStack displayedItem = craftResultItem == null ? new ItemStack(Material.BARRIER) : craftResultItem.clone();
        ItemMeta meta = displayedItem.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(recipe.toString()) + " \u00a7fCustom recipe");
        meta.addItemFlags(ItemFlag.values());
        meta.setLore(CustomRecipeConfigGui.getRecipeLore(recipe));
        displayedItem.setItemMeta(meta);
        return displayedItem;
    }

    @NotNull
    private static ArrayList<String> getRecipeLore(AnvilCustomRecipe recipe) {
        boolean shouldWork = recipe.validate();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Is valid:    \u00a7" + (shouldWork ? "aYes" : "cNo"));
        lore.add("\u00a77Exact count:    \u00a7" + (recipe.getExactCount() ? "aYes" : "cNo"));
        lore.add("\u00a77Recipe Level Cost: \u00a7e" + recipe.getLevelCostPerCraft());
        lore.add("\u00a77Recipe Linear Xp Cost: \u00a7e" + recipe.getXpCostPerCraft());
        if (recipe.getXpCostPerCraft() != 0) {
            lore.add("\u00a77Exact Linear xp remove:    \u00a7" + (recipe.getRemoveExactLinearXp() ? "aYes" : "cNo"));
        }
        return lore;
    }

    @Override
    protected MappedGuiListConfigGui.LazyElement<CustomRecipeSubSettingGui> newInstanceOfGui(AnvilCustomRecipe generic, GuiItem item) {
        return new MappedGuiListConfigGui.LazyElement<CustomRecipeSubSettingGui>(item, () -> new CustomRecipeSubSettingGui(this, generic));
    }

    @Override
    protected String genericDisplayedName() {
        return "custom recipe";
    }

    @Override
    protected AnvilCustomRecipe createAndSaveNewEmptyGeneric(String name) {
        AnvilCustomRecipe recipe = new AnvilCustomRecipe(name, true, 1, 0, false, AnvilCustomRecipe.Companion.getDEFAULT_LEFT_ITEM_CONFIG(), AnvilCustomRecipe.Companion.getDEFAULT_RIGHT_ITEM_CONFIG(), AnvilCustomRecipe.Companion.getDEFAULT_RESULT_ITEM_CONFIG());
        ConfigHolder.CUSTOM_RECIPE_HOLDER.getRecipeManager().cleanAddNew(recipe);
        recipe.saveToFile(true, true);
        return recipe;
    }

    @Override
    protected Collection<AnvilCustomRecipe> getEveryDisplayableInstanceOfGeneric() {
        return ConfigHolder.CUSTOM_RECIPE_HOLDER.getRecipeManager().getRecipeList();
    }
}

