/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.config.ask.SelectItemTypeGui;
import xyz.alexcrea.cuanvil.gui.config.global.UnitRepairConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.SettingGuiListConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.elements.ElementMappedToListGui;
import xyz.alexcrea.cuanvil.gui.config.settings.DoubleSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;

public class UnitRepairElementListGui
extends SettingGuiListConfigGui<String, DoubleSettingGui.DoubleSettingFactory>
implements ElementMappedToListGui {
    private final Material parentMaterial;
    private final UnitRepairConfigGui parentGui;
    private final String materialName;
    private boolean shouldWork = true;

    public UnitRepairElementListGui(@NotNull Material parentMaterial, @NotNull UnitRepairConfigGui parentGui) {
        super("\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(parentMaterial.name().toLowerCase()) + " \u00a7rUnit repair");
        this.parentMaterial = parentMaterial;
        this.parentGui = parentGui;
        this.materialName = CasedStringUtil.snakeToUpperSpacedCase(parentMaterial.name().toLowerCase());
        GuiGlobalItems.addBackItem(this.backgroundPane, (Gui)parentGui);
    }

    @Override
    protected List<String> getCreateItemLore() {
        return Arrays.asList("\u00a77Select a new item to be repairable.", "\u00a77You will be asked the material to use.");
    }

    @Override
    protected Consumer<InventoryClickEvent> getCreateClickConsumer() {
        return event -> {
            event.setCancelled(true);
            if (!this.shouldWork) {
                return;
            }
            event.setCancelled(true);
            new SelectItemTypeGui("Select item to be repaired.", "\u00a77Click here with an item to set the item\n\u00a77You like to be repaired by " + this.materialName, (Gui)this, (itemStack, player) -> {
                ItemMeta meta = itemStack.getItemMeta();
                Material type = itemStack.getType();
                if (!(meta instanceof Damageable) || type.getMaxDurability() <= 0) {
                    player.sendMessage("\u00a7cThis item can't be damaged, so it can't be repaired.");
                    return;
                }
                if (type == this.parentMaterial) {
                    player.sendMessage("\u00a7cItem can't repair something of the same type.");
                    return;
                }
                String materialName = type.name().toLowerCase();
                ConfigHolder.UNIT_REPAIR_HOLDER.getConfig().set(this.parentMaterial.name().toLowerCase() + "." + materialName, (Object)0.25);
                ConfigHolder.UNIT_REPAIR_HOLDER.saveToDisk(true);
                this.updateValueForGeneric(materialName, true);
                this.parentGui.updateValueForGeneric(this.parentMaterial, true);
                ((DoubleSettingGui.DoubleSettingFactory)this.factoryMap.get(materialName)).create().show(player);
            }, true).show(event.getWhoClicked());
        };
    }

    @Override
    protected String createItemName() {
        return "\u00a7aAdd a new item reparable by " + this.materialName;
    }

    @Override
    protected DoubleSettingGui.DoubleSettingFactory createFactory(String materialName) {
        String materialDisplayName = CasedStringUtil.snakeToUpperSpacedCase(materialName);
        return new DoubleSettingGui.DoubleSettingFactory("\u00a70%\u00a78" + materialDisplayName + " Repair", this, ConfigHolder.UNIT_REPAIR_HOLDER, this.parentMaterial.name().toLowerCase() + "." + materialName, Arrays.asList("\u00a77Click here to change how many \u00a7e% \u00a77of \u00a7a" + materialDisplayName, "\u00a77Should get repaired by \u00a7e" + this.materialName), 2, true, true, 0.0, 1.0, 0.25, 0.01, 0.05, 0.25);
    }

    @Override
    protected GuiItem itemFromFactory(String materialName, DoubleSettingGui.DoubleSettingFactory factory) {
        return factory.getItem(this.materialFromName(materialName), "\u00a77%\u00a7a" + CasedStringUtil.snakeToUpperSpacedCase(materialName) + " \u00a7erepaired by \u00a7a" + this.materialName);
    }

    @Override
    protected Collection<String> getEveryDisplayableInstanceOfGeneric() {
        ArrayList<String> keys = new ArrayList<String>();
        if (!this.shouldWork) {
            return keys;
        }
        ConfigurationSection materialSection = ConfigHolder.UNIT_REPAIR_HOLDER.getConfig().getConfigurationSection(this.parentMaterial.name().toLowerCase());
        if (materialSection == null) {
            return keys;
        }
        keys.addAll(materialSection.getKeys(false));
        return keys;
    }

    private Material materialFromName(String materialName) {
        Material mat = Material.getMaterial((String)materialName.toUpperCase());
        if (mat == null || mat.isAir()) {
            return Material.BARRIER;
        }
        return mat;
    }

    @Override
    public void updateGuiValues() {
        super.updateGuiValues();
        this.parentGui.updateValueForGeneric(this.parentMaterial, true);
    }

    @Override
    public void updateLocal() {
    }

    @Override
    public void cleanAndBeUnusable() {
        this.shouldWork = false;
        this.backgroundPane.bindItem('S', GuiGlobalItems.backgroundItem(Material.BLACK_STAINED_GLASS_PANE));
        this.backgroundPane.bindItem('L', GuiGlobalItems.backgroundItem(Material.BLACK_STAINED_GLASS_PANE));
        this.backgroundPane.bindItem('R', GuiGlobalItems.backgroundItem(Material.BLACK_STAINED_GLASS_PANE));
        for (HumanEntity viewer : this.getViewers()) {
            viewer.sendMessage("This config do not exist anymore");
            this.parentGui.show(viewer);
        }
    }

    @Override
    public Gui getMappedGui() {
        return this;
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (!this.shouldWork) {
            humanEntity.closeInventory();
            return;
        }
        super.show(humanEntity);
    }
}

