/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.list.elements;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;
import xyz.alexcrea.cuanvil.group.EnchantConflictManager;
import xyz.alexcrea.cuanvil.gui.config.SelectEnchantmentContainer;
import xyz.alexcrea.cuanvil.gui.config.SelectGroupContainer;
import xyz.alexcrea.cuanvil.gui.config.ask.ConfirmActionGui;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantConflictGui;
import xyz.alexcrea.cuanvil.gui.config.list.elements.MappedToListSubSettingGui;
import xyz.alexcrea.cuanvil.gui.config.settings.EnchantSelectSettingGui;
import xyz.alexcrea.cuanvil.gui.config.settings.GroupSelectSettingGui;
import xyz.alexcrea.cuanvil.gui.config.settings.IntSettingsGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.Pane;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class EnchantConflictSubSettingGui
extends MappedToListSubSettingGui
implements SelectEnchantmentContainer,
SelectGroupContainer {
    private final EnchantConflictGui parent;
    private final EnchantConflictGroup enchantConflict;
    private final PatternPane pane;
    private boolean shouldWork = true;
    private GuiItem enchantSettingItem;
    private GuiItem groupSettingItem;
    private IntSettingsGui.IntSettingFactory minBeforeActiveSettingFactory;

    public EnchantConflictSubSettingGui(@NotNull EnchantConflictGui parent, @NotNull EnchantConflictGroup enchantConflict) {
        super(3, "\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(enchantConflict.toString()) + " \u00a78Config");
        this.parent = parent;
        this.enchantConflict = enchantConflict;
        Pattern pattern = new Pattern(new String[]{"000000000", "00EGM000D", "B00000000"});
        this.pane = new PatternPane(0, 0, 9, 3, pattern);
        this.addPane((Pane)this.pane);
        this.prepareStaticValues();
    }

    private void prepareStaticValues() {
        GuiGlobalItems.addBackItem(this.pane, (Gui)this.parent);
        GuiGlobalItems.addBackgroundItem(this.pane);
        ItemStack deleteItem = new ItemStack(Material.RED_TERRACOTTA);
        ItemMeta deleteMeta = deleteItem.getItemMeta();
        assert (deleteMeta != null);
        deleteMeta.setDisplayName("\u00a74DELETE CONFLICT");
        deleteMeta.setLore(Collections.singletonList("\u00a7cCaution with this button !"));
        deleteItem.setItemMeta(deleteMeta);
        this.pane.bindItem('D', new GuiItem(deleteItem, GuiGlobalActions.openGuiAction((Gui)this.createDeleteGui()), (Plugin)CustomAnvil.instance));
        this.enchantSettingItem = new GuiItem(new ItemStack(Material.ENCHANTED_BOOK), event -> {
            event.setCancelled(true);
            EnchantSelectSettingGui enchantGui = new EnchantSelectSettingGui("\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(this.enchantConflict.toString()) + "\u00a75", this, this);
            enchantGui.show(event.getWhoClicked());
        }, (Plugin)CustomAnvil.instance);
        this.groupSettingItem = new GuiItem(new ItemStack(Material.PAPER), event -> {
            event.setCancelled(true);
            GroupSelectSettingGui enchantGui = new GroupSelectSettingGui("\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(this.enchantConflict.toString()) + " \u00a73Groups", this, this, 0);
            enchantGui.show(event.getWhoClicked());
        }, (Plugin)CustomAnvil.instance);
        this.minBeforeActiveSettingFactory = new IntSettingsGui.IntSettingFactory("\u00a78Minimum enchantment count", this, String.valueOf(this.enchantConflict) + ".maxEnchantmentBeforeConflict", ConfigHolder.CONFLICT_HOLDER, Arrays.asList("\u00a77Minimum enchantment count set to X mean only X enchantment can be put", "\u00a77on an item before the conflict is active."), 0, 255, 0, 1);
        this.pane.bindItem('E', this.enchantSettingItem);
        this.pane.bindItem('G', this.groupSettingItem);
        this.updateLocal();
    }

    private ConfirmActionGui createDeleteGui() {
        Supplier<Boolean> deleteSupplier = () -> {
            EnchantConflictManager manager = ConfigHolder.CONFLICT_HOLDER.getConflictManager();
            manager.removeConflict(this.enchantConflict);
            this.parent.removeGeneric(this.enchantConflict);
            this.cleanAndBeUnusable();
            ConfigHolder.CONFLICT_HOLDER.delete(this.enchantConflict.toString());
            boolean success = true;
            success = ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
            return success;
        };
        return new ConfirmActionGui("\u00a7cDelete \u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(this.enchantConflict.toString()) + "\u00a7c?", "\u00a77Confirm that you want to delete this conflict.", (Gui)this, (Gui)this.parent, deleteSupplier);
    }

    @Override
    public void updateGuiValues() {
        int minBeforeBlock = ConfigHolder.CONFLICT_HOLDER.getConfig().getInt(this.enchantConflict.toString() + ".maxEnchantmentBeforeConflict", 0);
        this.enchantConflict.setMinBeforeBlock(minBeforeBlock);
        this.parent.updateValueForGeneric(this.enchantConflict, true);
    }

    @Override
    public void updateLocal() {
        if (!this.shouldWork) {
            return;
        }
        ArrayList<Object> enchantLore = new ArrayList<Object>();
        enchantLore.add("\u00a77Allow you to select a list of \u00a75Enchantments \u00a77that this conflict should include");
        Set<CAEnchantment> enchants = this.getSelectedEnchantments();
        if (enchants.isEmpty()) {
            enchantLore.add("\u00a77There is no included enchantment for this conflict.");
        } else {
            enchantLore.add("\u00a77List of included enchantment for this conflict:");
            Iterator<CAEnchantment> enchantIterator = enchants.iterator();
            boolean greaterThanMax = enchants.size() > 5;
            int maxindex = greaterThanMax ? 4 : enchants.size();
            for (int i = 0; i < maxindex; ++i) {
                String formattedName = CasedStringUtil.snakeToUpperSpacedCase(enchantIterator.next().getKey().getKey());
                enchantLore.add("\u00a77- \u00a75" + formattedName);
            }
            if (greaterThanMax) {
                enchantLore.add("\u00a77And " + (enchants.size() - 4) + " more...");
            }
        }
        List<String> groupLore = SelectGroupContainer.getGroupLore(this, "conflict", "exclude");
        ItemStack enchantItem = this.enchantSettingItem.getItem();
        ItemMeta enchantMeta = enchantItem.getItemMeta();
        assert (enchantMeta != null);
        enchantMeta.setDisplayName("\u00a7aSelect included \u00a75Enchantments \u00a7aSettings");
        enchantMeta.setLore(enchantLore);
        enchantItem.setItemMeta(enchantMeta);
        this.enchantSettingItem.setItem(enchantItem);
        ItemStack groupItem = this.groupSettingItem.getItem();
        ItemMeta groupMeta = groupItem.getItemMeta();
        assert (groupMeta != null);
        groupMeta.setDisplayName("\u00a7aSelect Excluded \u00a73Groups \u00a7aSettings");
        groupMeta.setLore(groupLore);
        groupItem.setItemMeta(groupMeta);
        this.groupSettingItem.setItem(groupItem);
        this.pane.bindItem('M', this.minBeforeActiveSettingFactory.getItem(Material.COMMAND_BLOCK, "Minimum Enchantment Count"));
        this.update();
    }

    @Override
    public void cleanAndBeUnusable() {
        for (HumanEntity viewer : this.getViewers()) {
            this.parent.show(viewer);
        }
        this.shouldWork = false;
        GuiItem background = GuiGlobalItems.backgroundItem();
        this.pane.bindItem('E', background);
        this.pane.bindItem('G', background);
        this.pane.bindItem('M', background);
        this.pane.bindItem('D', background);
    }

    public void show(@NotNull HumanEntity humanEntity) {
        if (this.shouldWork) {
            super.show(humanEntity);
        } else {
            this.parent.show(humanEntity);
        }
    }

    @Override
    public Set<CAEnchantment> getSelectedEnchantments() {
        return this.enchantConflict.getEnchants();
    }

    @Override
    public boolean setSelectedEnchantments(Set<CAEnchantment> enchantments) {
        if (!this.shouldWork) {
            CustomAnvil.instance.getLogger().info("Trying to save " + String.valueOf(this.enchantConflict) + " enchants but sub config is destroyed");
            return false;
        }
        this.enchantConflict.setEnchants(enchantments);
        String[] enchantKeys = new String[enchantments.size()];
        int index = 0;
        for (CAEnchantment enchantment : enchantments) {
            enchantKeys[index++] = enchantment.getKey().toString();
        }
        ConfigHolder.CONFLICT_HOLDER.getConfig().set(String.valueOf(this.enchantConflict) + ".enchantments", (Object)enchantKeys);
        try {
            this.updateGuiValues();
        }
        catch (Exception e) {
            CustomAnvil.instance.getLogger().log(Level.WARNING, "An error occurred while updating enchants for " + String.valueOf(this.enchantConflict), e);
        }
        return ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
    }

    @Override
    public Set<CAEnchantment> illegalEnchantments() {
        return Collections.emptySet();
    }

    @Override
    public Set<AbstractMaterialGroup> getSelectedGroups() {
        return this.enchantConflict.getCantConflictGroup().getGroups();
    }

    @Override
    public boolean setSelectedGroups(Set<AbstractMaterialGroup> groups) {
        if (!this.shouldWork) {
            CustomAnvil.instance.getLogger().info("Trying to save " + this.enchantConflict.toString() + " groups but sub config is destroyed");
            return false;
        }
        this.enchantConflict.getCantConflictGroup().setGroups(groups);
        String[] groupsNames = new String[groups.size()];
        int index = 0;
        for (AbstractMaterialGroup group : groups) {
            groupsNames[index++] = group.getName();
        }
        ConfigHolder.CONFLICT_HOLDER.getConfig().set(String.valueOf(this.enchantConflict) + ".notAffectedGroups", (Object)groupsNames);
        try {
            this.updateGuiValues();
        }
        catch (Exception e) {
            CustomAnvil.instance.getLogger().log(Level.WARNING, "An error occurred while updating group for " + String.valueOf(this.enchantConflict), e);
        }
        return ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
    }

    @Override
    public Set<AbstractMaterialGroup> illegalGroups() {
        return Collections.emptySet();
    }
}

