/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.SettingGui;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;

public class GuiGlobalActions {
    public static final String NO_EDIT_PERM = "\u00a7cYou do not have permission to edit the config";
    public static final Consumer<InventoryClickEvent> stayInPlace = event -> event.setCancelled(true);

    @NotNull
    public static Consumer<InventoryClickEvent> openGuiAction(@NotNull Class<? extends Gui> clazz, @NotNull Class<?>[] argClass, Object ... args) {
        return event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage(NO_EDIT_PERM);
                return;
            }
            try {
                Constructor constructor = clazz.getConstructor(argClass);
                Gui gui = (Gui)constructor.newInstance(args);
                gui.show(player);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @NotNull
    public static Consumer<InventoryClickEvent> openGuiAction(@NotNull Class<? extends Gui> clazz) {
        return GuiGlobalActions.openGuiAction(clazz, new Class[0], new Object[0]);
    }

    @NotNull
    public static Consumer<InventoryClickEvent> openSettingGuiAction(SettingGui.SettingGuiFactory factory) {
        return event -> {
            event.setCancelled(true);
            Gui gui = factory.create();
            gui.show(event.getWhoClicked());
        };
    }

    @NotNull
    public static Consumer<InventoryClickEvent> openGuiAction(@NotNull Gui goal) {
        return event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage(NO_EDIT_PERM);
                return;
            }
            goal.show(player);
        };
    }

    @NotNull
    public static Consumer<InventoryClickEvent> saveSettingAction(@NotNull SettingGui setting, @NotNull ValueUpdatableGui goal) {
        return event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage(NO_EDIT_PERM);
                return;
            }
            if (!setting.onSave()) {
                player.sendMessage("\u00a7cSomething went wrong while saving the change of value.");
            }
            goal.updateGuiValues();
            goal.getConnectedGui().show(player);
        };
    }
}

