/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.listener;

import io.delilaheve.CustomAnvil;
import io.delilaheve.util.ConfigOptions;
import io.delilaheve.util.EnchantmentUtil;
import io.delilaheve.util.ItemUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.api.event.listener.CATreatAnvilResultEvent;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.recipe.AnvilCustomRecipe;
import xyz.alexcrea.cuanvil.util.AnvilColorUtil;
import xyz.alexcrea.cuanvil.util.AnvilLoreEditUtil;
import xyz.alexcrea.cuanvil.util.AnvilUseType;
import xyz.alexcrea.cuanvil.util.AnvilXpUtil;
import xyz.alexcrea.cuanvil.util.CustomRecipeUtil;
import xyz.alexcrea.cuanvil.util.UnitRepairUtil;
import xyz.alexcrea.inventoryframework.util.InventoryViewUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0002J(\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J0\u0010\u001c\u001a\u00020\t2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190\u001e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190\u001eH\u0002J0\u0010!\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J0\u0010\"\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u00a8\u0006$"}, d2={"Lxyz/alexcrea/cuanvil/listener/PrepareAnvilListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "anvilCombineCheck", "", "event", "Lorg/bukkit/event/inventory/PrepareAnvilEvent;", "isImmutable", "", "item", "Lorg/bukkit/inventory/ItemStack;", "hasImmutableEnchants", "meta", "Lorg/bukkit/inventory/meta/ItemMeta;", "hasImmutableStoredEnchants", "testCustomRecipe", "inventory", "Lorg/bukkit/inventory/AnvilInventory;", "player", "Lorg/bukkit/entity/HumanEntity;", "first", "second", "doRenaming", "handleRename", "", "resultItem", "doMerge", "isIdentical", "firstEnchants", "", "Lxyz/alexcrea/cuanvil/enchant/CAEnchantment;", "resultEnchants", "testUnitRepair", "testLoreEdit", "Companion", "CustomAnvil"})
public final class PrepareAnvilListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int ANVIL_INPUT_LEFT = 0;
    public static final int ANVIL_INPUT_RIGHT = 1;
    public static final int ANVIL_OUTPUT_SLOT = 2;

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void anvilCombineCheck(@NotNull PrepareAnvilEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        HumanEntity humanEntity = InventoryViewUtil.getInstance().getPlayer(event.getView());
        Intrinsics.checkNotNullExpressionValue((Object)humanEntity, (String)"getPlayer(...)");
        HumanEntity player = humanEntity;
        AnvilInventory anvilInventory = event.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)anvilInventory, (String)"getInventory(...)");
        AnvilInventory inventory = anvilInventory;
        if (DependencyManager.INSTANCE.earlyTryEventPreAnvilBypass(event, player)) {
            InventoryView inventoryView = event.getView();
            Intrinsics.checkNotNullExpressionValue((Object)inventoryView, (String)"getView(...)");
            AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, inventory, inventoryView, player, event.getInventory().getRepairCost(), false, 16, null);
            return;
        }
        ItemStack itemStack = inventory.getItem(0);
        if (itemStack == null) {
            return;
        }
        ItemStack first = itemStack;
        ItemStack second = inventory.getItem(1);
        if (this.isImmutable(first) || this.isImmutable(second)) {
            CustomAnvil.Companion.verboseLog("Skipping anvil process as one of the two item is immutable");
            event.setResult(null);
            return;
        }
        if (DependencyManager.INSTANCE.tryEventPreAnvilBypass(event, player)) {
            InventoryView inventoryView = event.getView();
            Intrinsics.checkNotNullExpressionValue((Object)inventoryView, (String)"getView(...)");
            AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, inventory, inventoryView, player, event.getInventory().getRepairCost(), false, 16, null);
            return;
        }
        if (!player.hasPermission("ca.affected")) {
            return;
        }
        if (this.testCustomRecipe(event, inventory, player, first, second)) {
            return;
        }
        if (second == null) {
            this.doRenaming(event, inventory, player, first);
            return;
        }
        if (ItemUtil.INSTANCE.canMergeWith(first, second)) {
            this.doMerge(event, inventory, player, first, second);
            return;
        }
        if (this.testUnitRepair(event, inventory, player, first, second)) {
            return;
        }
        if (this.testLoreEdit(event, inventory, player, first, second)) {
            return;
        }
        CustomAnvil.Companion.log("no anvil fuse type found");
        event.setResult(null);
    }

    private final boolean isImmutable(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta != null && (this.hasImmutableEnchants(meta) || this.hasImmutableStoredEnchants(meta));
    }

    private final boolean hasImmutableEnchants(ItemMeta meta) {
        if (!meta.hasEnchants()) {
            return false;
        }
        for (Enchantment enchant : meta.getEnchants().keySet()) {
            NamespacedKey namespacedKey = enchant.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)namespacedKey, (String)"getKey(...)");
            if (!ConfigOptions.INSTANCE.isImmutable(namespacedKey)) continue;
            return true;
        }
        return false;
    }

    private final boolean hasImmutableStoredEnchants(ItemMeta meta) {
        if (!(meta instanceof EnchantmentStorageMeta) || !((EnchantmentStorageMeta)meta).hasStoredEnchants()) {
            return false;
        }
        for (Enchantment enchant : ((EnchantmentStorageMeta)meta).getStoredEnchants().keySet()) {
            NamespacedKey namespacedKey = enchant.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)namespacedKey, (String)"getKey(...)");
            if (!ConfigOptions.INSTANCE.isImmutable(namespacedKey)) continue;
            return true;
        }
        return false;
    }

    private final boolean testCustomRecipe(PrepareAnvilEvent event, AnvilInventory inventory, HumanEntity player, ItemStack first, ItemStack second) {
        AnvilCustomRecipe recipe = CustomRecipeUtil.INSTANCE.getCustomRecipe(first, second);
        CustomAnvil.Companion.verboseLog("custom recipe not null? " + (recipe != null));
        if (recipe == null) {
            return false;
        }
        int amount = CustomRecipeUtil.INSTANCE.getCustomRecipeAmount(recipe, first, second);
        ItemStack itemStack = recipe.getResultItem();
        Intrinsics.checkNotNull((Object)itemStack);
        ItemStack itemStack2 = itemStack.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
        ItemStack resultItem = itemStack2;
        resultItem.setAmount(resultItem.getAmount() * amount);
        int xpCost = recipe.determineCost(amount, first, resultItem);
        int levelCost = recipe.getRemoveExactLinearXp() ? AnvilXpUtil.INSTANCE.calculateMinimumLevelForXp(xpCost) : AnvilXpUtil.INSTANCE.calculateLevelForXp(xpCost);
        CATreatAnvilResultEvent finalResult = DependencyManager.INSTANCE.tryTreatAnvilResult(event, resultItem, AnvilUseType.CUSTOM_CRAFT, levelCost);
        if (finalResult == null) {
            return false;
        }
        event.setResult(finalResult.getResult());
        if (finalResult.getResult() == null) {
            return false;
        }
        InventoryView inventoryView = event.getView();
        Intrinsics.checkNotNullExpressionValue((Object)inventoryView, (String)"getView(...)");
        AnvilXpUtil.INSTANCE.setAnvilInvXp(inventory, inventoryView, player, finalResult.getLevelCost(), true);
        return true;
    }

    private final void doRenaming(PrepareAnvilEvent event, AnvilInventory inventory, HumanEntity player, ItemStack first) {
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack resultItem = itemStack;
        int anvilCost = this.handleRename(resultItem, inventory, player);
        if (Intrinsics.areEqual((Object)first, (Object)resultItem)) {
            CustomAnvil.Companion.log("no right item, But input is same as output");
            event.setResult(null);
            return;
        }
        CATreatAnvilResultEvent finalResult = DependencyManager.INSTANCE.tryTreatAnvilResult(event, resultItem, AnvilUseType.RENAME_ONLY, anvilCost += AnvilXpUtil.INSTANCE.calculatePenalty(first, null, resultItem, AnvilUseType.RENAME_ONLY));
        if (finalResult == null) {
            return;
        }
        event.setResult(finalResult.getResult());
        if (finalResult.getResult() == null) {
            return;
        }
        InventoryView inventoryView = event.getView();
        Intrinsics.checkNotNullExpressionValue((Object)inventoryView, (String)"getView(...)");
        AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, inventory, inventoryView, player, finalResult.getLevelCost(), false, 16, null);
    }

    private final int handleRename(ItemStack resultItem, AnvilInventory inventory, HumanEntity player) {
        ItemMeta itemMeta;
        StringBuilder resultString;
        String inventoryName = null;
        inventoryName = ChatColor.stripColor((String)inventory.getRenameText());
        int sumCost = 0;
        boolean useColor = false;
        if (ConfigOptions.INSTANCE.getRenameColorPossible() && inventoryName != null && (useColor = AnvilColorUtil.INSTANCE.handleColor(resultString = new StringBuilder(inventoryName), (Permissible)player, ConfigOptions.INSTANCE.getPermissionNeededForColor(), ConfigOptions.INSTANCE.getAllowColorCode(), ConfigOptions.INSTANCE.getAllowHexadecimalColor(), AnvilColorUtil.ColorUseType.RENAME))) {
            inventoryName = resultString.toString();
            sumCost += ConfigOptions.INSTANCE.getUseOfColorCost();
        }
        if ((itemMeta = resultItem.getItemMeta()) != null) {
            String displayName;
            ItemMeta it = itemMeta;
            boolean bl = false;
            boolean hasDisplayName = it.hasDisplayName();
            String string = !hasDisplayName ? null : (displayName = useColor ? it.getDisplayName() : ChatColor.stripColor((String)it.getDisplayName()));
            if (!StringsKt.contentEquals((CharSequence)displayName, (CharSequence)inventoryName)) {
                it.setDisplayName(inventoryName);
                resultItem.setItemMeta(it);
                sumCost += ConfigOptions.INSTANCE.getItemRenameCost();
            }
            return sumCost;
        }
        return 0;
    }

    private final void doMerge(PrepareAnvilEvent event, AnvilInventory inventory, HumanEntity player, ItemStack first, ItemStack second) {
        Map<CAEnchantment, Integer> newEnchants = EnchantmentUtil.INSTANCE.combineWith(ItemUtil.INSTANCE.findEnchantments(first), ItemUtil.INSTANCE.findEnchantments(second), first, player);
        boolean hasChanged = !this.isIdentical(ItemUtil.INSTANCE.findEnchantments(first), newEnchants);
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack resultItem = itemStack;
        int anvilCost = 0;
        if (hasChanged) {
            ItemUtil.INSTANCE.setEnchantmentsUnsafe(resultItem, newEnchants);
            anvilCost += AnvilXpUtil.INSTANCE.getRightValues(second, resultItem);
        }
        if (!ItemUtil.INSTANCE.isEnchantedBook(first) && !ItemUtil.INSTANCE.isEnchantedBook(second)) {
            boolean repaired = ItemUtil.INSTANCE.repairFrom(resultItem, first, second);
            anvilCost += repaired ? ConfigOptions.INSTANCE.getItemRepairCost() : 0;
            boolean bl = hasChanged = hasChanged || repaired;
        }
        if (!hasChanged) {
            CustomAnvil.Companion.log("Mergable with second, But input is same as output");
            event.setResult(null);
            return;
        }
        anvilCost += AnvilXpUtil.INSTANCE.calculatePenalty(first, second, resultItem, AnvilUseType.MERGE);
        CATreatAnvilResultEvent finalResult = DependencyManager.INSTANCE.tryTreatAnvilResult(event, resultItem, AnvilUseType.MERGE, anvilCost += this.handleRename(resultItem, inventory, player));
        if (finalResult == null) {
            return;
        }
        event.setResult(finalResult.getResult());
        if (finalResult.getResult() == null) {
            return;
        }
        InventoryView inventoryView = event.getView();
        Intrinsics.checkNotNullExpressionValue((Object)inventoryView, (String)"getView(...)");
        AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, inventory, inventoryView, player, finalResult.getLevelCost(), false, 16, null);
    }

    private final boolean isIdentical(Map<CAEnchantment, Integer> firstEnchants, Map<CAEnchantment, Integer> resultEnchants) {
        if (firstEnchants.size() != resultEnchants.size()) {
            return false;
        }
        for (Map.Entry<CAEnchantment, Integer> entry : resultEnchants.entrySet()) {
            if (((Number)firstEnchants.getOrDefault(entry.getKey(), ((Number)entry.getValue()).intValue() - 1)).intValue() == ((Number)entry.getValue()).intValue()) continue;
            return false;
        }
        return true;
    }

    private final boolean testUnitRepair(PrepareAnvilEvent event, AnvilInventory inventory, HumanEntity player, ItemStack first, ItemStack second) {
        Double d = UnitRepairUtil.INSTANCE.getRepair(first, second);
        if (d == null) {
            return false;
        }
        double unitRepairAmount = d;
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack resultItem = itemStack;
        int anvilCost = this.handleRename(resultItem, inventory, player);
        int repairAmount = ItemUtil.INSTANCE.unitRepair(resultItem, second.getAmount(), unitRepairAmount);
        if (repairAmount > 0) {
            anvilCost += repairAmount * ConfigOptions.INSTANCE.getUnitRepairCost();
        }
        anvilCost += AnvilXpUtil.INSTANCE.calculatePenalty(first, null, resultItem, AnvilUseType.UNIT_REPAIR);
        if (Intrinsics.areEqual((Object)first, (Object)resultItem)) {
            CustomAnvil.Companion.log("unit repair, But input is same as output");
            event.setResult(null);
            return true;
        }
        CATreatAnvilResultEvent finalResult = DependencyManager.INSTANCE.tryTreatAnvilResult(event, resultItem, AnvilUseType.UNIT_REPAIR, anvilCost);
        if (finalResult == null) {
            return false;
        }
        event.setResult(finalResult.getResult());
        if (finalResult.getResult() == null) {
            return false;
        }
        InventoryView inventoryView = event.getView();
        Intrinsics.checkNotNullExpressionValue((Object)inventoryView, (String)"getView(...)");
        AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, inventory, inventoryView, player, finalResult.getLevelCost(), false, 16, null);
        return true;
    }

    private final boolean testLoreEdit(PrepareAnvilEvent event, AnvilInventory inventory, HumanEntity player, ItemStack first, ItemStack second) {
        Material material = second.getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        Material type = material;
        ItemStack result = null;
        AtomicInteger xpCost = new AtomicInteger();
        if (Material.WRITABLE_BOOK == type) {
            result = AnvilLoreEditUtil.INSTANCE.tryLoreEditByBook(player, first, second, xpCost);
        } else if (Material.PAPER == type) {
            result = AnvilLoreEditUtil.INSTANCE.tryLoreEditByPaper(player, first, second, xpCost);
        }
        if (result == null || Intrinsics.areEqual((Object)first, (Object)result)) {
            CustomAnvil.Companion.log("lore edit, But input is same as output");
            event.setResult(null);
            return false;
        }
        event.setResult(result);
        InventoryView inventoryView = event.getView();
        Intrinsics.checkNotNullExpressionValue((Object)inventoryView, (String)"getView(...)");
        AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, inventory, inventoryView, player, xpCost.get(), false, 16, null);
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lxyz/alexcrea/cuanvil/listener/PrepareAnvilListener$Companion;", "", "<init>", "()V", "ANVIL_INPUT_LEFT", "", "ANVIL_INPUT_RIGHT", "ANVIL_OUTPUT_SLOT", "CustomAnvil"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

