/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.recipe;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.recipe.AnvilCustomRecipe;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0006J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u0006R*\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bRV\u0010\f\u001a>\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00070\rj\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007`\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lxyz/alexcrea/cuanvil/recipe/CustomAnvilRecipeManager;", "", "<init>", "()V", "recipeList", "Ljava/util/ArrayList;", "Lxyz/alexcrea/cuanvil/recipe/AnvilCustomRecipe;", "Lkotlin/collections/ArrayList;", "getRecipeList", "()Ljava/util/ArrayList;", "setRecipeList", "(Ljava/util/ArrayList;)V", "recipeByMat", "Ljava/util/HashMap;", "Lorg/bukkit/Material;", "Lkotlin/collections/HashMap;", "getRecipeByMat", "()Ljava/util/HashMap;", "setRecipeByMat", "(Ljava/util/HashMap;)V", "prepareRecipes", "", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "cleanAddNew", "recipe", "cleanSetLeftItem", "leftItem", "Lorg/bukkit/inventory/ItemStack;", "addToMatMap", "cleanRemove", "", "CustomAnvil"})
public final class CustomAnvilRecipeManager {
    public ArrayList<AnvilCustomRecipe> recipeList;
    public HashMap<Material, ArrayList<AnvilCustomRecipe>> recipeByMat;

    @NotNull
    public final ArrayList<AnvilCustomRecipe> getRecipeList() {
        ArrayList<AnvilCustomRecipe> arrayList = this.recipeList;
        if (arrayList != null) {
            return arrayList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"recipeList");
        return null;
    }

    public final void setRecipeList(@NotNull ArrayList<AnvilCustomRecipe> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.recipeList = arrayList;
    }

    @NotNull
    public final HashMap<Material, ArrayList<AnvilCustomRecipe>> getRecipeByMat() {
        HashMap<Material, ArrayList<AnvilCustomRecipe>> hashMap = this.recipeByMat;
        if (hashMap != null) {
            return hashMap;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"recipeByMat");
        return null;
    }

    public final void setRecipeByMat(@NotNull HashMap<Material, ArrayList<AnvilCustomRecipe>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.recipeByMat = hashMap;
    }

    public final void prepareRecipes(@NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.setRecipeList(new ArrayList<AnvilCustomRecipe>());
        this.setRecipeByMat(new HashMap<Material, ArrayList<AnvilCustomRecipe>>());
        Set set = config.getKeys(false);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getKeys(...)");
        Set keys = set;
        for (String key : keys) {
            Intrinsics.checkNotNull((Object)key);
            AnvilCustomRecipe recipe = AnvilCustomRecipe.Companion.getFromConfig(key);
            if (recipe == null) {
                CustomAnvil.Companion.log("Can't load recipe " + key);
                continue;
            }
            this.cleanAddNew(recipe);
        }
    }

    public final void cleanAddNew(@NotNull AnvilCustomRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        this.getRecipeList().add(recipe);
        ItemStack leftItem = recipe.getLeftItem();
        if (leftItem != null) {
            this.addToMatMap(recipe, leftItem);
        }
    }

    public final void cleanSetLeftItem(@NotNull AnvilCustomRecipe recipe, @Nullable ItemStack leftItem) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        ItemStack oldLeftItem = recipe.getLeftItem();
        if (oldLeftItem != null) {
            ArrayList<AnvilCustomRecipe> test;
            Material material = oldLeftItem.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            Material oldMat = material;
            ArrayList<AnvilCustomRecipe> arrayList = test = this.getRecipeByMat().get(oldMat);
            Intrinsics.checkNotNull(arrayList);
            arrayList.remove(recipe);
        }
        if (leftItem != null) {
            this.addToMatMap(recipe, leftItem);
        }
        recipe.setLeftItem(leftItem);
    }

    private final void addToMatMap(AnvilCustomRecipe recipe, ItemStack leftItem) {
        ArrayList<AnvilCustomRecipe> recipeList = this.getRecipeByMat().get(leftItem.getType());
        if (recipeList == null) {
            recipeList = new ArrayList();
            ((Map)this.getRecipeByMat()).put(leftItem.getType(), recipeList);
        }
        recipeList.add(recipe);
    }

    public final boolean cleanRemove(@NotNull AnvilCustomRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        boolean exist = this.getRecipeList().remove(recipe);
        if (exist) {
            this.cleanSetLeftItem(recipe, null);
        }
        return exist;
    }
}

