/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.update;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public record Version(int major, int minor, int patch) {
    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major) {
        this(major, 0, 0);
    }

    public static Version fromString(@Nullable String versionString) {
        if (versionString == null) {
            return new Version(0, 0, 0);
        }
        String[] partialVersion = versionString.split("\\.");
        int[] versionParts = new int[]{0, 0, 0};
        for (int i = 0; i < Math.min(3, partialVersion.length); ++i) {
            versionParts[i] = Integer.parseInt(partialVersion[i]);
        }
        return new Version(versionParts[0], versionParts[1], versionParts[2]);
    }

    public boolean greaterThan(@Nonnull Version other) {
        return this.major > other.major || this.major == other.major && (this.minor > other.minor || this.minor == other.minor && this.patch > other.patch);
    }

    public boolean greaterEqual(@Nonnull Version other) {
        return this.major > other.major || this.major == other.major && (this.minor > other.minor || this.minor == other.minor && this.patch >= other.patch);
    }

    public boolean lesserThan(@Nonnull Version other) {
        return this.major < other.major || this.major == other.major && (this.minor < other.minor || this.minor == other.minor && this.patch < other.patch);
    }

    public boolean lesserEqual(@Nonnull Version other) {
        return this.major < other.major || this.major == other.major && (this.minor < other.minor || this.minor == other.minor && this.patch <= other.patch);
    }

    @Override
    @NotNull
    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

