/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.util.AnvilColorUtil;
import xyz.alexcrea.cuanvil.util.AnvilXpUtil;
import xyz.alexcrea.cuanvil.util.config.LoreEditConfigUtil;
import xyz.alexcrea.cuanvil.util.config.LoreEditType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J(\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J(\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010\"\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u00050$j\b\u0012\u0004\u0012\u00020\u0005`%2\u0006\u0010 \u001a\u00020!H\u0002J.\u0010&\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u00050$j\b\u0012\u0004\u0012\u00020\u0005`%2\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lxyz/alexcrea/cuanvil/util/AnvilLoreEditUtil;", "", "<init>", "()V", "LORE_BY_BOOK", "", "LORE_BY_PAPER", "hasLoreEditByBookPermission", "", "player", "Lorg/bukkit/permissions/Permissible;", "hasLoreEditByPaperPermission", "handleLoreAppendByBook", "Lorg/bukkit/inventory/ItemStack;", "first", "book", "Lorg/bukkit/inventory/meta/BookMeta;", "xpCost", "Ljava/util/concurrent/atomic/AtomicInteger;", "handleLoreRemoveByBook", "bookLoreEditIsAppend", "second", "(Lorg/bukkit/inventory/ItemStack;Lorg/bukkit/inventory/ItemStack;)Ljava/lang/Boolean;", "tryLoreEditByBook", "Lorg/bukkit/entity/HumanEntity;", "paperLoreEditIsAppend", "handleLoreAppendByPaper", "handleLoreRemoveByPaper", "tryLoreEditByPaper", "baseEditLoreXpCost", "", "result", "editType", "Lxyz/alexcrea/cuanvil/util/config/LoreEditType;", "colorLines", "lines", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "uncolorLines", "CustomAnvil"})
public final class AnvilLoreEditUtil {
    @NotNull
    public static final AnvilLoreEditUtil INSTANCE = new AnvilLoreEditUtil();
    @NotNull
    private static final String LORE_BY_BOOK = "ca.lore_edit.book";
    @NotNull
    private static final String LORE_BY_PAPER = "ca.lore_edit.paper";

    private AnvilLoreEditUtil() {
    }

    private final boolean hasLoreEditByBookPermission(Permissible player) {
        return !LoreEditConfigUtil.INSTANCE.getBookLoreEditNeedPermission() || player.hasPermission(LORE_BY_BOOK);
    }

    private final boolean hasLoreEditByPaperPermission(Permissible player) {
        return !LoreEditConfigUtil.INSTANCE.getPaperLoreEditNeedPermission() || player.hasPermission(LORE_BY_PAPER);
    }

    @Nullable
    public final ItemStack handleLoreAppendByBook(@NotNull Permissible player, @NotNull ItemStack first, @NotNull BookMeta book, @NotNull AtomicInteger xpCost) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)xpCost, (String)"xpCost");
        if (!this.hasLoreEditByBookPermission(player)) {
            return null;
        }
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack result = itemStack;
        ItemMeta itemMeta = result.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta meta = itemMeta;
        if (meta.hasLore()) {
            List list = meta.getLore();
            Intrinsics.checkNotNull((Object)list);
            arrayList = new ArrayList(list);
        } else {
            arrayList = new ArrayList();
        }
        ArrayList lore = arrayList;
        String page = (String)book.getPages().get(0);
        Intrinsics.checkNotNull((Object)page);
        String[] stringArray = new String[]{"\n"};
        ArrayList<String> lines = new ArrayList<String>(StringsKt.split$default((CharSequence)page, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        int colorCost = this.colorLines(player, lines, LoreEditType.APPEND_BOOK);
        lore.addAll(lines);
        meta.setLore((List)lore);
        result.setItemMeta(meta);
        if (Intrinsics.areEqual((Object)result, (Object)first)) {
            return null;
        }
        xpCost.addAndGet(colorCost);
        xpCost.addAndGet(lines.size() * LoreEditType.APPEND_BOOK.getPerLineCost());
        xpCost.addAndGet(this.baseEditLoreXpCost(first, result, LoreEditType.APPEND_BOOK));
        return result;
    }

    @Nullable
    public final ItemStack handleLoreRemoveByBook(@NotNull Permissible player, @NotNull ItemStack first, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)xpCost, (String)"xpCost");
        if (!this.hasLoreEditByBookPermission(player)) {
            return null;
        }
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack result = itemStack;
        ItemMeta itemMeta = result.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta leftMeta = itemMeta;
        ArrayList<String> currentLore = DependencyManager.INSTANCE.stripLore(result);
        if (currentLore.isEmpty()) {
            return null;
        }
        int uncolorCost = this.uncolorLines(player, currentLore, LoreEditType.REMOVE_BOOK);
        leftMeta.setLore(null);
        result.setItemMeta(leftMeta);
        DependencyManager.INSTANCE.updateLore(result);
        if (Intrinsics.areEqual((Object)result, (Object)first)) {
            return null;
        }
        xpCost.addAndGet(uncolorCost);
        xpCost.addAndGet(currentLore.size() * LoreEditType.REMOVE_BOOK.getPerLineCost());
        xpCost.addAndGet(this.baseEditLoreXpCost(first, result, LoreEditType.REMOVE_BOOK));
        return result;
    }

    @Nullable
    public final Boolean bookLoreEditIsAppend(@NotNull ItemStack first, @NotNull ItemStack second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        BookMeta bookMeta = (BookMeta)second.getItemMeta();
        if (bookMeta == null) {
            return false;
        }
        BookMeta meta = bookMeta;
        boolean hasContent = false;
        if (meta.hasPages() && meta.getPageCount() >= 1) {
            for (String page : meta.getPages()) {
                Intrinsics.checkNotNull((Object)page);
                if (!(!StringsKt.isBlank((CharSequence)page))) continue;
                hasContent = true;
                break;
            }
        }
        if (hasContent) {
            Object e = meta.getPages().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            if (((CharSequence)e).length() == 0) {
                return null;
            }
            if (LoreEditType.APPEND_BOOK.getEnabled()) {
                return true;
            }
        } else if (LoreEditType.REMOVE_BOOK.getEnabled()) {
            if (!first.hasItemMeta()) {
                return null;
            }
            ItemMeta itemMeta = first.getItemMeta();
            Intrinsics.checkNotNull((Object)itemMeta);
            ItemMeta leftMeta = itemMeta;
            return leftMeta.hasLore() ? Boolean.valueOf(false) : null;
        }
        return null;
    }

    @Nullable
    public final ItemStack tryLoreEditByBook(@NotNull HumanEntity player, @NotNull ItemStack first, @NotNull ItemStack second, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Intrinsics.checkNotNullParameter((Object)xpCost, (String)"xpCost");
        Boolean bl = this.bookLoreEditIsAppend(first, second);
        if (bl == null) {
            return null;
        }
        boolean bookType = bl;
        ItemMeta itemMeta = second.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta, (String)"null cannot be cast to non-null type org.bukkit.inventory.meta.BookMeta");
        BookMeta meta = (BookMeta)itemMeta;
        return bookType ? this.handleLoreAppendByBook((Permissible)player, first, meta, xpCost) : this.handleLoreRemoveByBook((Permissible)player, first, xpCost);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Boolean paperLoreEditIsAppend(@NotNull ItemStack first, @NotNull ItemStack second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        ItemMeta itemMeta = second.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta meta = itemMeta;
        boolean hasContent = meta.hasDisplayName();
        if (hasContent) {
            if (!LoreEditType.APPEND_PAPER.getEnabled()) return null;
            return true;
        }
        if (!LoreEditType.REMOVE_PAPER.getEnabled()) return null;
        if (!first.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta2 = first.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta2);
        ItemMeta leftMeta = itemMeta2;
        if (!leftMeta.hasLore()) return null;
        List list = leftMeta.getLore();
        Intrinsics.checkNotNull((Object)list);
        if (((Collection)list).isEmpty()) return null;
        boolean bl = true;
        if (!bl) return null;
        Boolean bl2 = false;
        return bl2;
    }

    @Nullable
    public final ItemStack handleLoreAppendByPaper(@NotNull Permissible player, @NotNull ItemStack first, @NotNull ItemStack second, @NotNull AtomicInteger xpCost) {
        ArrayList<String> arrayList;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Intrinsics.checkNotNullParameter((Object)xpCost, (String)"xpCost");
        if (!this.hasLoreEditByPaperPermission(player)) {
            return null;
        }
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack result = itemStack;
        ItemMeta itemMeta = result.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta meta = itemMeta;
        if (meta.hasLore()) {
            List list = meta.getLore();
            Intrinsics.checkNotNull((Object)list);
            arrayList = new ArrayList<String>(list);
        } else {
            arrayList = new ArrayList();
        }
        ArrayList<String> lore = arrayList;
        boolean appendEnd = LoreEditConfigUtil.INSTANCE.getPaperLoreOrderIsEnd();
        ArrayList<String> tempList = new ArrayList<String>(1);
        ItemMeta itemMeta2 = second.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta2);
        tempList.add(itemMeta2.getDisplayName());
        int colorCost = this.colorLines(player, tempList, LoreEditType.APPEND_PAPER);
        String string = tempList.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String line = string;
        if (appendEnd) {
            lore.add(line);
        } else {
            lore.add(0, line);
        }
        meta.setLore((List)lore);
        result.setItemMeta(meta);
        if (Intrinsics.areEqual((Object)result, (Object)first)) {
            return null;
        }
        xpCost.addAndGet(colorCost);
        xpCost.addAndGet(this.baseEditLoreXpCost(first, result, LoreEditType.APPEND_PAPER));
        return result;
    }

    @Nullable
    public final ItemStack handleLoreRemoveByPaper(@NotNull Permissible player, @NotNull ItemStack first, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)xpCost, (String)"xpCost");
        if (!this.hasLoreEditByPaperPermission(player)) {
            return null;
        }
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
        ItemStack result = itemStack;
        ItemMeta itemMeta = result.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        boolean removeEnd = LoreEditConfigUtil.INSTANCE.getPaperLoreOrderIsEnd();
        ArrayList<String> lore = DependencyManager.INSTANCE.stripLore(result);
        if (lore.isEmpty()) {
            return null;
        }
        String string = removeEnd ? lore.remove(lore.size() - 1) : lore.remove(0);
        Intrinsics.checkNotNull((Object)string);
        String line = string;
        meta.setLore(null);
        result.setItemMeta(meta);
        DependencyManager.INSTANCE.updateLore(result);
        ArrayList finalLore = new ArrayList();
        List list = meta.getLore();
        finalLore.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        finalLore.addAll(lore);
        meta.setLore((List)finalLore);
        result.setItemMeta(meta);
        if (Intrinsics.areEqual((Object)result, (Object)first)) {
            return null;
        }
        ArrayList<String> tempList = new ArrayList<String>(1);
        tempList.add(line);
        int uncolorCost = this.uncolorLines(player, tempList, LoreEditType.REMOVE_PAPER);
        xpCost.addAndGet(uncolorCost);
        xpCost.addAndGet(this.baseEditLoreXpCost(first, result, LoreEditType.REMOVE_PAPER));
        return result;
    }

    @Nullable
    public final ItemStack tryLoreEditByPaper(@NotNull HumanEntity player, @NotNull ItemStack first, @NotNull ItemStack second, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Intrinsics.checkNotNullParameter((Object)xpCost, (String)"xpCost");
        Boolean bl = this.paperLoreEditIsAppend(first, second);
        if (bl == null) {
            return null;
        }
        boolean bookType = bl;
        return bookType ? this.handleLoreAppendByPaper((Permissible)player, first, second, xpCost) : this.handleLoreRemoveByPaper((Permissible)player, first, xpCost);
    }

    private final int baseEditLoreXpCost(ItemStack first, ItemStack result, LoreEditType editType) {
        int xpCost = editType.getFixedCost();
        return xpCost += AnvilXpUtil.INSTANCE.calculatePenalty(first, null, result, editType.getUseType());
    }

    private final int colorLines(Permissible player, ArrayList<String> lines, LoreEditType editType) {
        boolean canUseHex = editType.getAllowHexColor();
        boolean canUseColorCode = editType.getAllowColorCode();
        int colorCost = editType.getUseColorCost();
        boolean hasUsedColor = false;
        Iterator iterator = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String line = (String)iterator.next();
            StringBuilder coloredLine = new StringBuilder(line);
            boolean lineUsedColor = AnvilColorUtil.INSTANCE.handleColor(coloredLine, player, false, canUseColorCode, canUseHex, AnvilColorUtil.ColorUseType.LORE_EDIT);
            if (!lineUsedColor) continue;
            hasUsedColor = true;
            lines.set(index, coloredLine.toString());
        }
        return hasUsedColor ? colorCost : 0;
    }

    public final int uncolorLines(@NotNull Permissible player, @NotNull ArrayList<String> lines, @NotNull LoreEditType editType) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)((Object)editType), (String)"editType");
        if (!editType.getShouldRemoveColorOnLoreRemoval()) {
            return 0;
        }
        boolean hasUndidColor = false;
        Iterator iterator = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String line = (String)iterator.next();
            StringBuilder uncoloredLine = new StringBuilder(line);
            boolean lineUndidColor = AnvilColorUtil.INSTANCE.revertColor(uncoloredLine, player, false, true, true, AnvilColorUtil.ColorUseType.LORE_EDIT);
            if (!lineUndidColor) continue;
            hasUndidColor = true;
            lines.set(index, uncoloredLine.toString());
        }
        return hasUndidColor ? editType.getRemoveColorCost() : 0;
    }
}

