/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyValue<T> {
    private final Supplier<T> valueSupplier;
    private T storedValue;

    public LazyValue(Supplier<T> valueSupplier) {
        this.valueSupplier = valueSupplier;
        this.storedValue = null;
    }

    @Nullable
    public T getStored() {
        return this.storedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public T get() {
        if (this.storedValue != null) {
            return this.storedValue;
        }
        LazyValue lazyValue = this;
        synchronized (lazyValue) {
            if (this.storedValue == null) {
                this.storedValue = this.valueSupplier.get();
            }
        }
        return this.storedValue;
    }
}

