/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.enchant;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.EnchantmentRarity;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;

public abstract class CAEnchantmentBase
implements CAEnchantment {
    @NotNull
    private final NamespacedKey key;
    @NotNull
    private final String name;
    @NotNull
    private final EnchantmentRarity defaultRarity;
    private final int defaultMaxLevel;
    private final List<EnchantConflictGroup> conflicts;

    protected CAEnchantmentBase(@NotNull NamespacedKey key, @Nullable EnchantmentRarity defaultRarity, int defaultMaxLevel) {
        this.key = key;
        this.name = key.getKey();
        this.defaultMaxLevel = defaultMaxLevel;
        this.defaultRarity = Objects.requireNonNullElse(defaultRarity, EnchantmentRarity.COMMON);
        this.conflicts = new ArrayList<EnchantConflictGroup>();
    }

    @Override
    @NotNull
    public final EnchantmentRarity defaultRarity() {
        return this.defaultRarity;
    }

    @Override
    @NotNull
    public final NamespacedKey getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public final int defaultMaxLevel() {
        return this.defaultMaxLevel;
    }

    @Override
    public boolean isGetOptimised() {
        return false;
    }

    @Override
    public boolean isCleanOptimised() {
        return false;
    }

    @Override
    public boolean isAllowed(@NotNull HumanEntity player) {
        return true;
    }

    @Override
    public boolean isEnchantmentPresent(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return this.isEnchantmentPresent(item, meta);
    }

    @Override
    public void addConflict(@NotNull EnchantConflictGroup conflict) {
        this.conflicts.add(conflict);
    }

    @Override
    public void removeConflict(@NotNull EnchantConflictGroup conflict) {
        this.conflicts.remove(conflict);
    }

    @Override
    public void clearConflict() {
        this.conflicts.clear();
    }

    @NotNull
    public List<EnchantConflictGroup> getConflicts() {
        return this.conflicts;
    }
}

