/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J:\u0010\u0015\u001a\u00020\n2\n\u0010\u0016\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u001c\u0010\u001e\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\fj\u0002`\r2\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u001c\u0010\u001f\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\fj\u0002`\r2\u0006\u0010\u001d\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006!"}, d2={"Lxyz/alexcrea/cuanvil/util/AnvilColorUtil;", "", "<init>", "()V", "HEX_PATTERN", "Ljava/util/regex/Pattern;", "TRANSFORMED_HEX_PATTERN", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "handleColor", "", "textToColor", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "player", "Lorg/bukkit/permissions/Permissible;", "usePermission", "allowColorCode", "allowHexadecimalColor", "useType", "Lxyz/alexcrea/cuanvil/util/AnvilColorUtil$ColorUseType;", "revertColor", "colorToText", "replaceAll", "", "builder", "from", "", "to", "endOffset", "replaceHexToColor", "replaceColorToHex", "ColorUseType", "CustomAnvil"})
public final class AnvilColorUtil {
    @NotNull
    public static final AnvilColorUtil INSTANCE = new AnvilColorUtil();
    @NotNull
    private static final Pattern HEX_PATTERN;
    private static final Pattern TRANSFORMED_HEX_PATTERN;

    private AnvilColorUtil() {
    }

    public final boolean handleColor(@NotNull StringBuilder textToColor, @NotNull Permissible player, boolean usePermission, boolean allowColorCode, boolean allowHexadecimalColor, @NotNull ColorUseType useType) {
        int nbReplacement;
        boolean canUseHexColor;
        Intrinsics.checkNotNullParameter(textToColor, "textToColor");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)useType, "useType");
        if (!allowColorCode && !allowHexadecimalColor) {
            return false;
        }
        boolean canUseColorCode = allowColorCode && (!usePermission || useType.getColorCodePerm() == null || player.hasPermission(useType.getColorCodePerm()));
        boolean bl = canUseHexColor = allowHexadecimalColor && (!usePermission || useType.getHexColorPerm() == null || player.hasPermission(useType.getHexColorPerm()));
        if (!canUseColorCode && !canUseHexColor) {
            return false;
        }
        boolean useColor = false;
        if (canUseColorCode) {
            nbReplacement = this.replaceAll(textToColor, "&", "\u00a7", 2);
            if ((nbReplacement -= 2 * this.replaceAll(textToColor, "\u00a7\u00a7", "&", 2)) > 0) {
                useColor = true;
            }
        }
        if (canUseHexColor && (nbReplacement = this.replaceHexToColor(textToColor, 7)) > 0) {
            useColor = true;
        }
        return useColor;
    }

    public final boolean revertColor(@NotNull StringBuilder colorToText, @NotNull Permissible player, boolean usePermission, boolean allowColorCode, boolean allowHexadecimalColor, @NotNull ColorUseType useType) {
        int nbReplacement;
        boolean canUseHexColor;
        Intrinsics.checkNotNullParameter(colorToText, "colorToText");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)useType, "useType");
        if (!allowColorCode && !allowHexadecimalColor) {
            return false;
        }
        boolean canUseColorCode = allowColorCode && (!usePermission || useType.getColorCodePerm() == null || player.hasPermission(useType.getColorCodePerm()));
        boolean bl = canUseHexColor = allowHexadecimalColor && (!usePermission || useType.getHexColorPerm() == null || player.hasPermission(useType.getHexColorPerm()));
        if (!canUseColorCode && !canUseHexColor) {
            return false;
        }
        boolean hasReversed = false;
        if (canUseHexColor && (nbReplacement = this.replaceColorToHex(colorToText, 14)) > 0) {
            hasReversed = true;
        }
        if (canUseColorCode) {
            this.replaceAll(colorToText, "&", "&&", 1);
            nbReplacement = this.replaceAll(colorToText, "\u00a7", "&", 2);
            if (nbReplacement > 0) {
                hasReversed = true;
            }
        }
        return hasReversed;
    }

    private final int replaceAll(StringBuilder builder, String from, String to, int endOffset) {
        int index = builder.indexOf(from);
        int numberOfChanges = 0;
        while (index != -1 && index < builder.length() - endOffset) {
            builder.replace(index, index + from.length(), to);
            index += to.length();
            index = builder.indexOf(from, index);
            ++numberOfChanges;
        }
        return numberOfChanges;
    }

    private final int replaceHexToColor(StringBuilder builder, int endOffset) {
        Matcher matcher = HEX_PATTERN.matcher(builder);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher matcher2 = matcher;
        int numberOfChanges = 0;
        int startIndex = 0;
        while (matcher2.find(startIndex) && (startIndex = matcher2.start()) < builder.length() - endOffset) {
            builder.replace(startIndex, startIndex + 1, "\u00a7x");
            startIndex += 2;
            for (int i = 0; i < 6; ++i) {
                builder.insert(startIndex, '\u00a7');
                startIndex += 2;
            }
            ++numberOfChanges;
        }
        return numberOfChanges;
    }

    private final int replaceColorToHex(StringBuilder builder, int endOffset) {
        Matcher matcher = TRANSFORMED_HEX_PATTERN.matcher(builder);
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher matcher2 = matcher;
        int numberOfChanges = 0;
        int startIndex = 0;
        while (matcher2.find(startIndex) && (startIndex = matcher2.start()) < builder.length() - endOffset) {
            builder.replace(startIndex, startIndex + 2, "#");
            ++startIndex;
            for (int i = 0; i < 6; ++i) {
                builder.deleteCharAt(startIndex);
                ++startIndex;
            }
            ++numberOfChanges;
        }
        return numberOfChanges;
    }

    static {
        Pattern pattern = Pattern.compile("#[A-Fa-f0-9]{6}");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        HEX_PATTERN = pattern;
        TRANSFORMED_HEX_PATTERN = Pattern.compile("\u00a7x(\u00a7[0-9a-fA-F]){6}");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lxyz/alexcrea/cuanvil/util/AnvilColorUtil$ColorUseType;", "", "colorCodePerm", "", "hexColorPerm", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getColorCodePerm", "()Ljava/lang/String;", "getHexColorPerm", "RENAME", "LORE_EDIT", "CustomAnvil"})
    public static final class ColorUseType
    extends Enum<ColorUseType> {
        @Nullable
        private final String colorCodePerm;
        @Nullable
        private final String hexColorPerm;
        public static final /* enum */ ColorUseType RENAME = new ColorUseType("ca.color.code", "ca.color.hex");
        public static final /* enum */ ColorUseType LORE_EDIT = new ColorUseType(null, null);
        private static final /* synthetic */ ColorUseType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ColorUseType(String colorCodePerm, String hexColorPerm) {
            this.colorCodePerm = colorCodePerm;
            this.hexColorPerm = hexColorPerm;
        }

        @Nullable
        public final String getColorCodePerm() {
            return this.colorCodePerm;
        }

        @Nullable
        public final String getHexColorPerm() {
            return this.hexColorPerm;
        }

        public static ColorUseType[] values() {
            return (ColorUseType[])$VALUES.clone();
        }

        public static ColorUseType valueOf(String value) {
            return Enum.valueOf(ColorUseType.class, value);
        }

        @NotNull
        public static EnumEntries<ColorUseType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = colorUseTypeArray = new ColorUseType[]{ColorUseType.RENAME, ColorUseType.LORE_EDIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

