/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.inventoryframework.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.inventoryframework.util.InventoryViewUtil;
import xyz.alexcrea.inventoryframework.util.UUIDTagType;

public class GuiItem {
    @NotNull
    private final Logger logger;
    @NotNull
    private final NamespacedKey keyUUID;
    @Nullable
    private Consumer<InventoryClickEvent> action;
    @NotNull
    private List<Object> properties;
    @NotNull
    private ItemStack item;
    private boolean visible;
    @NotNull
    private UUID uuid = UUID.randomUUID();

    public GuiItem(@NotNull ItemStack item, @Nullable Consumer<InventoryClickEvent> action, @NotNull Plugin plugin) {
        this(item, action, plugin.getLogger(), new NamespacedKey(plugin, "IF-uuid"));
    }

    public GuiItem(@NotNull ItemStack item, @NotNull Plugin plugin) {
        this(item, event -> {}, plugin);
    }

    public GuiItem(@NotNull ItemStack item, @Nullable Consumer<InventoryClickEvent> action) {
        this(item, action, (Plugin)JavaPlugin.getProvidingPlugin(GuiItem.class));
    }

    public GuiItem(@NotNull ItemStack item) {
        this(item, (InventoryClickEvent event) -> {});
    }

    private GuiItem(@NotNull ItemStack item, @Nullable Consumer<InventoryClickEvent> action, @NotNull Logger logger, @NotNull NamespacedKey key) {
        this.logger = logger;
        this.keyUUID = key;
        this.action = action;
        this.visible = true;
        this.properties = new ArrayList<Object>();
        this.item = item;
        this.applyUUID();
    }

    @NotNull
    @Contract(pure=true)
    public GuiItem copy() {
        GuiItem guiItem = new GuiItem(this.item.clone(), this.action, this.logger, this.keyUUID);
        guiItem.visible = this.visible;
        guiItem.uuid = this.uuid;
        guiItem.properties = new ArrayList<Object>(this.properties);
        ItemMeta meta = guiItem.item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(this.keyUUID, (PersistentDataType)UUIDTagType.INSTANCE, (Object)guiItem.uuid);
            guiItem.item.setItemMeta(meta);
        }
        return guiItem;
    }

    public void callAction(@NotNull InventoryClickEvent event) {
        if (this.action == null) {
            return;
        }
        try {
            this.action.accept(event);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Exception while handling click event in inventory '" + InventoryViewUtil.getInstance().getTitle(event.getView()) + "', slot=" + event.getSlot() + ", item=" + this.item.getType(), t);
        }
    }

    public void applyUUID() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(this.keyUUID, (PersistentDataType)UUIDTagType.INSTANCE, (Object)this.uuid);
            this.item.setItemMeta(meta);
        }
    }

    public void setItem(@NotNull ItemStack item) {
        this.item = item;
    }

    public void setAction(@NotNull Consumer<InventoryClickEvent> action) {
        this.action = action;
    }

    @NotNull
    @Contract(pure=true)
    public List<Object> getProperties() {
        return this.properties;
    }

    public void setProperties(@NotNull List<Object> properties) {
        this.properties = properties;
    }

    @NotNull
    @Contract(pure=true)
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    @Contract(pure=true)
    public NamespacedKey getKey() {
        return this.keyUUID;
    }

    @NotNull
    @Contract(pure=true)
    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

