/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.ask;

import io.delilaheve.CustomAnvil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.config.ask.AbstractAskGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.gui.util.GuiSharedConstant;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class SelectItemTypeGui
extends AbstractAskGui {
    private ItemStack selectedItem = null;

    public SelectItemTypeGui(@NotNull String title, @NotNull String actionDescription, @NotNull Gui backOnCancel, @NotNull BiConsumer<ItemStack, HumanEntity> onSave, boolean materialOnly) {
        super(3, title, backOnCancel);
        GuiItem confirmItem = new GuiItem(GuiSharedConstant.CONFIRM_ITEM, event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage("\u00a7cYou do not have permission to edit the config");
                return;
            }
            onSave.accept(this.selectedItem, player);
        }, (Plugin)CustomAnvil.instance);
        this.pane.bindItem('S', GuiGlobalItems.backgroundItem());
        ItemStack selectItem = this.setDisplayMeta(new ItemStack(Material.BARRIER), actionDescription);
        AtomicReference<GuiItem> selectGuiItem = new AtomicReference<GuiItem>();
        selectGuiItem.set(new GuiItem(selectItem, event -> {
            event.setCancelled(true);
            ItemStack cursor = event.getWhoClicked().getItemOnCursor();
            if (cursor.getType().isAir()) {
                return;
            }
            ItemStack finalItem = materialOnly ? this.setDisplayMeta(new ItemStack(cursor.getType()), actionDescription) : cursor.clone();
            this.selectedItem = finalItem.clone();
            ((GuiItem)selectGuiItem.get()).setItem(finalItem);
            this.pane.bindItem('S', confirmItem);
            this.update();
        }, (Plugin)CustomAnvil.instance));
        this.pane.bindItem('V', (GuiItem)selectGuiItem.get());
        GuiItem temporaryLeave = GuiGlobalItems.temporaryCloseGuiToSelectItem(Material.YELLOW_STAINED_GLASS_PANE, (Gui)this);
        this.pane.bindItem('s', temporaryLeave);
    }

    private ItemStack setDisplayMeta(ItemStack item, String actionDescription) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName("\u00a7ePlace an item here");
        meta.setLore(Arrays.asList(actionDescription.split("\n")));
        item.setItemMeta(meta);
        return item;
    }

    @Override
    protected Pattern getGuiPattern() {
        return new Pattern(new String[]{"000000000", "0000V000s", "B0000000S"});
    }
}

