/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.global;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.config.ask.SelectItemTypeGui;
import xyz.alexcrea.cuanvil.gui.config.list.MappedGuiListConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.UnitRepairElementListGui;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;

public class UnitRepairConfigGui
extends MappedGuiListConfigGui<Material, MappedGuiListConfigGui.LazyElement<UnitRepairElementListGui>> {
    private static UnitRepairConfigGui INSTANCE;

    @Nullable
    public static UnitRepairConfigGui getCurrentInstance() {
        return INSTANCE;
    }

    @NotNull
    public static UnitRepairConfigGui getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UnitRepairConfigGui();
        }
        return INSTANCE;
    }

    private UnitRepairConfigGui() {
        super("Unit Repair Config");
        this.init();
    }

    @Override
    protected MappedGuiListConfigGui.LazyElement<UnitRepairElementListGui> newInstanceOfGui(Material material, GuiItem item) {
        return new MappedGuiListConfigGui.LazyElement<UnitRepairElementListGui>(item, () -> {
            UnitRepairElementListGui element = new UnitRepairElementListGui(material, this);
            element.init();
            return element;
        });
    }

    @Override
    protected ItemStack createItemForGeneric(Material material) {
        ConfigurationSection materialSection = ConfigHolder.UNIT_REPAIR_HOLDER.getConfig().getConfigurationSection(material.name().toLowerCase());
        String materialName = CasedStringUtil.snakeToUpperSpacedCase(material.name().toLowerCase());
        if (material.isAir()) {
            material = Material.BARRIER;
        }
        int reparableItemCount = materialSection == null ? 0 : materialSection.getKeys(false).size();
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7eRepaired by " + materialName);
        meta.setLore(Arrays.asList("\u00a77There is currently \u00a7e" + reparableItemCount + " \u00a77reparable item with " + materialName, "\u00a77Click here to open the menu to edit reparable item by " + materialName));
        item.setItemMeta(meta);
        return item;
    }

    @Override
    protected Collection<Material> getEveryDisplayableInstanceOfGeneric() {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (String matName : ConfigHolder.UNIT_REPAIR_HOLDER.getConfig().getKeys(false)) {
            Material mat = Material.getMaterial((String)matName.toUpperCase());
            if (mat == null) continue;
            materials.add(mat);
        }
        return materials;
    }

    @Override
    protected GuiItem prepareCreateNewItem() {
        ItemStack createItem = new ItemStack(Material.PAPER);
        ItemMeta createMeta = createItem.getItemMeta();
        assert (createMeta != null);
        createMeta.setDisplayName("\u00a7aSelect a new unit material");
        createMeta.setLore(Arrays.asList("\u00a77Select a new unit material to be used.", "\u00a77You will be asked the material to use."));
        createItem.setItemMeta(createMeta);
        return new GuiItem(createItem, clickEvent -> {
            clickEvent.setCancelled(true);
            new SelectItemTypeGui("Select unit repair item.", "\u00a77Click here with an item to set the item\n\u00a77You like to be an unit repair item", (Gui)this, (itemStack, player) -> {
                Material type = itemStack.getType();
                this.updateValueForGeneric(type, true);
                ((UnitRepairElementListGui)((MappedGuiListConfigGui.LazyElement)this.elementGuiMap.get(type)).get()).getMappedGui().show(player);
            }, true).show(clickEvent.getWhoClicked());
        }, (Plugin)CustomAnvil.instance);
    }

    @NotNull
    public MappedGuiListConfigGui.LazyElement<UnitRepairElementListGui> getInstanceOrCreate(Material mat) {
        MappedGuiListConfigGui.LazyElement element = (MappedGuiListConfigGui.LazyElement)this.elementGuiMap.get(mat);
        if (element == null) {
            this.updateValueForGeneric(mat, false);
            element = (MappedGuiListConfigGui.LazyElement)this.elementGuiMap.get(mat);
        }
        return element;
    }

    @Override
    protected String genericDisplayedName() {
        return "this function Should not be used.";
    }

    @Override
    protected Material createAndSaveNewEmptyGeneric(String name) {
        return null;
    }
}

