/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.AbstractSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class BoolSettingsGui
extends AbstractSettingGui {
    private final BoolSettingFactory holder;
    private final boolean before;
    private boolean now;
    protected GuiItem returnToDefault;

    protected BoolSettingsGui(BoolSettingFactory holder, boolean now) {
        super(3, holder.getTitle(), holder.parent);
        this.holder = holder;
        this.before = now;
        this.now = now;
        this.prepareReturnToDefault();
        this.updateValueDisplay();
    }

    @Override
    public Pattern getGuiPattern() {
        return new Pattern(new String[]{"000000000", "D0-0v0+00", "B0000000S"});
    }

    protected void prepareReturnToDefault() {
        String defaultValueLore = this.holder.defaultVal ? "\u00a7aYes \u00a77Is the default value" : "\u00a7cNo \u00a77Is the default value";
        ItemStack item = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7eReset to default value");
        meta.setLore(Collections.singletonList(defaultValueLore));
        item.setItemMeta(meta);
        this.returnToDefault = new GuiItem(item, event -> {
            event.setCancelled(true);
            this.now = this.holder.defaultVal;
            this.updateValueDisplay();
            this.update();
        }, (Plugin)CustomAnvil.instance);
    }

    protected void updateValueDisplay() {
        Material displayedMat;
        String displayedName;
        PatternPane pane = this.getPane();
        if (this.now) {
            displayedName = "\u00a7aYes";
            displayedMat = Material.GREEN_TERRACOTTA;
        } else {
            displayedName = "\u00a7cNo";
            displayedMat = Material.RED_TERRACOTTA;
        }
        ArrayList<String> valueLore = new ArrayList<String>();
        if (!this.holder.displayLore.isEmpty()) {
            valueLore.addAll(this.holder.displayLore);
            valueLore.add("");
        }
        valueLore.add("\u00a77Click Here to change the value");
        ItemStack valueItemStack = new ItemStack(displayedMat);
        ItemMeta valueMeta = valueItemStack.getItemMeta();
        assert (valueMeta != null);
        valueMeta.setDisplayName(displayedName);
        valueMeta.setLore(valueLore);
        valueItemStack.setItemMeta(valueMeta);
        GuiItem resultItem = new GuiItem(valueItemStack, this.inverseNowConsumer(), (Plugin)CustomAnvil.instance);
        pane.bindItem('v', resultItem);
        GuiItem returnToDefault = this.now != this.holder.defaultVal ? this.returnToDefault : GuiGlobalItems.backgroundItem();
        pane.bindItem('D', returnToDefault);
    }

    protected Consumer<InventoryClickEvent> inverseNowConsumer() {
        return event -> {
            event.setCancelled(true);
            this.now = !this.now;
            this.updateValueDisplay();
            this.update();
        };
    }

    @Override
    public boolean onSave() {
        this.holder.config.getConfig().set(this.holder.configPath, (Object)this.now);
        return this.holder.config.saveToDisk(true);
    }

    @Override
    public boolean hadChange() {
        return this.now != this.before;
    }

    public static class BoolSettingFactory
    extends AbstractSettingGui.SettingGuiFactory {
        @NotNull
        String title;
        @NotNull
        ValueUpdatableGui parent;
        boolean defaultVal;
        @NotNull
        List<String> displayLore;

        public BoolSettingFactory(@NotNull String title, @NotNull ValueUpdatableGui parent, @NotNull ConfigHolder config, @NotNull String configPath, boolean defaultVal, String ... displayLore) {
            super(configPath, config);
            this.title = title;
            this.parent = parent;
            this.defaultVal = defaultVal;
            this.displayLore = Arrays.asList(displayLore);
        }

        @NotNull
        public String getTitle() {
            return this.title;
        }

        public boolean getConfiguredValue() {
            return this.config.getConfig().getBoolean(this.configPath, this.defaultVal);
        }

        @Override
        public Gui create() {
            boolean now = this.getConfiguredValue();
            return new BoolSettingsGui(this, now);
        }

        public GuiItem getItem(String name) {
            String finalValue;
            Material itemMat;
            boolean value = this.getConfiguredValue();
            StringBuilder itemName = new StringBuilder("\u00a7e");
            if (value) {
                itemMat = Material.GREEN_TERRACOTTA;
                finalValue = "\u00a7aYes";
            } else {
                itemMat = Material.RED_TERRACOTTA;
                finalValue = "\u00a7cNo";
            }
            itemName.append(name);
            return GuiGlobalItems.createGuiItemFromProperties(this, itemMat, itemName, finalValue, this.displayLore, false);
        }

        public GuiItem getItem() {
            String configPath = GuiGlobalItems.getConfigNameFromPath(this.getConfigPath());
            return this.getItem(CasedStringUtil.detectToUpperSpacedCase(configPath));
        }
    }
}

