/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.AbstractSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class DoubleSettingGui
extends AbstractSettingGui {
    protected final DoubleSettingFactory holder;
    protected final boolean asPercentage;
    protected final boolean nullOnZero;
    @NotNull
    protected final BigDecimal before;
    @NotNull
    protected BigDecimal now;
    protected BigDecimal step;
    private static final ItemStack DELETE_ITEM_STACK = new ItemStack(Material.RED_TERRACOTTA);
    private GuiItem askDelete;
    protected GuiItem returnToDefault;
    private static final BigDecimal PERCENTAGE_OFFSET;

    protected DoubleSettingGui(DoubleSettingFactory holder, @NotNull BigDecimal now, boolean asPercentage, boolean nullOnZero) {
        super(3, holder.getTitle(), holder.parent);
        assert (holder.steps.length > 0 && holder.steps.length <= 9);
        this.holder = holder;
        this.asPercentage = asPercentage;
        this.nullOnZero = nullOnZero;
        this.before = now;
        this.now = now;
        this.step = holder.steps[0];
        this.initStepsValue();
        this.prepareReturnToDefault();
        this.updateValueDisplay();
    }

    @Override
    protected void initBase(ValueUpdatableGui parent) {
        super.initBase(parent);
        this.askDelete = new GuiItem(DELETE_ITEM_STACK, GuiGlobalActions.saveSettingAction(this, parent), (Plugin)CustomAnvil.instance);
    }

    @Override
    public void update() {
        boolean shouldDelete = this.isNull() && this.hadChange();
        GuiItem tempSaveItem = this.saveItem;
        if (shouldDelete) {
            this.saveItem = this.askDelete;
        }
        super.update();
        if (shouldDelete) {
            this.saveItem = tempSaveItem;
        }
    }

    @Override
    public Pattern getGuiPattern() {
        return new Pattern(new String[]{"abcdefghi", "D0-0v0+00", "B0000000S"});
    }

    protected void prepareReturnToDefault() {
        ItemStack item = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7eReset to default value");
        meta.setLore(Collections.singletonList("\u00a77Default value is \u00a7e" + this.displayValue(this.holder.defaultVal)));
        item.setItemMeta(meta);
        this.returnToDefault = new GuiItem(item, event -> {
            event.setCancelled(true);
            this.now = this.holder.defaultVal;
            this.updateValueDisplay();
            this.update();
        }, (Plugin)CustomAnvil.instance);
    }

    protected void updateValueDisplay() {
        GuiItem plusItem;
        GuiItem minusItem;
        PatternPane pane = this.getPane();
        if (this.now.compareTo(this.holder.min) > 0) {
            BigDecimal planned = this.holder.min.max(this.now.subtract(this.step));
            minusItem = this.getSetValueItem(Material.RED_TERRACOTTA, planned, "\u00a7c-");
        } else {
            minusItem = GuiGlobalItems.backgroundItem(Material.BARRIER);
        }
        pane.bindItem('-', minusItem);
        if (this.now.compareTo(this.holder.max) < 0) {
            BigDecimal planned = this.holder.max.min(this.now.add(this.step));
            plusItem = this.getSetValueItem(Material.GREEN_TERRACOTTA, planned, "\u00a7a+");
        } else {
            plusItem = GuiGlobalItems.backgroundItem(Material.BARRIER);
        }
        pane.bindItem('+', plusItem);
        ItemStack resultPaper = new ItemStack(Material.PAPER);
        ItemMeta resultMeta = resultPaper.getItemMeta();
        assert (resultMeta != null);
        resultMeta.setDisplayName("\u00a7fValue: \u00a7e" + this.displayValue(this.now));
        resultPaper.setItemMeta(resultMeta);
        GuiItem resultItem = new GuiItem(resultPaper, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
        pane.bindItem('v', resultItem);
        GuiItem returnToDefault = this.now.compareTo(this.holder.defaultVal) != 0 ? this.returnToDefault : GuiGlobalItems.backgroundItem();
        pane.bindItem('D', returnToDefault);
    }

    private GuiItem getSetValueItem(Material mat, BigDecimal planned, String numberPrefix) {
        ArrayList<String> setLoreItem = new ArrayList<String>();
        if (!this.holder.displayLore.isEmpty()) {
            setLoreItem.addAll(this.holder.displayLore);
            setLoreItem.add("");
        }
        setLoreItem.add("\u00a77Click Here to change the value");
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7e" + this.displayValue(this.now) + " \u00a7f-> \u00a7e" + this.displayValue(planned) + " \u00a7r(" + numberPrefix + this.displayValue(planned.subtract(this.now).abs()) + "\u00a7r)");
        meta.setLore(setLoreItem);
        item.setItemMeta(meta);
        return new GuiItem(item, this.updateNowConsumer(planned), (Plugin)CustomAnvil.instance);
    }

    protected Consumer<InventoryClickEvent> updateNowConsumer(BigDecimal planned) {
        return event -> {
            event.setCancelled(true);
            this.now = planned;
            this.updateValueDisplay();
            this.update();
        };
    }

    protected void initStepsValue() {
        GuiItem background = GuiGlobalItems.backgroundItem();
        PatternPane pane = this.getPane();
        for (char i = 'a'; i < (this.getMidStepChar() - 97) * 2 + 1; i = (char)(i + '\u0001')) {
            pane.bindItem(i, background);
        }
        this.updateStepValue();
    }

    protected void updateStepValue() {
        if (this.holder.steps.length <= 1) {
            return;
        }
        char val = this.getMidStepChar();
        val = (char)(val - (char)((this.holder.steps.length - 1) / 2));
        PatternPane pane = this.getPane();
        for (int i = 0; i < this.holder.steps.length; ++i) {
            pane.bindItem(val + i, this.stepGuiItem(i));
        }
    }

    protected char getMidStepChar() {
        return 'e';
    }

    protected GuiItem stepGuiItem(int stepIndex) {
        Consumer<InventoryClickEvent> clickEvent;
        List<CallSite> stepLore;
        Material stepMat;
        BigDecimal stepValue = this.holder.steps[stepIndex];
        StringBuilder stepName = new StringBuilder("\u00a7");
        if (stepValue.compareTo(this.step) == 0) {
            stepMat = Material.GREEN_STAINED_GLASS_PANE;
            stepName.append('a');
            stepLore = Collections.singletonList("\u00a77Value is changing by " + this.displayValue(stepValue));
            clickEvent = GuiGlobalActions.stayInPlace;
        } else {
            stepMat = Material.RED_STAINED_GLASS_PANE;
            stepName.append('c');
            stepLore = Collections.singletonList("\u00a77Click here to change the value by " + this.displayValue(stepValue));
            clickEvent = this.updateStepValue(stepValue);
        }
        stepName.append("Step of \u00a7e").append(this.displayValue(stepValue));
        ItemStack item = new ItemStack(stepMat);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName(stepName.toString());
        meta.setLore(stepLore);
        item.setItemMeta(meta);
        return new GuiItem(item, clickEvent, (Plugin)CustomAnvil.instance);
    }

    protected Consumer<InventoryClickEvent> updateStepValue(BigDecimal stepValue) {
        return event -> {
            event.setCancelled(true);
            this.step = stepValue;
            this.updateStepValue();
            this.updateValueDisplay();
            this.update();
        };
    }

    @Override
    public boolean onSave() {
        if (this.isNull()) {
            ConfigHolder configHolder = this.holder.config;
            if (configHolder instanceof ConfigHolder.DeletableResource) {
                ConfigHolder.DeletableResource deletableResource = (ConfigHolder.DeletableResource)configHolder;
                deletableResource.delete(this.holder.configPath);
            } else {
                this.holder.config.getConfig().set(this.holder.configPath, null);
            }
        } else {
            this.holder.config.getConfig().set(this.holder.configPath, (Object)this.now.doubleValue());
        }
        return this.holder.config.saveToDisk(true);
    }

    @Override
    public boolean hadChange() {
        return this.now.compareTo(this.before) != 0;
    }

    public boolean isNull() {
        return this.nullOnZero && this.now.compareTo(BigDecimal.ZERO) == 0;
    }

    public String displayValue(BigDecimal value) {
        return DoubleSettingGui.displayValue(value, this.asPercentage);
    }

    public static String displayValue(BigDecimal value, boolean isAsPercentage) {
        if (isAsPercentage) {
            return String.valueOf(value.multiply(PERCENTAGE_OFFSET).setScale(value.scale() - 2, RoundingMode.HALF_UP)) + "%";
        }
        return value.toString();
    }

    static {
        ItemMeta meta = DELETE_ITEM_STACK.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7cDisable item being repaired ?");
        meta.setLore(Arrays.asList("\u00a77Confirm disabling unit repair for this item..", "\u00a74Cation: This action can't be canceled."));
        DELETE_ITEM_STACK.setItemMeta(meta);
        PERCENTAGE_OFFSET = BigDecimal.valueOf(100L);
    }

    public static class DoubleSettingFactory
    extends AbstractSettingGui.SettingGuiFactory {
        @NotNull
        String title;
        @NotNull
        ValueUpdatableGui parent;
        int scale;
        boolean asPercentage;
        boolean nullOnZero;
        BigDecimal min;
        BigDecimal max;
        BigDecimal defaultVal;
        BigDecimal[] steps;
        @NotNull
        List<String> displayLore;

        public DoubleSettingFactory(@NotNull String title, @NotNull ValueUpdatableGui parent, @NotNull ConfigHolder config, @NotNull String configPath, @Nullable List<String> displayLore, int scale, boolean asPercentage, boolean nullOnZero, double min, double max, double defaultVal, double ... steps) {
            super(configPath, config);
            this.title = title;
            this.parent = parent;
            this.scale = scale;
            this.asPercentage = asPercentage;
            this.nullOnZero = nullOnZero;
            this.min = BigDecimal.valueOf(min).setScale(scale, RoundingMode.HALF_UP);
            this.max = BigDecimal.valueOf(max).setScale(scale, RoundingMode.HALF_UP);
            this.defaultVal = BigDecimal.valueOf(defaultVal).setScale(scale, RoundingMode.HALF_UP);
            this.steps = new BigDecimal[steps.length];
            for (int i = 0; i < steps.length; ++i) {
                this.steps[i] = BigDecimal.valueOf(steps[i]).setScale(scale, RoundingMode.HALF_UP);
            }
            this.displayLore = displayLore == null ? Collections.emptyList() : displayLore;
        }

        @NotNull
        public String getTitle() {
            return this.title;
        }

        public BigDecimal getConfiguredValue() {
            FileConfiguration section = this.config.getConfig();
            if (section.isDouble(this.configPath)) {
                return BigDecimal.valueOf(section.getDouble(this.configPath)).setScale(2, RoundingMode.HALF_UP);
            }
            return this.defaultVal;
        }

        @Override
        public Gui create() {
            BigDecimal now = this.getConfiguredValue();
            return new DoubleSettingGui(this, now, this.asPercentage, this.nullOnZero);
        }

        public GuiItem getItem(Material itemMat, String name) {
            BigDecimal value = this.getConfiguredValue();
            StringBuilder itemName = new StringBuilder("\u00a7a").append(name);
            return GuiGlobalItems.createGuiItemFromProperties(this, itemMat, itemName, "\u00a7e" + DoubleSettingGui.displayValue(value, this.asPercentage), this.displayLore, true);
        }

        public GuiItem getItem(Material itemMat) {
            String configPath = GuiGlobalItems.getConfigNameFromPath(this.getConfigPath());
            return this.getItem(itemMat, CasedStringUtil.detectToUpperSpacedCase(configPath));
        }
    }
}

