/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.CAEnchantmentRegistry;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.MainConfigGui;
import xyz.alexcrea.cuanvil.gui.config.SelectEnchantmentContainer;
import xyz.alexcrea.cuanvil.gui.config.list.SettingGuiListConfigGui;
import xyz.alexcrea.cuanvil.gui.config.settings.AbstractSettingGui;
import xyz.alexcrea.cuanvil.gui.config.settings.SettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class EnchantSelectSettingGui
extends SettingGuiListConfigGui<CAEnchantment, DummyFactory>
implements SettingGui {
    private final SelectEnchantmentContainer enchantContainer;
    private final Set<CAEnchantment> selectedEnchant;
    private final GuiItem saveItem;
    private boolean displayUnselected;
    private static final List<String> TRUE_LORE = Collections.singletonList("\u00a77Value: \u00a7aSelected");
    private static final List<String> FALSE_LORE = Collections.singletonList("\u00a77Value: \u00a7cNot Selected");

    public EnchantSelectSettingGui(@NotNull String title, ValueUpdatableGui parent, SelectEnchantmentContainer enchantContainer) {
        MainConfigGui mainConfigGui;
        if (parent instanceof Gui) {
            Gui parentGui = (Gui)parent;
            mainConfigGui = parentGui;
        } else {
            mainConfigGui = MainConfigGui.getInstance();
        }
        super(title, (Gui)mainConfigGui);
        this.enchantContainer = enchantContainer;
        this.selectedEnchant = new HashSet<CAEnchantment>(enchantContainer.getSelectedEnchantments());
        this.saveItem = GuiGlobalItems.saveItem(this, parent);
        this.backgroundPane.bindItem('S', GuiGlobalItems.noChangeItem());
        this.displayUnselected = true;
        this.backgroundPane.bindItem('b', this.createDisplayUnusedItem());
        this.init();
    }

    @Override
    protected Pattern getBackgroundPattern() {
        return new Pattern(new String[]{"111111111", "100000001", "100000001", "100000001", "100000001", "B11LbR11S"});
    }

    @Override
    protected Collection<CAEnchantment> getEveryDisplayableInstanceOfGeneric() {
        Stream<Object> toDisplayStream = this.displayUnselected ? CAEnchantmentRegistry.getInstance().getNameSortedEnchantments().stream() : this.selectedEnchant.stream().sorted(Comparator.comparing(CAEnchantment::getName));
        Set<CAEnchantment> illegalEnchantments = this.enchantContainer.illegalEnchantments();
        return toDisplayStream.filter(enchantment -> !illegalEnchantments.contains(enchantment)).toList();
    }

    public void update() {
        this.backgroundPane.bindItem('S', this.hadChange() ? this.saveItem : GuiGlobalItems.noChangeItem());
        super.update();
    }

    @Override
    protected GuiItem itemFromFactory(CAEnchantment enchantment, DummyFactory factory) {
        boolean isIn = this.selectedEnchant.contains(enchantment);
        Material usedMaterial = isIn ? Material.ENCHANTED_BOOK : Material.BOOK;
        ItemStack item = new ItemStack(usedMaterial);
        this.setEnchantItemMeta(item, enchantment.getKey().getKey(), isIn);
        GuiItem guiItem = new GuiItem(item, (Plugin)CustomAnvil.instance);
        guiItem.setAction(this.getEnchantItemConsumer(enchantment, guiItem));
        return guiItem;
    }

    private GuiItem createDisplayUnusedItem() {
        ItemStack item = new ItemStack(this.displayUnselected ? Material.BOOK : Material.ENCHANTED_BOOK);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName(this.displayUnselected ? "\u00a7aEverything displayed" : "\u00a7eOnly selected displayed");
        meta.setLore(Collections.singletonList("\u00a77Click here to see " + (this.displayUnselected ? "only selected" : "every") + " enchantments"));
        item.setItemMeta(meta);
        return new GuiItem(item, clickEvent -> {
            clickEvent.setCancelled(true);
            this.displayUnselected = !this.displayUnselected;
            this.backgroundPane.bindItem('b', this.createDisplayUnusedItem());
            this.reloadValues();
        }, (Plugin)CustomAnvil.instance);
    }

    public void setEnchantItemMeta(ItemStack item, String name, boolean isIn) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            CustomAnvil.instance.getLogger().warning("Could not create item for enchantment: " + name + ":\nItem do not gave item meta: " + String.valueOf(item) + ". Using a placeholder item instead");
            item.setType(Material.PAPER);
            meta = item.getItemMeta();
            assert (meta != null);
        }
        meta.setDisplayName("\u00a7" + (isIn ? (char)'a' : 'c') + CasedStringUtil.snakeToUpperSpacedCase(name));
        if (isIn) {
            meta.addEnchant(Enchantment.DAMAGE_UNDEAD, 1, true);
            meta.setLore(TRUE_LORE);
        } else {
            meta.removeEnchant(Enchantment.DAMAGE_UNDEAD);
            meta.setLore(FALSE_LORE);
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
    }

    private Consumer<InventoryClickEvent> getEnchantItemConsumer(CAEnchantment enchant, GuiItem guiItem) {
        return event -> {
            event.setCancelled(true);
            ItemStack item = guiItem.getItem();
            boolean isIn = this.selectedEnchant.contains(enchant);
            if (isIn) {
                this.selectedEnchant.remove(enchant);
                item.setType(Material.BOOK);
            } else {
                this.selectedEnchant.add(enchant);
                item.setType(Material.ENCHANTED_BOOK);
            }
            this.setEnchantItemMeta(item, enchant.getKey().getKey(), !isIn);
            guiItem.setItem(item);
            this.update();
        };
    }

    @Override
    public boolean onSave() {
        return this.enchantContainer.setSelectedEnchantments(this.selectedEnchant);
    }

    @Override
    public boolean hadChange() {
        Set<CAEnchantment> baseGroup = this.enchantContainer.getSelectedEnchantments();
        return baseGroup.size() != this.selectedEnchant.size() || !baseGroup.containsAll(this.selectedEnchant);
    }

    @Override
    protected List<String> getCreateItemLore() {
        return Collections.emptyList();
    }

    @Override
    protected Consumer<InventoryClickEvent> getCreateClickConsumer() {
        return null;
    }

    @Override
    protected String createItemName() {
        return null;
    }

    @Override
    protected DummyFactory createFactory(CAEnchantment generic) {
        return null;
    }

    public static class DummyFactory
    extends AbstractSettingGui.SettingGuiFactory {
        protected DummyFactory(@NotNull String configPath, @NotNull ConfigHolder config) {
            super(configPath, config);
        }

        @Override
        public Gui create() {
            return null;
        }
    }
}

