/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.SelectGroupContainer;
import xyz.alexcrea.cuanvil.gui.config.settings.AbstractSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiSharedConstant;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.pane.Orientable;
import xyz.alexcrea.inventoryframework.pane.OutlinePane;
import xyz.alexcrea.inventoryframework.pane.Pane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class GroupSelectSettingGui
extends AbstractSettingGui {
    SelectGroupContainer groupContainer;
    int page;
    Set<AbstractMaterialGroup> selectedGroups;
    private static final List<String> TRUE_LORE = Collections.singletonList("\u00a77Value: \u00a7aSelected");
    private static final List<String> FALSE_LORE = Collections.singletonList("\u00a77Value: \u00a7cNot Selected");

    public GroupSelectSettingGui(@NotNull String title, ValueUpdatableGui parent, SelectGroupContainer groupContainer, int page) {
        super(6, title, parent);
        this.groupContainer = groupContainer;
        this.page = page;
        this.selectedGroups = new HashSet<AbstractMaterialGroup>(groupContainer.getSelectedGroups());
        this.getPane().bindItem('1', GuiSharedConstant.SECONDARY_BACKGROUND_ITEM);
        this.initGroups();
    }

    @Override
    protected Pattern getGuiPattern() {
        return new Pattern(new String[]{"111111111", "100000001", "100000001", "100000001", "100000001", "B1111111S"});
    }

    protected void initGroups() {
        OutlinePane filledEnchant = new OutlinePane(1, 1, 7, 4);
        filledEnchant.setPriority(Pane.Priority.HIGH);
        filledEnchant.align(OutlinePane.Alignment.BEGIN);
        filledEnchant.setOrientation(Orientable.Orientation.HORIZONTAL);
        Set<AbstractMaterialGroup> illegalGroup = this.groupContainer.illegalGroups();
        for (AbstractMaterialGroup group : ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager().getGroupMap().values()) {
            if (illegalGroup.contains(group)) continue;
            filledEnchant.addItem(this.getGuiItemFromGroup(group));
        }
        this.addPane((Pane)filledEnchant);
    }

    private GuiItem getGuiItemFromGroup(AbstractMaterialGroup group) {
        boolean isIn = this.selectedGroups.contains(group);
        Material usedMaterial = group.getRepresentativeMaterial();
        ItemStack item = new ItemStack(usedMaterial);
        this.setGroupItemMeta(item, group.getName(), isIn);
        GuiItem guiItem = new GuiItem(item, (Plugin)CustomAnvil.instance);
        guiItem.setAction(this.getGroupItemConsumer(group, guiItem));
        return guiItem;
    }

    public void setGroupItemMeta(ItemStack item, String name, boolean isIn) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            CustomAnvil.instance.getLogger().warning("Could not create item for group: " + name + ":\nItem do not gave item meta: " + String.valueOf(item) + ". Using placeholder instead");
            item.setType(Material.PAPER);
            meta = item.getItemMeta();
            assert (meta != null);
        }
        meta.setDisplayName("\u00a7" + (isIn ? (char)'a' : 'c') + CasedStringUtil.snakeToUpperSpacedCase(name));
        if (isIn) {
            meta.addEnchant(Enchantment.DAMAGE_UNDEAD, 1, true);
            meta.setLore(TRUE_LORE);
        } else {
            meta.removeEnchant(Enchantment.DAMAGE_UNDEAD);
            meta.setLore(FALSE_LORE);
        }
        meta.addItemFlags(ItemFlag.values());
        item.setItemMeta(meta);
    }

    private Consumer<InventoryClickEvent> getGroupItemConsumer(AbstractMaterialGroup group, GuiItem guiItem) {
        return event -> {
            event.setCancelled(true);
            boolean isIn = this.selectedGroups.contains(group);
            if (isIn) {
                this.selectedGroups.remove(group);
            } else {
                this.selectedGroups.add(group);
            }
            ItemStack item = guiItem.getItem();
            this.setGroupItemMeta(item, group.getName(), !isIn);
            guiItem.setItem(item);
            this.update();
        };
    }

    @Override
    public boolean onSave() {
        return this.groupContainer.setSelectedGroups(this.selectedGroups);
    }

    @Override
    public boolean hadChange() {
        Set<AbstractMaterialGroup> baseGroup = this.groupContainer.getSelectedGroups();
        return baseGroup.size() != this.selectedGroups.size() || !baseGroup.containsAll(this.selectedGroups);
    }
}

