/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.update;

import io.delilaheve.CustomAnvil;
import org.bukkit.configuration.file.FileConfiguration;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.update.UpdateUtils;
import xyz.alexcrea.cuanvil.update.Version;

public class Update_1_21_9 {
    private static final Version V1_21_9 = new Version(1, 21, 9);

    public static boolean handleUpdate(Version current) {
        Version version;
        if (V1_21_9.greaterThan(current)) {
            return false;
        }
        String oldVersion = ConfigHolder.DEFAULT_CONFIG.getConfig().getString("lowMinecraftVersion");
        if (oldVersion != null && V1_21_9.lesserEqual(version = Version.fromString(oldVersion))) {
            return false;
        }
        Update_1_21_9.doUpdate();
        return true;
    }

    private static void doUpdate() {
        CustomAnvil.instance.getLogger().info("Updating config to support 1.21.9 ...");
        FileConfiguration baseConfig = ConfigHolder.DEFAULT_CONFIG.getConfig();
        FileConfiguration groupConfig = ConfigHolder.ITEM_GROUP_HOLDER.getConfig();
        UpdateUtils.addAbsentToList(groupConfig, "helmets.items", "copper_helmet");
        UpdateUtils.addAbsentToList(groupConfig, "chestplate.items", "copper_chestplate");
        UpdateUtils.addAbsentToList(groupConfig, "leggings.items", "copper_leggings");
        UpdateUtils.addAbsentToList(groupConfig, "boots.items", "copper_boots");
        UpdateUtils.addAbsentToList(groupConfig, "pickaxes.items", "copper_pickaxe");
        UpdateUtils.addAbsentToList(groupConfig, "shovels.items", "copper_shovel");
        UpdateUtils.addAbsentToList(groupConfig, "hoes.items", "copper_hoe");
        UpdateUtils.addAbsentToList(groupConfig, "axes.items", "copper_axe");
        UpdateUtils.addAbsentToList(groupConfig, "swords.items", "copper_sword");
        baseConfig.set("lowMinecraftVersion", (Object)V1_21_9.toString());
        ConfigHolder.DEFAULT_CONFIG.saveToDisk(true);
        ConfigHolder.ITEM_GROUP_HOLDER.saveToDisk(true);
        ConfigHolder.ITEM_GROUP_HOLDER.reload();
    }
}

