/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.util.MiniMessageUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J@\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nJ\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\nJ(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001cH\u0002J$\u0010\"\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001ej\u0002`#2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u001c\u0010%\u001a\u00020\u000e2\n\u0010\u001d\u001a\u00060\u001ej\u0002`#2\u0006\u0010&\u001a\u00020\u001cH\u0002J\u001c\u0010'\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001ej\u0002`#2\u0006\u0010!\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006*"}, d2={"Lxyz/alexcrea/cuanvil/util/AnvilColorUtil;", "", "<init>", "()V", "HEX_PATTERN", "Ljava/util/regex/Pattern;", "TRANSFORMED_HEX_PATTERN", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "calculatePermissions", "Lxyz/alexcrea/cuanvil/util/AnvilColorUtil$ColorPermissions;", "player", "Lorg/bukkit/permissions/Permissible;", "usePermission", "", "allowColorCode", "allowHexadecimalColor", "allowMinimessage", "useType", "Lxyz/alexcrea/cuanvil/util/AnvilColorUtil$ColorUseType;", "handleColor", "Lnet/kyori/adventure/text/Component;", "textToColorText", "", "permission", "revertColorSmallest", "component", "replaceAll", "", "builder", "Ljava/lang/StringBuilder;", "from", "to", "endOffset", "replaceHexToColor", "Lkotlin/text/StringBuilder;", "checkTag", "isInTag", "index", "replaceColorToHex", "ColorPermissions", "ColorUseType", "CustomAnvil"})
public final class AnvilColorUtil {
    @NotNull
    public static final AnvilColorUtil INSTANCE = new AnvilColorUtil();
    @NotNull
    private static final Pattern HEX_PATTERN;
    private static final Pattern TRANSFORMED_HEX_PATTERN;

    private AnvilColorUtil() {
    }

    @NotNull
    public final ColorPermissions calculatePermissions(@NotNull Permissible player, boolean usePermission, boolean allowColorCode, boolean allowHexadecimalColor, boolean allowMinimessage, @NotNull ColorUseType useType) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)useType), (String)"useType");
        if (!(allowColorCode || allowHexadecimalColor || allowMinimessage)) {
            return new ColorPermissions(false, false, false);
        }
        boolean canUseColorCode = allowColorCode && (!usePermission || useType.getColorCodePerm() == null || player.hasPermission(useType.getColorCodePerm()));
        boolean canUseMinimessage = allowMinimessage && (!usePermission || useType.getMinimessagePerm() == null || player.hasPermission(useType.getMinimessagePerm()));
        boolean canUseHexColor = allowHexadecimalColor && (!usePermission || useType.getHexColorPerm() == null || player.hasPermission(useType.getHexColorPerm()));
        return new ColorPermissions(canUseColorCode, canUseHexColor, canUseMinimessage);
    }

    @Nullable
    public final Component handleColor(@NotNull String textToColorText, @NotNull Permissible player, boolean usePermission, boolean allowColorCode, boolean allowHexadecimalColor, boolean allowMinimessage, @NotNull ColorUseType useType) {
        Intrinsics.checkNotNullParameter((Object)textToColorText, (String)"textToColorText");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)useType), (String)"useType");
        ColorPermissions permission = this.calculatePermissions(player, usePermission, allowColorCode, allowHexadecimalColor, allowMinimessage, useType);
        return this.handleColor(textToColorText, permission);
    }

    @Nullable
    public final Component handleColor(@NotNull String textToColorText, @NotNull ColorPermissions permission) {
        int nbReplacement;
        Intrinsics.checkNotNullParameter((Object)textToColorText, (String)"textToColorText");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (!permission.allowed()) {
            return null;
        }
        StringBuilder textToColor = new StringBuilder(textToColorText);
        boolean useColor = false;
        if (permission.getCanUseColorCode()) {
            nbReplacement = this.replaceAll(textToColor, "&", "\u00a7", 2);
            if ((nbReplacement -= 2 * this.replaceAll(textToColor, "\u00a7\u00a7", "&", 2)) > 0) {
                useColor = true;
            }
        }
        if (permission.getCanUseHexColor() && (nbReplacement = this.replaceHexToColor(textToColor, 7, permission.getCanUseMinimessage())) > 0) {
            useColor = true;
        }
        String string = textToColor.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String previousStr = string;
        TextComponent textComponent = MiniMessageUtil.INSTANCE.getLegacy_mm().deserialize(previousStr);
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"deserialize(...)");
        Component result = (Component)textComponent;
        if (permission.getCanUseMinimessage()) {
            Object object = MiniMessageUtil.INSTANCE.getMm().serialize(result);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"serialize(...)");
            String toMinimessage = (String)object;
            String hackySolution = StringsKt.replace$default((String)toMinimessage, (String)"\\<", (String)"<", (boolean)false, (int)4, null);
            Component component = MiniMessageUtil.INSTANCE.getMm().deserialize((Object)hackySolution);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
            Component fromMinimessage = component;
            String string2 = MiniMessageUtil.INSTANCE.getPlain_text_mm().serialize(fromMinimessage);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serialize(...)");
            String asPlain = string2;
            if (!Intrinsics.areEqual((Object)previousStr, (Object)asPlain)) {
                useColor = true;
                result = fromMinimessage;
            }
        }
        return useColor ? result : null;
    }

    @Nullable
    public final String revertColorSmallest(@Nullable Component component, @NotNull ColorPermissions permission) {
        String string;
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (!permission.allowed() || component == null) {
            return null;
        }
        Object object = MiniMessageUtil.INSTANCE.getMm().serialize(component);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"serialize(...)");
        String transformed = (String)object;
        String string2 = MiniMessageUtil.INSTANCE.getPlain_text_mm().serialize(component);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serialize(...)");
        String plainTransform = string2;
        if (Intrinsics.areEqual((Object)transformed, (Object)plainTransform)) {
            return null;
        }
        if (permission.onlyMinimessage()) {
            return transformed;
        }
        Component component2 = MiniMessageUtil.INSTANCE.getColor_only_mm().deserialize((Object)transformed);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"deserialize(...)");
        Component coloredMessage = component2;
        StringBuilder legacyMessage = new StringBuilder(MiniMessageUtil.INSTANCE.getLegacy_mm().serialize(coloredMessage));
        if (permission.getCanUseHexColor()) {
            this.replaceColorToHex(legacyMessage, 14);
        }
        if (permission.getCanUseColorCode()) {
            this.replaceAll(legacyMessage, "&", "&&", 1);
            this.replaceAll(legacyMessage, "\u00a7", "&", 2);
        }
        TextComponent textComponent = MiniMessageUtil.INSTANCE.getLegacy_mm().deserialize(legacyMessage.toString());
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"deserialize(...)");
        TextComponent fromLegacy = textComponent;
        Object object2 = MiniMessageUtil.INSTANCE.getMm().serialize((Component)fromLegacy);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"serialize(...)");
        String middleGround = (String)object2;
        StringBuilder hackySolutionStb = new StringBuilder(middleGround);
        this.replaceAll(hackySolutionStb, "\\<", "<", 2);
        String string3 = hackySolutionStb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String hackySolution = string3;
        if (permission.getCanUseMinimessage()) {
            string = hackySolution;
        } else {
            String string4 = MiniMessageUtil.INSTANCE.getMm().stripTags(hackySolution);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"stripTags(...)");
        }
        String result = string;
        return Intrinsics.areEqual((Object)result, (Object)plainTransform) ? null : result;
    }

    private final int replaceAll(StringBuilder builder, String from, String to, int endOffset) {
        int index = builder.indexOf(from);
        int numberOfChanges = 0;
        while (index != -1 && index < builder.length() - endOffset) {
            builder.replace(index, index + from.length(), to);
            index += to.length();
            index = builder.indexOf(from, index);
            ++numberOfChanges;
        }
        return numberOfChanges;
    }

    private final int replaceHexToColor(StringBuilder builder, int endOffset, boolean checkTag) {
        Matcher matcher = HEX_PATTERN.matcher(builder);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        int numberOfChanges = 0;
        int startIndex = 0;
        while (matcher2.find(startIndex) && (startIndex = matcher2.start()) < builder.length() - endOffset) {
            if (checkTag && this.isInTag(builder, startIndex)) {
                ++startIndex;
                continue;
            }
            builder.replace(startIndex, startIndex + 1, "\u00a7x");
            startIndex += 2;
            for (int i = 0; i < 6; ++i) {
                builder.insert(startIndex, '\u00a7');
                startIndex += 2;
            }
            ++numberOfChanges;
        }
        return numberOfChanges;
    }

    private final boolean isInTag(StringBuilder builder, int index) {
        CharSequence left = StringsKt.slice((CharSequence)builder, (IntRange)new IntRange(0, index));
        int leftIndex = StringsKt.lastIndexOf$default((CharSequence)left, (String)"<", (int)0, (boolean)false, (int)6, null);
        int rightIndex = StringsKt.lastIndexOf$default((CharSequence)left, (String)">", (int)0, (boolean)false, (int)6, null);
        if (leftIndex == -1 || rightIndex > leftIndex) {
            return false;
        }
        CharSequence right = StringsKt.slice((CharSequence)builder, (IntRange)RangesKt.until((int)index, (int)builder.length()));
        int newleftIndex = StringsKt.indexOf$default((CharSequence)right, (String)"<", (int)0, (boolean)false, (int)6, null);
        rightIndex = StringsKt.indexOf$default((CharSequence)right, (String)">", (int)0, (boolean)false, (int)6, null);
        if (rightIndex == -1 || newleftIndex != -1 && newleftIndex < rightIndex) {
            return false;
        }
        String expectedTag = builder.substring(leftIndex, newleftIndex + 1);
        String string = MiniMessageUtil.INSTANCE.getMm().stripTags(expectedTag);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripTags(...)");
        String notag = string;
        return !Intrinsics.areEqual((Object)notag, (Object)expectedTag);
    }

    private final int replaceColorToHex(StringBuilder builder, int endOffset) {
        Matcher matcher = TRANSFORMED_HEX_PATTERN.matcher(builder);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        int numberOfChanges = 0;
        int startIndex = 0;
        while (matcher2.find(startIndex) && (startIndex = matcher2.start()) < builder.length() - endOffset) {
            builder.replace(startIndex, startIndex + 2, "#");
            ++startIndex;
            for (int i = 0; i < 6; ++i) {
                builder.deleteCharAt(startIndex);
                ++startIndex;
            }
            ++numberOfChanges;
        }
        return numberOfChanges;
    }

    static {
        Pattern pattern = Pattern.compile("#[A-Fa-f0-9]{6}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        HEX_PATTERN = pattern;
        TRANSFORMED_HEX_PATTERN = Pattern.compile("\u00a7x(\u00a7[0-9a-fA-F]){6}");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000e"}, d2={"Lxyz/alexcrea/cuanvil/util/AnvilColorUtil$ColorPermissions;", "", "canUseColorCode", "", "canUseHexColor", "canUseMinimessage", "<init>", "(ZZZ)V", "getCanUseColorCode", "()Z", "getCanUseHexColor", "getCanUseMinimessage", "allowed", "onlyMinimessage", "CustomAnvil"})
    public static final class ColorPermissions {
        private final boolean canUseColorCode;
        private final boolean canUseHexColor;
        private final boolean canUseMinimessage;

        public ColorPermissions(boolean canUseColorCode, boolean canUseHexColor, boolean canUseMinimessage) {
            this.canUseColorCode = canUseColorCode;
            this.canUseHexColor = canUseHexColor;
            this.canUseMinimessage = canUseMinimessage;
        }

        public final boolean getCanUseColorCode() {
            return this.canUseColorCode;
        }

        public final boolean getCanUseHexColor() {
            return this.canUseHexColor;
        }

        public final boolean getCanUseMinimessage() {
            return this.canUseMinimessage;
        }

        public final boolean allowed() {
            return this.canUseColorCode || this.canUseHexColor || this.canUseMinimessage;
        }

        public final boolean onlyMinimessage() {
            return this.canUseMinimessage && !this.canUseColorCode && !this.canUseHexColor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lxyz/alexcrea/cuanvil/util/AnvilColorUtil$ColorUseType;", "", "colorCodePerm", "", "hexColorPerm", "minimessagePerm", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getColorCodePerm", "()Ljava/lang/String;", "getHexColorPerm", "getMinimessagePerm", "RENAME", "LORE_EDIT", "CustomAnvil"})
    public static final class ColorUseType
    extends Enum<ColorUseType> {
        @Nullable
        private final String colorCodePerm;
        @Nullable
        private final String hexColorPerm;
        @Nullable
        private final String minimessagePerm;
        public static final /* enum */ ColorUseType RENAME = new ColorUseType("ca.color.code", "ca.color.hex", "ca.rename.minimessage");
        public static final /* enum */ ColorUseType LORE_EDIT = new ColorUseType(null, null, null);
        private static final /* synthetic */ ColorUseType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ColorUseType(String colorCodePerm, String hexColorPerm, String minimessagePerm) {
            this.colorCodePerm = colorCodePerm;
            this.hexColorPerm = hexColorPerm;
            this.minimessagePerm = minimessagePerm;
        }

        @Nullable
        public final String getColorCodePerm() {
            return this.colorCodePerm;
        }

        @Nullable
        public final String getHexColorPerm() {
            return this.hexColorPerm;
        }

        @Nullable
        public final String getMinimessagePerm() {
            return this.minimessagePerm;
        }

        public static ColorUseType[] values() {
            return (ColorUseType[])$VALUES.clone();
        }

        public static ColorUseType valueOf(String value) {
            return Enum.valueOf(ColorUseType.class, value);
        }

        @NotNull
        public static EnumEntries<ColorUseType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = colorUseTypeArray = new ColorUseType[]{ColorUseType.RENAME, ColorUseType.LORE_EDIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

