/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.api;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.api.ConflictBuilder;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;
import xyz.alexcrea.cuanvil.gui.config.global.EnchantConflictGui;

public class ConflictAPI {
    private static Object saveChangeTask = null;
    private static Object reloadChangeTask = null;

    private ConflictAPI() {
    }

    public static boolean addConflict(@NotNull ConflictBuilder builder) {
        return ConflictAPI.addConflict(builder, false);
    }

    public static boolean addConflict(@NotNull ConflictBuilder builder, boolean overrideDeleted) {
        FileConfiguration config = ConfigHolder.CONFLICT_HOLDER.getConfig();
        if (!overrideDeleted && ConfigHolder.CONFLICT_HOLDER.isDeleted(builder.getName())) {
            return false;
        }
        if (config.contains(builder.getName())) {
            return false;
        }
        if (!ConflictAPI.writeConflict(builder, false)) {
            return false;
        }
        EnchantConflictGroup conflict = builder.build();
        ConfigHolder.CONFLICT_HOLDER.getConflictManager().addConflict(conflict);
        EnchantConflictGui conflictGui = EnchantConflictGui.getCurrentInstance();
        if (conflictGui != null) {
            conflictGui.updateValueForGeneric(conflict, true);
        }
        return true;
    }

    public static boolean writeConflict(@NotNull ConflictBuilder builder) {
        return ConflictAPI.writeConflict(builder, true);
    }

    public static boolean writeConflict(@NotNull ConflictBuilder builder, boolean updatePlanned) {
        FileConfiguration config = ConfigHolder.CONFLICT_HOLDER.getConfig();
        String name = builder.getName();
        if (name.contains(".")) {
            CustomAnvil.instance.getLogger().warning("Conflict " + name + " contain \".\" in its name but should not. this conflict is ignored.");
            ConflictAPI.logConflictOrigin(builder);
            return false;
        }
        String basePath = name + ".";
        List<String> enchantments = ConflictAPI.extractEnchantments(builder);
        ArrayList<String> excludedGroups = new ArrayList<String>(builder.getExcludedGroupNames());
        if (!enchantments.isEmpty()) {
            config.set(basePath + "enchantments", enchantments);
        }
        if (!excludedGroups.isEmpty()) {
            config.set(basePath + "notAffectedGroups", excludedGroups);
        }
        if (builder.getMaxBeforeConflict() > 0) {
            config.set(basePath + "maxEnchantmentBeforeConflict", (Object)builder.getMaxBeforeConflict());
        }
        if (!config.isConfigurationSection(name)) {
            return false;
        }
        ConflictAPI.prepareSaveTask();
        if (updatePlanned) {
            ConflictAPI.prepareUpdateTask();
        }
        return true;
    }

    @NotNull
    private static List<String> extractEnchantments(@NotNull ConflictBuilder builder) {
        ArrayList<String> result = new ArrayList<String>(builder.getEnchantmentNames());
        for (NamespacedKey enchantmentKey : builder.getEnchantmentKeys()) {
            result.add(enchantmentKey.toString());
        }
        return result;
    }

    public static boolean removeConflict(@NotNull EnchantConflictGroup conflict) {
        ConfigHolder.CONFLICT_HOLDER.getConflictManager().removeConflict(conflict);
        ConfigHolder.CONFLICT_HOLDER.delete(conflict.getName());
        ConflictAPI.prepareSaveTask();
        EnchantConflictGui conflictGui = EnchantConflictGui.getCurrentInstance();
        if (conflictGui != null) {
            conflictGui.removeGeneric(conflict);
        }
        return true;
    }

    private static void prepareSaveTask() {
        if (saveChangeTask != null) {
            return;
        }
        saveChangeTask = DependencyManager.scheduler.scheduleGlobally((Plugin)CustomAnvil.instance, () -> {
            ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
            saveChangeTask = null;
        });
    }

    private static void prepareUpdateTask() {
        if (reloadChangeTask != null) {
            return;
        }
        reloadChangeTask = DependencyManager.scheduler.scheduleGlobally((Plugin)CustomAnvil.instance, () -> {
            ConfigHolder.CONFLICT_HOLDER.reload();
            EnchantConflictGui conflictGui = EnchantConflictGui.getCurrentInstance();
            if (conflictGui != null) {
                conflictGui.reloadValues();
            }
            reloadChangeTask = null;
        });
    }

    static void logConflictOrigin(@NotNull ConflictBuilder builder) {
        CustomAnvil.instance.getLogger().warning("Conflict " + builder.getName() + " came from " + builder.getSourceName() + ".");
    }

    @NotNull
    public static List<EnchantConflictGroup> getRegisteredConflict() {
        ArrayList<EnchantConflictGroup> mutableList = ConfigHolder.CONFLICT_HOLDER.getConflictManager().getConflictList();
        return Collections.unmodifiableList(mutableList);
    }
}

