/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.api;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.api.AnvilRecipeBuilder;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.gui.config.global.CustomRecipeConfigGui;
import xyz.alexcrea.cuanvil.recipe.AnvilCustomRecipe;

public class CustomAnvilRecipeApi {
    private static Object saveChangeTask = null;

    private CustomAnvilRecipeApi() {
    }

    public static boolean addRecipe(@NotNull AnvilRecipeBuilder builder) {
        return CustomAnvilRecipeApi.addRecipe(builder, false);
    }

    public static boolean addRecipe(@NotNull AnvilRecipeBuilder builder, boolean overrideDeleted) {
        FileConfiguration config = ConfigHolder.CUSTOM_RECIPE_HOLDER.getConfig();
        String name = builder.getName();
        if (!overrideDeleted && ConfigHolder.CUSTOM_RECIPE_HOLDER.isDeleted(builder.getName())) {
            return false;
        }
        if (config.contains(builder.getName())) {
            return false;
        }
        if (builder.getName().contains(".")) {
            CustomAnvil.instance.getLogger().warning("Custom anvil recipe " + name + " contain \".\" in its name but should not. this recipe is ignored.");
            return false;
        }
        AnvilCustomRecipe recipe = builder.build();
        if (recipe == null) {
            CustomAnvil.instance.getLogger().warning("Custom anvil recipe " + name + " could not be parsed.");
            if (builder.getLeftItem() == null) {
                CustomAnvil.instance.getLogger().warning("It look like left item of the recipe is null.");
            }
            if (builder.getResultItem() == null) {
                CustomAnvil.instance.getLogger().warning("It look like result item of the recipe is null.");
            }
            return false;
        }
        ConfigHolder.CUSTOM_RECIPE_HOLDER.getRecipeManager().cleanAddNew(recipe);
        recipe.saveToFile(false, false);
        CustomAnvilRecipeApi.prepareSaveTask();
        CustomRecipeConfigGui recipeConfigGui = CustomRecipeConfigGui.getCurrentInstance();
        if (recipeConfigGui != null) {
            recipeConfigGui.updateValueForGeneric(recipe, true);
        }
        return true;
    }

    public static boolean removeRecipe(@NotNull AnvilCustomRecipe recipe) {
        boolean result = ConfigHolder.CUSTOM_RECIPE_HOLDER.getRecipeManager().cleanRemove(recipe);
        if (!result) {
            return false;
        }
        ConfigHolder.CUSTOM_RECIPE_HOLDER.delete(recipe.getName());
        CustomAnvilRecipeApi.prepareSaveTask();
        CustomRecipeConfigGui recipeConfigGui = CustomRecipeConfigGui.getCurrentInstance();
        if (recipeConfigGui != null) {
            recipeConfigGui.removeGeneric(recipe);
        }
        return true;
    }

    private static void prepareSaveTask() {
        if (saveChangeTask != null) {
            return;
        }
        saveChangeTask = DependencyManager.scheduler.scheduleGlobally((Plugin)CustomAnvil.instance, () -> {
            ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
            saveChangeTask = null;
        });
    }

    @NotNull
    public static List<AnvilCustomRecipe> getRegisteredRecipes() {
        ArrayList<AnvilCustomRecipe> mutableList = ConfigHolder.CUSTOM_RECIPE_HOLDER.getRecipeManager().getRecipeList();
        return Collections.unmodifiableList(mutableList);
    }
}

