/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.dependency.datapack;

import io.delilaheve.CustomAnvil;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.api.ConflictBuilder;
import xyz.alexcrea.cuanvil.api.EnchantmentApi;
import xyz.alexcrea.cuanvil.api.MaterialGroupApi;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.dependency.datapack.DataPackTester;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.wrapped.CABukkitEnchantment;
import xyz.alexcrea.cuanvil.enchant.wrapped.CAIncompatibleAllEnchant;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;
import xyz.alexcrea.cuanvil.group.EnchantConflictManager;
import xyz.alexcrea.cuanvil.group.IncludeGroup;
import xyz.alexcrea.cuanvil.update.UpdateUtils;
import xyz.alexcrea.cuanvil.update.Version;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J&\u0010\u001d\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\bH\u0002J<\u0010!\u001a\u00020\u001c2\"\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0#j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a`$2\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lxyz/alexcrea/cuanvil/dependency/datapack/DataPackDependency;", "", "<init>", "()V", "START_DETECT_VERSION", "Lxyz/alexcrea/cuanvil/update/Version;", "LASTEST_VERSION", "", "", "enabledDatapacks", "", "getEnabledDatapacks", "()Ljava/util/List;", "handleDatapackConfigs", "", "handlePack", "pack", "handlePackInitialConfig", "configureDatapack", "handleItemGroups", "yml", "Lorg/bukkit/configuration/file/YamlConfiguration;", "addItemConflicts", "Lorg/bukkit/configuration/file/FileConfiguration;", "conflictList", "", "Lxyz/alexcrea/cuanvil/api/ConflictBuilder;", "addEnchantConflict", "", "createConflict", "ench", "other", "setEnchantAsAll", "joinGroup", "conflicts", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "group", "handleEnchantAllConflict", "writeDefaultByNamespace", "namespace", "CustomAnvil"})
@SourceDebugExtension(value={"SMAP\nDataPackDependency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataPackDependency.kt\nxyz/alexcrea/cuanvil/dependency/datapack/DataPackDependency\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,306:1\n381#2,7:307\n*S KotlinDebug\n*F\n+ 1 DataPackDependency.kt\nxyz/alexcrea/cuanvil/dependency/datapack/DataPackDependency\n*L\n242#1:307,7\n*E\n"})
public final class DataPackDependency {
    @NotNull
    public static final DataPackDependency INSTANCE = new DataPackDependency();
    @NotNull
    private static final Version START_DETECT_VERSION = new Version(1, 19, 0);
    @NotNull
    private static final Map<String, Version> LASTEST_VERSION;

    private DataPackDependency() {
    }

    @NotNull
    public final List<String> getEnabledDatapacks() {
        Version version = UpdateUtils.currentMinecraftVersion();
        Intrinsics.checkNotNullExpressionValue(version, "currentMinecraftVersion(...)");
        Version version2 = version;
        if (version2.lesserThan(START_DETECT_VERSION)) {
            return CollectionsKt.emptyList();
        }
        return DataPackTester.INSTANCE.getEnabledPacks();
    }

    public final void handleDatapackConfigs() {
        List<String> enabledDatapack = this.getEnabledDatapacks();
        for (String packName : enabledDatapack) {
            if (!StringsKt.startsWith$default(packName, "file/", false, 2, null)) continue;
            if (StringsKt.contains((CharSequence)packName, "bp_post_scarcity", true) || StringsKt.contains((CharSequence)packName, "bracken", true)) {
                this.handlePack("bracken");
                continue;
            }
            if (StringsKt.contains((CharSequence)packName, "neoenchant", true)) {
                this.handlePack("enchantplus");
                continue;
            }
            if (!StringsKt.contains((CharSequence)packName, "Dungeons and Taverns", true)) continue;
            this.handlePack("dungeons_and_taverns");
        }
    }

    private final void handlePack(String pack) {
        CustomAnvil.Companion.getInstance().getLogger().info("trying to handle datapack " + pack);
        this.handlePackInitialConfig(pack);
        this.writeDefaultByNamespace(pack);
        CustomAnvil.Companion.getInstance().getLogger().info("configuration done for " + pack);
    }

    private final void handlePackInitialConfig(String pack) {
        ConfigHolder.DefaultConfigHolder defConfig = ConfigHolder.DEFAULT_CONFIG;
        Version version = LASTEST_VERSION.get(pack);
        if (version == null) {
            throw new RuntimeException("The pack " + pack + " has no latest version hard coded in the plugin");
        }
        Version currentVersion = Version.fromString(defConfig.getConfig().getString("datapack." + pack));
        if (currentVersion.greaterEqual(version)) {
            this.handleEnchantAllConflict(pack);
            return;
        }
        this.configureDatapack(pack);
        defConfig.getConfig().set("datapack." + pack, (Object)version.toString());
        defConfig.saveToDisk(true);
    }

    private final void configureDatapack(String pack) {
        YamlConfiguration yml;
        InputStreamReader reader;
        URL itemGroups = this.getClass().getResource("/datapack/" + pack + "/item_groups.yml");
        URL itemConflict = this.getClass().getResource("/datapack/" + pack + "/item_conflict.yml");
        URL enchantConflict = this.getClass().getResource("/datapack/" + pack + "/enchant_conflict.yml");
        if (itemGroups != null) {
            InputStreamReader reader2 = new InputStreamReader(itemGroups.openStream());
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader2);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            YamlConfiguration yml2 = yamlConfiguration;
            this.handleItemGroups(yml2);
        }
        ArrayList newConflictList = new ArrayList();
        boolean needSave = false;
        if (itemConflict != null) {
            reader = new InputStreamReader(itemConflict.openStream());
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            yml = yamlConfiguration;
            this.addItemConflicts((FileConfiguration)yml, newConflictList);
        }
        if (enchantConflict != null) {
            reader = new InputStreamReader(enchantConflict.openStream());
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            yml = yamlConfiguration;
            needSave = this.addEnchantConflict(yml, newConflictList);
        }
        Iterator iterator2 = newConflictList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            ConflictBuilder conflict = (ConflictBuilder)e;
            needSave = !conflict.registerIfAbsent() && needSave;
        }
        if (needSave) {
            ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
        }
    }

    private final void handleItemGroups(YamlConfiguration yml) {
        for (String groupName : yml.getKeys(false)) {
            ConfigurationSection section;
            boolean exist;
            if (yml.getConfigurationSection(groupName) == null) continue;
            AbstractMaterialGroup group = MaterialGroupApi.getGroup(groupName);
            boolean bl = exist = group != null;
            if (group == null) {
                Intrinsics.checkNotNull(groupName);
                group = new IncludeGroup(groupName);
            }
            for (String name : section.getStringList("items")) {
                Intrinsics.checkNotNull(name);
                String string = name.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                Material mat = Material.getMaterial((String)string);
                if (mat == null) {
                    CustomAnvil.Companion.getInstance().getLogger().warning("Could not find material " + name + " for item group " + groupName);
                    continue;
                }
                group.addToPolicy(mat);
            }
            for (String name : section.getStringList("groups")) {
                AbstractMaterialGroup otherGroup = MaterialGroupApi.getGroup(name);
                if (otherGroup == null) {
                    CustomAnvil.Companion.getInstance().getLogger().warning("Could not find sub group " + name + " for group " + groupName);
                    continue;
                }
                group.addToPolicy(otherGroup);
            }
            group.updateMaterials();
            boolean bl2 = exist ? MaterialGroupApi.writeMaterialGroup(group) : MaterialGroupApi.addMaterialGroup(group, true);
        }
    }

    private final void addItemConflicts(FileConfiguration yml, List<ConflictBuilder> conflictList) {
        for (String ench : yml.getKeys(false)) {
            List groups2;
            Intrinsics.checkNotNullExpressionValue(yml.getStringList(ench), "getStringList(...)");
            Intrinsics.checkNotNull(ench);
            ConflictBuilder conflict = new ConflictBuilder("restriction_" + StringsKt.replace$default(ench, ":", "_", false, 4, null), (Plugin)CustomAnvil.Companion.getInstance());
            NamespacedKey namespacedKey = NamespacedKey.fromString((String)ench);
            Intrinsics.checkNotNull(namespacedKey);
            conflict.addEnchantment(namespacedKey);
            for (String group : groups2) {
                conflict.addExcludedGroup(group);
            }
            conflict.addExcludedGroup("enchanted_book");
            conflictList.add(conflict);
        }
    }

    private final boolean addEnchantConflict(YamlConfiguration yml, List<ConflictBuilder> conflictList) {
        boolean needSave = false;
        HashMap<String, ConflictBuilder> conflicts = new HashMap<String, ConflictBuilder>();
        for (String ench : yml.getKeys(false)) {
            List groups2;
            Intrinsics.checkNotNullExpressionValue(yml.getStringList(ench), "getStringList(...)");
            for (String group : groups2) {
                Intrinsics.checkNotNull(group);
                if (StringsKt.startsWith$default((CharSequence)group, '#', false, 2, null)) {
                    String string = group.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    Intrinsics.checkNotNull(ench);
                    needSave = this.joinGroup(conflicts, string, ench) || needSave;
                    continue;
                }
                Intrinsics.checkNotNull(ench);
                this.createConflict(conflictList, ench, group);
            }
        }
        Collection collection = conflicts.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        conflictList.addAll(collection);
        return needSave;
    }

    private final void createConflict(List<ConflictBuilder> conflictList, String ench, String other) {
        ConflictBuilder conflict = new ConflictBuilder("conflict_" + StringsKt.replace$default(ench, ":", "_", false, 4, null) + "_" + StringsKt.replace$default(other, ":", "_", false, 4, null), (Plugin)CustomAnvil.Companion.getInstance());
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)ench);
        Intrinsics.checkNotNull(namespacedKey);
        conflict.addEnchantment(namespacedKey);
        NamespacedKey namespacedKey2 = NamespacedKey.fromString((String)other);
        Intrinsics.checkNotNull(namespacedKey2);
        conflict.addEnchantment(namespacedKey2);
        conflict.setMaxBeforeConflict(1);
        conflictList.add(conflict);
    }

    private final void setEnchantAsAll(String ench) {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)ench);
        Intrinsics.checkNotNull(namespacedKey);
        CAEnchantment cAEnchantment = EnchantmentApi.getByKey(namespacedKey);
        Intrinsics.checkNotNull(cAEnchantment, "null cannot be cast to non-null type xyz.alexcrea.cuanvil.enchant.wrapped.CABukkitEnchantment");
        CABukkitEnchantment current = (CABukkitEnchantment)cAEnchantment;
        EnchantmentApi.unregisterEnchantment(current);
        EnchantmentApi.registerEnchantment(new CAIncompatibleAllEnchant(current.bukkit, current.defaultRarity()));
    }

    private final boolean joinGroup(HashMap<String, ConflictBuilder> conflicts, String group, String ench) {
        Object v2;
        FileConfiguration config;
        block7: {
            if (StringsKt.equals("all", group, true)) {
                this.setEnchantAsAll(ench);
                return false;
            }
            config = ConfigHolder.CONFLICT_HOLDER.getConfig();
            if (!config.isConfigurationSection(group)) {
                Object object;
                Map $this$getOrPut$iv = conflicts;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(group);
                if (value$iv == null) {
                    boolean bl = false;
                    ConflictBuilder conflict = new ConflictBuilder(group, (Plugin)CustomAnvil.Companion.getInstance());
                    conflict.setMaxBeforeConflict(1);
                    ConflictBuilder answer$iv = conflict;
                    $this$getOrPut$iv.put(group, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ConflictBuilder conflict = (ConflictBuilder)object;
                NamespacedKey namespacedKey = NamespacedKey.fromString((String)ench);
                Intrinsics.checkNotNull(namespacedKey);
                conflict.addEnchantment(namespacedKey);
                return false;
            }
            EnchantConflictManager manager = ConfigHolder.CONFLICT_HOLDER.getConflictManager();
            Iterable value$iv = manager.getConflictList();
            for (Object t : value$iv) {
                EnchantConflictGroup it = (EnchantConflictGroup)t;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), group, true)) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        EnchantConflictGroup conflict = v2;
        if (conflict == null) {
            CustomAnvil.Companion.getInstance().getLogger().severe("Could not find  " + group + " while its configuration section exist... this should NOT happen");
            return false;
        }
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)ench);
        Intrinsics.checkNotNull(namespacedKey);
        NamespacedKey key = namespacedKey;
        CAEnchantment enchant = EnchantmentApi.getByKey(key);
        if (enchant == null) {
            CustomAnvil.Companion.getInstance().getLogger().severe("Could not find enchantment " + ench + " while configuring pack a datapack");
            return false;
        }
        conflict.addEnchantment(enchant);
        String[] stringArray = new String[]{ench};
        UpdateUtils.addAbsentToList(config, group + ".enchantments", stringArray);
        return true;
    }

    private final void handleEnchantAllConflict(String pack) {
        URL uRL = this.getClass().getResource("/datapack/" + pack + "/enchant_conflict.yml");
        if (uRL == null) {
            return;
        }
        URL enchantConflict = uRL;
        InputStreamReader reader = new InputStreamReader(enchantConflict.openStream());
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration yml = yamlConfiguration;
        for (String ench : yml.getKeys(false)) {
            List groups2;
            Intrinsics.checkNotNullExpressionValue(yml.getStringList(ench), "getStringList(...)");
            if (!groups2.contains("#all")) continue;
            Intrinsics.checkNotNull(ench);
            this.setEnchantAsAll(ench);
        }
    }

    private final void writeDefaultByNamespace(String namespace) {
        for (CAEnchantment enchantment : EnchantmentApi.getRegisteredEnchantments().values()) {
            if (!StringsKt.equals(enchantment.getKey().getNamespace(), namespace, true)) continue;
            CustomAnvil.Companion.log("Writing default for " + enchantment.getKey());
            EnchantmentApi.writeDefaultConfig(enchantment, false);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair<String, Version>("bracken", new Version(1, 11, 0)), new Pair<String, Version>("enchantplus", new Version(1, 13, 0)), new Pair<String, Version>("dungeons_and_taverns", new Version(1, 13, 0))};
        LASTEST_VERSION = MapsKt.mapOf(pairArray);
    }
}

