/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.dependency.plugins;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.EcoEnchants;
import com.willfp.ecoenchants.mechanics.AnvilSupportKt;
import io.delilaheve.CustomAnvil;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.api.EnchantmentApi;
import xyz.alexcrea.cuanvil.dependency.plugins.LegacyEcoEnchantDependency;
import xyz.alexcrea.cuanvil.enchant.wrapped.CAEcoEnchant;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lxyz/alexcrea/cuanvil/dependency/plugins/EcoEnchantDependency;", "", "ecoEnchantPlugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "isLegacy", "", "legacyDependency", "Lxyz/alexcrea/cuanvil/dependency/plugins/LegacyEcoEnchantDependency;", "getEcoLevelLimit", "", "disableAnvilListener", "", "ecoEnchantOldEnchantments", "", "Lcom/willfp/ecoenchants/enchant/EcoEnchant;", "registerEnchantments", "handleConfigReload", "CustomAnvil"})
public final class EcoEnchantDependency {
    @NotNull
    private final Plugin ecoEnchantPlugin;
    private final boolean isLegacy;
    @Nullable
    private final LegacyEcoEnchantDependency legacyDependency;
    @Nullable
    private Set<EcoEnchant> ecoEnchantOldEnchantments;

    public EcoEnchantDependency(@NotNull Plugin ecoEnchantPlugin) {
        Intrinsics.checkNotNullParameter(ecoEnchantPlugin, "ecoEnchantPlugin");
        this.ecoEnchantPlugin = ecoEnchantPlugin;
        CustomAnvil.Companion.getInstance().getLogger().info("Eco Enchant Detected !");
        boolean isLegacy = true;
        try {
            Class.forName("com.willfp.ecoenchants.enchant.EcoEnchants");
            isLegacy = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.isLegacy = isLegacy;
        this.legacyDependency = isLegacy ? new LegacyEcoEnchantDependency() : null;
    }

    public final int getEcoLevelLimit() {
        Plugin plugin = this.ecoEnchantPlugin;
        Intrinsics.checkNotNull(plugin, "null cannot be cast to non-null type com.willfp.eco.core.EcoPlugin");
        return AnvilSupportKt.infiniteIfNegative((int)((EcoPlugin)plugin).getConfigYml().getInt("anvil.enchant-limit"));
    }

    public final void disableAnvilListener() {
        PrepareAnvilEvent.getHandlerList().unregister(this.ecoEnchantPlugin);
    }

    public final void registerEnchantments() {
        CustomAnvil.Companion.getInstance().getLogger().info("Preparing Eco Enchant compatibility...");
        if (this.isLegacy) {
            LegacyEcoEnchantDependency legacyEcoEnchantDependency = this.legacyDependency;
            Intrinsics.checkNotNull(legacyEcoEnchantDependency);
            legacyEcoEnchantDependency.registerEnchantments();
            return;
        }
        Set enchantments = EcoEnchants.INSTANCE.values();
        for (EcoEnchant ecoEnchant : enchantments) {
            EnchantmentApi.unregisterEnchantment(ecoEnchant.getEnchantment());
            EnchantmentApi.registerEnchantment(new CAEcoEnchant(ecoEnchant));
        }
        this.ecoEnchantOldEnchantments = new HashSet(enchantments);
        CustomAnvil.Companion.getInstance().getLogger().info("Eco Enchant should now work as expected !");
    }

    public final void handleConfigReload() {
        if (this.isLegacy) {
            LegacyEcoEnchantDependency legacyEcoEnchantDependency = this.legacyDependency;
            Intrinsics.checkNotNull(legacyEcoEnchantDependency);
            legacyEcoEnchantDependency.handleConfigReload();
            return;
        }
        if (this.ecoEnchantOldEnchantments == null) {
            return;
        }
        Set newEnchantments = EcoEnchants.INSTANCE.values();
        for (EcoEnchant ecoEnchant : newEnchantments) {
            Set<EcoEnchant> set = this.ecoEnchantOldEnchantments;
            Intrinsics.checkNotNull(set);
            if (set.contains(ecoEnchant)) continue;
            EnchantmentApi.registerEnchantment(new CAEcoEnchant(ecoEnchant));
        }
        Set<EcoEnchant> set = this.ecoEnchantOldEnchantments;
        Intrinsics.checkNotNull(set);
        set.removeAll(newEnchantments);
        Set<EcoEnchant> set2 = this.ecoEnchantOldEnchantments;
        Intrinsics.checkNotNull(set2);
        for (EcoEnchant oldEnchantment : set2) {
            EnchantmentApi.unregisterEnchantment(oldEnchantment.getEnchantment());
        }
        this.ecoEnchantOldEnchantments = new HashSet(newEnchantments);
    }
}

