/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.dependency.plugins;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;
import valorless.havenbags.HavenBags;
import valorless.havenbags.features.BagSkin;
import valorless.havenbags.features.BagUpgrade;
import xyz.alexcrea.cuanvil.util.AnvilXpUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/alexcrea/cuanvil/dependency/plugins/HavenBagsDependency;", "", "<init>", "()V", "bagUpgrade", "Lvalorless/havenbags/features/BagUpgrade;", "bagSkin", "Lvalorless/havenbags/features/BagSkin;", "redirectListeners", "", "testPrepareAnvil", "", "event", "Lorg/bukkit/event/inventory/PrepareAnvilEvent;", "player", "Lorg/bukkit/entity/HumanEntity;", "testAnvilResult", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "inventory", "Lorg/bukkit/inventory/AnvilInventory;", "CustomAnvil"})
public final class HavenBagsDependency {
    private BagUpgrade bagUpgrade;
    private BagSkin bagSkin;

    public HavenBagsDependency() {
        CustomAnvil.Companion.getInstance().getLogger().info("Heaven Bags Detected !");
    }

    public final void redirectListeners() {
        ArrayList<RegisteredListener> toUnregister = new ArrayList<RegisteredListener>();
        for (RegisteredListener registeredListener : PrepareAnvilEvent.getHandlerList().getRegisteredListeners()) {
            Listener listener;
            Intrinsics.checkNotNullExpressionValue(registeredListener.getListener(), "getListener(...)");
            if (listener instanceof BagUpgrade) {
                this.bagUpgrade = (BagUpgrade)listener;
                toUnregister.add(registeredListener);
            }
            if (!(listener instanceof BagSkin)) continue;
            this.bagSkin = (BagSkin)listener;
            toUnregister.add(registeredListener);
        }
        Iterator iterator2 = toUnregister.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            RegisteredListener listener = (RegisteredListener)e;
            PrepareAnvilEvent.getHandlerList().unregister(listener);
            InventoryClickEvent.getHandlerList().unregister(listener);
        }
    }

    public final boolean testPrepareAnvil(@NotNull PrepareAnvilEvent event, @NotNull HumanEntity player) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(player, "player");
        ItemStack previousResult = event.getResult();
        event.setResult(null);
        BagSkin bagSkin = this.bagSkin;
        if (bagSkin == null) {
            Intrinsics.throwUninitializedPropertyAccessException("bagSkin");
            bagSkin = null;
        }
        bagSkin.onPrepareAnvil(event);
        if (event.getResult() != null) {
            CustomAnvil.Companion.log("Detected pre anvil heaven bag anvil skin.");
            AnvilInventory anvilInventory = event.getInventory();
            Intrinsics.checkNotNullExpressionValue(anvilInventory, "getInventory(...)");
            InventoryView inventoryView = event.getView();
            Intrinsics.checkNotNullExpressionValue(inventoryView, "getView(...)");
            AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, anvilInventory, inventoryView, player, event.getInventory().getRepairCost(), false, 16, null);
            return true;
        }
        BagUpgrade bagUpgrade = this.bagUpgrade;
        if (bagUpgrade == null) {
            Intrinsics.throwUninitializedPropertyAccessException("bagUpgrade");
            bagUpgrade = null;
        }
        bagUpgrade.onPrepareAnvil(event);
        if (event.getResult() != null) {
            CustomAnvil.Companion.log("Detected pre anvil heaven bag anvil upgrade.");
            AnvilInventory anvilInventory = event.getInventory();
            Intrinsics.checkNotNullExpressionValue(anvilInventory, "getInventory(...)");
            InventoryView inventoryView = event.getView();
            Intrinsics.checkNotNullExpressionValue(inventoryView, "getView(...)");
            AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, anvilInventory, inventoryView, player, event.getInventory().getRepairCost(), false, 16, null);
            return true;
        }
        event.setResult(previousResult);
        return false;
    }

    public final boolean testAnvilResult(@NotNull InventoryClickEvent event, @NotNull AnvilInventory inventory) {
        ItemStack result;
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        ItemStack itemStack = inventory.getItem(2);
        Object object = result = itemStack != null ? itemStack.clone() : null;
        if (HavenBags.IsBag((ItemStack)result).booleanValue()) {
            CustomAnvil.Companion.log("Detected anvil click haven bag bypass.");
            BagUpgrade bagUpgrade = this.bagUpgrade;
            if (bagUpgrade == null) {
                Intrinsics.throwUninitializedPropertyAccessException("bagUpgrade");
                bagUpgrade = null;
            }
            bagUpgrade.onInventoryClick(event);
            BagSkin bagSkin = this.bagSkin;
            if (bagSkin == null) {
                Intrinsics.throwUninitializedPropertyAccessException("bagSkin");
                bagSkin = null;
            }
            bagSkin.onInventoryClick(event);
            return true;
        }
        return false;
    }
}

