/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.list;

import io.delilaheve.CustomAnvil;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.config.list.MappedElementListConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.elements.ElementMappedToListGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.cuanvil.util.LazyValue;
import xyz.alexcrea.inventoryframework.gui.GuiItem;

public abstract class MappedGuiListConfigGui<T, S extends LazyElement<?>>
extends MappedElementListConfigGui<T, S> {
    protected MappedGuiListConfigGui(@NotNull String title) {
        super(title);
    }

    @Override
    public void reloadValues() {
        this.elementGuiMap.forEach((conflict, element) -> {
            ElementMappedToListGui gui = (ElementMappedToListGui)element.getStored();
            if (gui != null) {
                gui.cleanAndBeUnusable();
            }
        });
        this.elementGuiMap.clear();
        super.reloadValues();
    }

    @Override
    protected S newElementRequested(T generic, GuiItem newItem) {
        S element = this.newInstanceOfGui(generic, newItem);
        newItem.setAction(((LazyElement)element).openAction());
        return element;
    }

    @Override
    protected GuiItem findItemFromElement(T generic, S element) {
        return ((LazyElement)element).getParentItem();
    }

    @Override
    protected void updateElement(T generic, S element) {
        ElementMappedToListGui gui = (ElementMappedToListGui)((LazyValue)element).getStored();
        if (gui != null) {
            gui.updateLocal();
        }
    }

    @Override
    protected GuiItem findGuiItemForRemoval(T generic, S element) {
        return ((LazyElement)element).getParentItem();
    }

    @Override
    protected Consumer<String> prepareCreateItemConsumer(HumanEntity player) {
        AtomicReference<Consumer<String>> selfRef = new AtomicReference<Consumer<String>>();
        Consumer<String> selfCallback = message -> {
            if (message == null) {
                return;
            }
            if (!player.hasPermission("ca.config.edit")) {
                player.sendMessage("\u00a7cYou do not have permission to edit the config");
                return;
            }
            if ("cancel".equalsIgnoreCase(message = message.toLowerCase(Locale.ROOT))) {
                player.sendMessage(this.genericDisplayedName() + " creation cancelled...");
                this.show(player);
                return;
            }
            message = message.replace(' ', '_');
            for (Object generic : this.getEveryDisplayableInstanceOfGeneric()) {
                if (!generic.toString().equalsIgnoreCase((String)message)) continue;
                player.sendMessage("\u00a7cPlease enter a " + this.genericDisplayedName() + " name that do not already exist...");
                CustomAnvil.Companion.getChatListener().setListenedCallback(player, (Consumer<String>)((Consumer)selfRef.get()));
                return;
            }
            T generic = this.createAndSaveNewEmptyGeneric((String)message);
            if (generic == null) {
                this.show(player);
                return;
            }
            this.updateValueForGeneric(generic, true);
            ((ElementMappedToListGui)((LazyElement)this.elementGuiMap.get(generic)).get()).getMappedGui().show(player);
            this.update();
        };
        selfRef.set(selfCallback);
        return selfCallback;
    }

    protected abstract S newInstanceOfGui(T var1, GuiItem var2);

    @Override
    protected abstract String genericDisplayedName();

    protected abstract T createAndSaveNewEmptyGeneric(String var1);

    public static class LazyElement<T extends ElementMappedToListGui>
    extends LazyValue<T> {
        private final GuiItem parentItem;
        private final LazyValue<Consumer<InventoryClickEvent>> lazyOpenConsumer;

        public LazyElement(GuiItem parentItem, Supplier<T> valueSupplier) {
            super(valueSupplier);
            this.parentItem = parentItem;
            this.lazyOpenConsumer = new LazyValue<Consumer>(() -> GuiGlobalActions.openGuiAction(((ElementMappedToListGui)this.get()).getMappedGui()));
        }

        public GuiItem getParentItem() {
            return this.parentItem;
        }

        @NotNull
        public Consumer<InventoryClickEvent> openAction() {
            return event -> this.lazyOpenConsumer.get().accept((InventoryClickEvent)event);
        }
    }
}

