/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.list.elements;

import io.delilaheve.CustomAnvil;
import java.util.Collections;
import java.util.function.Supplier;
import kotlin.ranges.IntRange;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.config.ask.ConfirmActionGui;
import xyz.alexcrea.cuanvil.gui.config.global.CustomRecipeConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.elements.MappedToListSubSettingGui;
import xyz.alexcrea.cuanvil.gui.config.settings.BoolSettingsGui;
import xyz.alexcrea.cuanvil.gui.config.settings.IntSettingsGui;
import xyz.alexcrea.cuanvil.gui.config.settings.ItemSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.recipe.AnvilCustomRecipe;
import xyz.alexcrea.cuanvil.recipe.CustomAnvilRecipeManager;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class CustomRecipeSubSettingGui
extends MappedToListSubSettingGui {
    private final CustomRecipeConfigGui parent;
    private final AnvilCustomRecipe anvilRecipe;
    private final PatternPane pane;
    private boolean shouldWork = true;
    private BoolSettingsGui.BoolSettingFactory exactCountFactory;
    private BoolSettingsGui.BoolSettingFactory removeExactLinearXpFactory;
    private GuiItem noRemoveExactLinearXp;
    private IntSettingsGui.IntSettingFactory levelCostFactory;
    private IntSettingsGui.IntSettingFactory linearXpCostFactory;
    private ItemSettingGui.ItemSettingFactory leftItemFactory;
    private ItemSettingGui.ItemSettingFactory rightItemFactory;
    private ItemSettingGui.ItemSettingFactory resultItemFactory;

    public CustomRecipeSubSettingGui(@NotNull CustomRecipeConfigGui parent, @NotNull AnvilCustomRecipe anvilRecipe) {
        super(4, "\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(anvilRecipe.toString()) + " \u00a78Config");
        this.parent = parent;
        this.anvilRecipe = anvilRecipe;
        Pattern pattern = new Pattern("000000000", "01203450D", "0ab000000", "B00000000");
        this.pane = new PatternPane(0, 0, 9, 4, pattern);
        this.addPane(this.pane);
        this.prepareStaticValues();
    }

    private void prepareStaticValues() {
        GuiGlobalItems.addBackItem(this.pane, this.parent);
        GuiGlobalItems.addBackgroundItem(this.pane);
        ItemStack deleteItem = new ItemStack(Material.RED_TERRACOTTA);
        ItemMeta deleteMeta = deleteItem.getItemMeta();
        assert (deleteMeta != null);
        deleteMeta.setDisplayName("\u00a74DELETE RECIPE");
        deleteMeta.setLore(Collections.singletonList("\u00a7cCaution with this button !"));
        deleteItem.setItemMeta(deleteMeta);
        this.pane.bindItem('D', new GuiItem(deleteItem, GuiGlobalActions.openGuiAction(this.createDeleteGui()), (Plugin)CustomAnvil.instance));
        IntRange costRange = AnvilCustomRecipe.Companion.getXP_COST_CONFIG_RANGE();
        this.exactCountFactory = new BoolSettingsGui.BoolSettingFactory("\u00a78Exact count ?", this, ConfigHolder.CUSTOM_RECIPE_HOLDER, String.valueOf(this.anvilRecipe) + ".exact_count", true, new String[0]);
        this.removeExactLinearXpFactory = new BoolSettingsGui.BoolSettingFactory("\u00a78Remove exact linear xp ?", this, ConfigHolder.CUSTOM_RECIPE_HOLDER, String.valueOf(this.anvilRecipe) + ".remove_exact_linear_xp", false, new String[0]);
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7cRemove exact linear xp ?");
        meta.setLore(Collections.singletonList("\u00a77Not usable if linear cost is 0"));
        item.setItemMeta(meta);
        this.noRemoveExactLinearXp = new GuiItem(item, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
        this.levelCostFactory = new IntSettingsGui.IntSettingFactory("\u00a78Recipe Level Cost", this, String.valueOf(this.anvilRecipe) + ".xp_cost", ConfigHolder.CUSTOM_RECIPE_HOLDER, null, costRange.getFirst(), costRange.getLast(), 1, 1, 5, 10);
        this.linearXpCostFactory = new IntSettingsGui.IntSettingFactory("\u00a78Recipe Linear Xp Cost", this, String.valueOf(this.anvilRecipe) + ".linear_xp_cost", ConfigHolder.CUSTOM_RECIPE_HOLDER, null, 0, Integer.MAX_VALUE, 0, 1, 10, 100, 1000, 10000);
        this.leftItemFactory = new ItemSettingGui.ItemSettingFactory("\u00a7eRecipe Left \u00a78Item", this, String.valueOf(this.anvilRecipe) + ".left_item", ConfigHolder.CUSTOM_RECIPE_HOLDER, AnvilCustomRecipe.Companion.getDEFAULT_LEFT_ITEM_CONFIG(), "\u00a77Set the left item of the custom craft", "\u00a77\u25a0 + \u25a1 = \u25a1");
        this.rightItemFactory = new ItemSettingGui.ItemSettingFactory("\u00a7eRecipe Right \u00a78Item", this, String.valueOf(this.anvilRecipe) + ".right_item", ConfigHolder.CUSTOM_RECIPE_HOLDER, AnvilCustomRecipe.Companion.getDEFAULT_RIGHT_ITEM_CONFIG(), "\u00a77Set the right item of the custom craft", "\u00a77\u25a1 + \u25a0 = \u25a1");
        this.resultItemFactory = new ItemSettingGui.ItemSettingFactory("\u00a7aRecipe Result \u00a78Item", this, String.valueOf(this.anvilRecipe) + ".result_item", ConfigHolder.CUSTOM_RECIPE_HOLDER, AnvilCustomRecipe.Companion.getDEFAULT_RESULT_ITEM_CONFIG(), "\u00a77Set the result item of the custom craft", "\u00a77\u25a1 + \u25a1 = \u25a0");
        this.updateLocal();
    }

    private ConfirmActionGui createDeleteGui() {
        Supplier<Boolean> deleteSupplier = () -> {
            CustomAnvilRecipeManager manager = ConfigHolder.CUSTOM_RECIPE_HOLDER.getRecipeManager();
            manager.cleanRemove(this.anvilRecipe);
            this.parent.removeGeneric(this.anvilRecipe);
            this.cleanAndBeUnusable();
            ConfigHolder.CUSTOM_RECIPE_HOLDER.delete(this.anvilRecipe.toString());
            boolean success = true;
            success = ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
            return success;
        };
        return new ConfirmActionGui("\u00a7cDelete \u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(this.anvilRecipe.toString()) + "\u00a7c?", "\u00a77Confirm that you want to delete this conflict.", this, this.parent, deleteSupplier);
    }

    @Override
    public void updateGuiValues() {
        this.anvilRecipe.updateFromFile();
        this.parent.updateValueForGeneric(this.anvilRecipe, true);
    }

    @Override
    public void updateLocal() {
        if (!this.shouldWork) {
            return;
        }
        GuiItem exactCountItem = this.exactCountFactory.getItem();
        this.pane.bindItem('1', exactCountItem);
        if (this.anvilRecipe.getXpCostPerCraft() == 0) {
            this.pane.bindItem('a', this.noRemoveExactLinearXp);
        } else {
            this.pane.bindItem('a', this.removeExactLinearXpFactory.getItem());
        }
        GuiItem levelCostItem = this.levelCostFactory.getItem(Material.EXPERIENCE_BOTTLE);
        this.pane.bindItem('2', levelCostItem);
        GuiItem xpCostItem = this.linearXpCostFactory.getItem(Material.EXPERIENCE_BOTTLE);
        this.pane.bindItem('b', xpCostItem);
        GuiItem leftGuiItem = this.leftItemFactory.getItem();
        this.pane.bindItem('3', leftGuiItem);
        GuiItem rightGuiItem = this.rightItemFactory.getItem();
        this.pane.bindItem('4', rightGuiItem);
        GuiItem resultGuiItem = this.resultItemFactory.getItem();
        this.pane.bindItem('5', resultGuiItem);
        this.update();
    }

    @Override
    public void cleanAndBeUnusable() {
        for (HumanEntity viewer : this.getViewers()) {
            this.parent.show(viewer);
        }
        this.shouldWork = false;
        GuiItem background = GuiGlobalItems.backgroundItem();
        this.pane.bindItem('1', background);
        this.pane.bindItem('2', background);
        this.pane.bindItem('3', background);
        this.pane.bindItem('4', background);
        this.pane.bindItem('5', background);
        this.pane.bindItem('D', background);
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (this.shouldWork) {
            super.show(humanEntity);
        } else {
            this.parent.show(humanEntity);
        }
    }
}

