/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.SettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.inventoryframework.adventuresupport.StringHolder;
import xyz.alexcrea.inventoryframework.adventuresupport.TextHolder;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.ChestGui;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public abstract class AbstractSettingGui
extends ChestGui
implements SettingGui {
    public static final String CLICK_LORE = "\u00a77Click Here to change the value";
    private PatternPane pane;
    protected GuiItem saveItem;

    protected AbstractSettingGui(int rows, @NotNull TextHolder title, ValueUpdatableGui parent) {
        super(rows, title, (Plugin)CustomAnvil.instance);
        this.initBase(parent);
    }

    protected AbstractSettingGui(int rows, @NotNull String title, ValueUpdatableGui parent) {
        this(rows, (TextHolder)StringHolder.of(title), parent);
    }

    protected void initBase(ValueUpdatableGui parent) {
        Pattern pattern = this.getGuiPattern();
        this.pane = new PatternPane(0, 0, pattern.getLength(), pattern.getHeight(), pattern);
        this.addPane(this.pane);
        GuiGlobalItems.addBackItem(this.pane, parent.getConnectedGui());
        GuiGlobalItems.addBackgroundItem(this.pane);
        this.saveItem = GuiGlobalItems.saveItem(this, parent);
        this.pane.bindItem('S', GuiGlobalItems.noChangeItem());
    }

    @Override
    public void update() {
        this.pane.bindItem('S', this.hadChange() ? this.saveItem : GuiGlobalItems.noChangeItem());
        super.update();
    }

    protected PatternPane getPane() {
        return this.pane;
    }

    protected abstract Pattern getGuiPattern();

    public static abstract class SettingGuiFactory
    implements SettingGui.SettingGuiFactory {
        @NotNull
        protected String configPath;
        @NotNull
        protected ConfigHolder config;

        protected SettingGuiFactory(@NotNull String configPath, @NotNull ConfigHolder config) {
            this.configPath = configPath;
            this.config = config;
        }

        @NotNull
        public String getConfigPath() {
            return this.configPath;
        }

        @NotNull
        public ConfigHolder getConfigHolder() {
            return this.config;
        }
    }
}

