/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.AbstractSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class IntSettingsGui
extends AbstractSettingGui {
    protected final IntSettingFactory holder;
    protected final int before;
    protected int now;
    protected int step;
    protected GuiItem returnToDefault;

    protected IntSettingsGui(IntSettingFactory holder, int now) {
        super(3, holder.getTitle(), holder.parent);
        assert (holder.steps.length > 0 && holder.steps.length <= 9);
        this.holder = holder;
        this.before = now;
        this.now = now;
        this.step = holder.steps[0];
        this.initStepsValue();
        this.prepareReturnToDefault();
        this.updateValueDisplay();
    }

    @Override
    public Pattern getGuiPattern() {
        return new Pattern("abcdefghi", "D0-0v0+00", "B0000000S");
    }

    protected void prepareReturnToDefault() {
        ItemStack item = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7eReset to default value");
        meta.setLore(Collections.singletonList("\u00a77Default value is \u00a7e" + this.holder.defaultVal));
        item.setItemMeta(meta);
        this.returnToDefault = new GuiItem(item, event -> {
            event.setCancelled(true);
            this.now = this.holder.defaultVal;
            this.updateValueDisplay();
            this.update();
        }, (Plugin)CustomAnvil.instance);
    }

    protected void updateValueDisplay() {
        GuiItem plusItem;
        GuiItem minusItem;
        PatternPane pane = this.getPane();
        if (this.now > this.holder.min) {
            int planned = Math.max(this.holder.min, this.now - this.step);
            ItemStack item = new ItemStack(Material.RED_TERRACOTTA);
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            meta.setDisplayName("\u00a7e" + this.now + " \u00a7f-> \u00a7e" + planned + " \u00a7r(\u00a7c-" + (this.now - planned) + "\u00a7r)");
            meta.setLore(Collections.singletonList("\u00a77Click Here to change the value"));
            item.setItemMeta(meta);
            minusItem = new GuiItem(item, this.updateNowConsumer(planned), (Plugin)CustomAnvil.instance);
        } else {
            minusItem = GuiGlobalItems.backgroundItem(Material.BARRIER);
        }
        pane.bindItem('-', minusItem);
        if (this.now < this.holder.max) {
            int planned = Math.min(this.holder.max, this.now + this.step);
            ItemStack item = new ItemStack(Material.GREEN_TERRACOTTA);
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            meta.setDisplayName("\u00a7e" + this.now + " \u00a7f-> \u00a7e" + planned + " \u00a7r(\u00a7a+" + (planned - this.now) + "\u00a7r)");
            meta.setLore(Collections.singletonList("\u00a77Click Here to change the value"));
            item.setItemMeta(meta);
            plusItem = new GuiItem(item, this.updateNowConsumer(planned), (Plugin)CustomAnvil.instance);
        } else {
            plusItem = GuiGlobalItems.backgroundItem(Material.BARRIER);
        }
        pane.bindItem('+', plusItem);
        ItemStack resultPaper = new ItemStack(Material.PAPER);
        ItemMeta resultMeta = resultPaper.getItemMeta();
        assert (resultMeta != null);
        resultMeta.setDisplayName("\u00a7fValue: \u00a7e" + this.now);
        resultMeta.setLore(this.holder.displayLore);
        resultPaper.setItemMeta(resultMeta);
        GuiItem resultItem = new GuiItem(resultPaper, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
        pane.bindItem('v', resultItem);
        GuiItem returnToDefault = this.now != this.holder.defaultVal ? this.returnToDefault : GuiGlobalItems.backgroundItem();
        pane.bindItem('D', returnToDefault);
    }

    protected Consumer<InventoryClickEvent> updateNowConsumer(int planned) {
        return event -> {
            event.setCancelled(true);
            this.now = planned;
            this.updateValueDisplay();
            this.update();
        };
    }

    protected void initStepsValue() {
        GuiItem background = GuiGlobalItems.backgroundItem();
        PatternPane pane = this.getPane();
        for (char i = 'a'; i < (this.getMidStepChar() - 97) * 2 + 1; i = (char)(i + '\u0001')) {
            pane.bindItem(i, background);
        }
        this.updateStepValue();
    }

    protected void updateStepValue() {
        if (this.holder.steps.length <= 1) {
            return;
        }
        char val = this.getMidStepChar();
        val = (char)(val - (char)((this.holder.steps.length - 1) / 2));
        PatternPane pane = this.getPane();
        for (int i = 0; i < this.holder.steps.length; ++i) {
            pane.bindItem(val + i, this.stepGuiItem(i));
        }
    }

    protected char getMidStepChar() {
        return 'e';
    }

    protected GuiItem stepGuiItem(int stepIndex) {
        Consumer<InventoryClickEvent> clickEvent;
        List<CallSite> stepLore;
        Material stepMat;
        int stepValue = this.holder.steps[stepIndex];
        StringBuilder stepName = new StringBuilder("\u00a7");
        if (stepValue == this.step) {
            stepMat = Material.GREEN_STAINED_GLASS_PANE;
            stepName.append('a');
            stepLore = Collections.singletonList("\u00a77Value is changing by " + stepValue);
            clickEvent = GuiGlobalActions.stayInPlace;
        } else {
            stepMat = Material.RED_STAINED_GLASS_PANE;
            stepName.append('c');
            stepLore = Collections.singletonList("\u00a77Click here to change the value by " + stepValue);
            clickEvent = this.updateStepValue(stepValue);
        }
        stepName.append("Step of: \u00a7e").append(stepValue);
        ItemStack item = new ItemStack(stepMat);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName(stepName.toString());
        meta.setLore(stepLore);
        item.setItemMeta(meta);
        return new GuiItem(item, clickEvent, (Plugin)CustomAnvil.instance);
    }

    protected Consumer<InventoryClickEvent> updateStepValue(int stepValue) {
        return event -> {
            event.setCancelled(true);
            this.step = stepValue;
            this.updateStepValue();
            this.updateValueDisplay();
            this.update();
        };
    }

    @Override
    public boolean onSave() {
        this.holder.config.getConfig().set(this.holder.configPath, (Object)this.now);
        return this.holder.config.saveToDisk(true);
    }

    @Override
    public boolean hadChange() {
        return this.now != this.before;
    }

    public static class IntSettingFactory
    extends AbstractSettingGui.SettingGuiFactory {
        @NotNull
        String title;
        @NotNull
        ValueUpdatableGui parent;
        int min;
        int max;
        int defaultVal;
        int[] steps;
        @NotNull
        List<String> displayLore;

        public IntSettingFactory(@NotNull String title, @NotNull ValueUpdatableGui parent, @NotNull String configPath, @NotNull ConfigHolder config, @Nullable List<String> displayLore, int min, int max, int defaultVal, int ... steps) {
            super(configPath, config);
            this.title = title;
            this.parent = parent;
            this.min = min;
            this.max = max;
            this.defaultVal = defaultVal;
            this.steps = steps;
            this.displayLore = displayLore == null ? Collections.emptyList() : displayLore;
        }

        @NotNull
        public String getTitle() {
            return this.title;
        }

        public int getConfiguredValue() {
            return this.config.getConfig().getInt(this.configPath, this.defaultVal);
        }

        @Override
        public Gui create() {
            int now = this.getConfiguredValue();
            return new IntSettingsGui(this, now);
        }

        public GuiItem getItem(@NotNull Material itemMat, @NotNull String name) {
            int value = this.getConfiguredValue();
            StringBuilder itemName = new StringBuilder("\u00a7a").append(name);
            return GuiGlobalItems.createGuiItemFromProperties(this, itemMat, itemName, "\u00a7e" + value, this.displayLore, true);
        }

        public GuiItem getItem(@NotNull Material itemMat) {
            String configPath = GuiGlobalItems.getConfigNameFromPath(this.getConfigPath());
            return this.getItem(itemMat, CasedStringUtil.detectToUpperSpacedCase(configPath));
        }
    }
}

