/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.AbstractSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class ItemSettingGui
extends AbstractSettingGui {
    private final ItemSettingFactory holder;
    private final ItemStack before;
    private ItemStack now;
    protected GuiItem returnToDefault;
    protected static final List<String> CLICK_LORE = Collections.singletonList("\u00a77Click Here with an item to change the value");

    protected ItemSettingGui(ItemSettingFactory holder, ItemStack now) {
        super(3, holder.getTitle(), holder.parent);
        this.holder = holder;
        this.before = now;
        this.now = now;
        this.prepareStaticItems();
        this.updateValueDisplay();
    }

    @Override
    public Pattern getGuiPattern() {
        return new Pattern("000000000", "D0-0v0+0s", "B0000000S");
    }

    public void prepareStaticItems() {
        this.prepareReturnToDefault();
        GuiItem temporaryLeave = GuiGlobalItems.temporaryCloseGuiToSelectItem(Material.YELLOW_STAINED_GLASS_PANE, this);
        this.getPane().bindItem('s', temporaryLeave);
    }

    protected void prepareReturnToDefault() {
        ItemStack item = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7eReset to default value");
        meta.setLore(Collections.singletonList("\u00a77Default value is \u00a7e" + String.valueOf(this.holder.defaultVal)));
        item.setItemMeta(meta);
        this.returnToDefault = new GuiItem(item, event -> {
            event.setCancelled(true);
            this.now = this.holder.defaultVal;
            this.updateValueDisplay();
            this.update();
        }, (Plugin)CustomAnvil.instance);
    }

    protected void updateValueDisplay() {
        ItemStack displayedItem;
        PatternPane pane = this.getPane();
        if (this.now != null) {
            displayedItem = this.now.clone();
        } else {
            displayedItem = new ItemStack(Material.BARRIER);
            ItemMeta valueMeta = displayedItem.getItemMeta();
            assert (valueMeta != null);
            valueMeta.setDisplayName("\u00a74NO ITEM SET");
            valueMeta.setLore(CLICK_LORE);
            displayedItem.setItemMeta(valueMeta);
        }
        GuiItem resultItem = new GuiItem(displayedItem, this.setItemAsCursor(), (Plugin)CustomAnvil.instance);
        pane.bindItem('v', resultItem);
        GuiItem returnToDefault = this.now != this.holder.defaultVal ? this.returnToDefault : GuiGlobalItems.backgroundItem();
        pane.bindItem('D', returnToDefault);
    }

    protected Consumer<InventoryClickEvent> setItemAsCursor() {
        return event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            ItemStack cursor = player.getItemOnCursor();
            if (cursor.getType().isAir()) {
                return;
            }
            this.now = cursor;
            this.updateValueDisplay();
            this.update();
        };
    }

    @Override
    public boolean onSave() {
        this.holder.config.getConfig().set(this.holder.configPath, (Object)this.now);
        return this.holder.config.saveToDisk(true);
    }

    @Override
    public boolean hadChange() {
        if (this.now == null) {
            return this.before != null;
        }
        return !this.now.equals((Object)this.before);
    }

    public static class ItemSettingFactory
    extends AbstractSettingGui.SettingGuiFactory {
        @NotNull
        String title;
        @NotNull
        ValueUpdatableGui parent;
        @Nullable
        ItemStack defaultVal;
        @NotNull
        List<String> displayLore;

        public ItemSettingFactory(@NotNull String title, @NotNull ValueUpdatableGui parent, @NotNull String configPath, @NotNull ConfigHolder config, @Nullable ItemStack defaultVal, String ... displayLore) {
            super(configPath, config);
            this.title = title;
            this.parent = parent;
            this.defaultVal = defaultVal;
            this.displayLore = Arrays.asList(displayLore);
        }

        @NotNull
        public String getTitle() {
            return this.title;
        }

        public ItemStack getConfiguredValue() {
            return this.config.getConfig().getItemStack(this.configPath, this.defaultVal);
        }

        @NotNull
        public List<String> getDisplayLore() {
            return this.displayLore;
        }

        @Override
        public Gui create() {
            ItemStack now = this.getConfiguredValue();
            return new ItemSettingGui(this, now);
        }

        public GuiItem getItem(@NotNull String name) {
            ItemStack item = this.getConfiguredValue();
            item = item == null || item.getType().isAir() ? new ItemStack(Material.BARRIER) : item.clone();
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            meta.setDisplayName("\u00a7a" + name);
            meta.setLore(this.getDisplayLore());
            meta.addItemFlags(ItemFlag.values());
            item.setItemMeta(meta);
            return GuiGlobalItems.openSettingGuiItem(item, this);
        }

        public GuiItem getItem() {
            String configPath = GuiGlobalItems.getConfigNameFromPath(this.getConfigPath());
            return this.getItem(CasedStringUtil.detectToUpperSpacedCase(configPath));
        }
    }
}

