/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.dependency.util.PlatformUtil;
import xyz.alexcrea.cuanvil.util.AnvilColorUtil;
import xyz.alexcrea.cuanvil.util.AnvilXpUtil;
import xyz.alexcrea.cuanvil.util.MiniMessageUtil;
import xyz.alexcrea.cuanvil.util.config.LoreEditConfigUtil;
import xyz.alexcrea.cuanvil.util.config.LoreEditType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J(\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J(\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020#H\u0002J4\u0010(\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0,H\u0002J&\u0010-\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0,2\u0006\u0010 \u001a\u00020!J \u0010.\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\b\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010 \u001a\u00020!J&\u0010.\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0/2\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lxyz/alexcrea/cuanvil/util/AnvilLoreEditUtil;", "", "<init>", "()V", "LORE_BY_BOOK", "", "LORE_BY_PAPER", "hasLoreEditByBookPermission", "", "player", "Lorg/bukkit/permissions/Permissible;", "hasLoreEditByPaperPermission", "handleLoreAppendByBook", "Lorg/bukkit/inventory/ItemStack;", "first", "book", "Lorg/bukkit/inventory/meta/BookMeta;", "xpCost", "Ljava/util/concurrent/atomic/AtomicInteger;", "handleLoreRemoveByBook", "bookLoreEditIsAppend", "second", "(Lorg/bukkit/inventory/ItemStack;Lorg/bukkit/inventory/ItemStack;)Ljava/lang/Boolean;", "tryLoreEditByBook", "Lorg/bukkit/entity/HumanEntity;", "paperLoreEditIsAppend", "handleLoreAppendByPaper", "handleLoreRemoveByPaper", "tryLoreEditByPaper", "baseEditLoreXpCost", "", "result", "editType", "Lxyz/alexcrea/cuanvil/util/config/LoreEditType;", "colorPermission", "Lxyz/alexcrea/cuanvil/util/AnvilColorUtil$ColorPermissions;", "colorLine", "Lnet/kyori/adventure/text/Component;", "line", "permission", "colorLines", "lines", "", "outLines", "", "uncolorLines", "uncolorLine", "Ljava/util/concurrent/atomic/AtomicReference;", "CustomAnvil"})
public final class AnvilLoreEditUtil {
    @NotNull
    public static final AnvilLoreEditUtil INSTANCE = new AnvilLoreEditUtil();
    @NotNull
    private static final String LORE_BY_BOOK = "ca.lore_edit.book";
    @NotNull
    private static final String LORE_BY_PAPER = "ca.lore_edit.paper";

    private AnvilLoreEditUtil() {
    }

    private final boolean hasLoreEditByBookPermission(Permissible player) {
        return !LoreEditConfigUtil.INSTANCE.getBookLoreEditNeedPermission() || player.hasPermission(LORE_BY_BOOK);
    }

    private final boolean hasLoreEditByPaperPermission(Permissible player) {
        return !LoreEditConfigUtil.INSTANCE.getPaperLoreEditNeedPermission() || player.hasPermission(LORE_BY_PAPER);
    }

    @Nullable
    public final ItemStack handleLoreAppendByBook(@NotNull Permissible player, @NotNull ItemStack first, @NotNull BookMeta book, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(book, "book");
        Intrinsics.checkNotNullParameter(xpCost, "xpCost");
        if (!this.hasLoreEditByBookPermission(player)) {
            return null;
        }
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
        ItemStack result = itemStack;
        ItemMeta itemMeta = result.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta meta = itemMeta;
        List<Component> lore = PlatformUtil.INSTANCE.componentLore(meta);
        String page = (String)book.getPages().get(0);
        Intrinsics.checkNotNull(page);
        String[] stringArray = new String[]{"\n"};
        ArrayList lines = new ArrayList(StringsKt.split$default((CharSequence)page, stringArray, false, 0, 6, null));
        ArrayList outLines = new ArrayList(lines.size());
        int colorCost = this.colorLines(player, LoreEditType.APPEND_BOOK, lines, outLines);
        lore.addAll(outLines);
        PlatformUtil.INSTANCE.setComponentLore(meta, lore);
        result.setItemMeta(meta);
        if (Intrinsics.areEqual(result, first)) {
            return null;
        }
        xpCost.addAndGet(colorCost);
        xpCost.addAndGet(outLines.size() * LoreEditType.APPEND_BOOK.getPerLineCost());
        xpCost.addAndGet(this.baseEditLoreXpCost(first, result, LoreEditType.APPEND_BOOK));
        return result;
    }

    @Nullable
    public final ItemStack handleLoreRemoveByBook(@NotNull Permissible player, @NotNull ItemStack first, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(xpCost, "xpCost");
        if (!this.hasLoreEditByBookPermission(player)) {
            return null;
        }
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
        ItemStack result = itemStack;
        ItemMeta itemMeta = result.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta leftMeta = itemMeta;
        List<Component> currentLore = DependencyManager.INSTANCE.stripLore(result);
        if (currentLore.isEmpty()) {
            return null;
        }
        int uncolorCost = this.uncolorLines(player, currentLore, LoreEditType.REMOVE_BOOK);
        leftMeta.setLore(null);
        result.setItemMeta(leftMeta);
        DependencyManager.INSTANCE.updateLore(result);
        if (Intrinsics.areEqual(result, first)) {
            return null;
        }
        xpCost.addAndGet(uncolorCost);
        xpCost.addAndGet(currentLore.size() * LoreEditType.REMOVE_BOOK.getPerLineCost());
        xpCost.addAndGet(this.baseEditLoreXpCost(first, result, LoreEditType.REMOVE_BOOK));
        return result;
    }

    @Nullable
    public final Boolean bookLoreEditIsAppend(@NotNull ItemStack first, @NotNull ItemStack second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        BookMeta bookMeta = (BookMeta)second.getItemMeta();
        if (bookMeta == null) {
            return false;
        }
        BookMeta meta = bookMeta;
        boolean hasContent = false;
        if (meta.hasPages() && meta.getPageCount() >= 1) {
            for (String page : meta.getPages()) {
                Intrinsics.checkNotNull(page);
                if (!(!StringsKt.isBlank(page))) continue;
                hasContent = true;
                break;
            }
        }
        if (hasContent) {
            Object e = meta.getPages().get(0);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            if (((CharSequence)e).length() == 0) {
                return null;
            }
            if (LoreEditType.APPEND_BOOK.getEnabled()) {
                return true;
            }
        } else if (LoreEditType.REMOVE_BOOK.getEnabled()) {
            if (!first.hasItemMeta()) {
                return null;
            }
            ItemMeta itemMeta = first.getItemMeta();
            Intrinsics.checkNotNull(itemMeta);
            ItemMeta leftMeta = itemMeta;
            return leftMeta.hasLore() ? Boolean.valueOf(false) : null;
        }
        return null;
    }

    @Nullable
    public final ItemStack tryLoreEditByBook(@NotNull HumanEntity player, @NotNull ItemStack first, @NotNull ItemStack second, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        Intrinsics.checkNotNullParameter(xpCost, "xpCost");
        Boolean bl = this.bookLoreEditIsAppend(first, second);
        if (bl == null) {
            return null;
        }
        boolean isAppend = bl;
        ItemMeta itemMeta = second.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.BookMeta");
        BookMeta meta = (BookMeta)itemMeta;
        return isAppend ? this.handleLoreAppendByBook((Permissible)player, first, meta, xpCost) : this.handleLoreRemoveByBook((Permissible)player, first, xpCost);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Boolean paperLoreEditIsAppend(@NotNull ItemStack first, @NotNull ItemStack second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        ItemMeta itemMeta = second.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta meta = itemMeta;
        boolean hasContent = meta.hasDisplayName();
        if (hasContent) {
            if (!LoreEditType.APPEND_PAPER.getEnabled()) return null;
            return true;
        }
        if (!LoreEditType.REMOVE_PAPER.getEnabled()) return null;
        if (!first.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta2 = first.getItemMeta();
        Intrinsics.checkNotNull(itemMeta2);
        ItemMeta leftMeta = itemMeta2;
        if (!leftMeta.hasLore()) return null;
        List list = leftMeta.getLore();
        Intrinsics.checkNotNull(list);
        if (((Collection)list).isEmpty()) return null;
        boolean bl = true;
        if (!bl) return null;
        Boolean bl2 = false;
        return bl2;
    }

    @Nullable
    public final ItemStack handleLoreAppendByPaper(@NotNull Permissible player, @NotNull ItemStack first, @NotNull ItemStack second, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        Intrinsics.checkNotNullParameter(xpCost, "xpCost");
        if (!this.hasLoreEditByPaperPermission(player)) {
            return null;
        }
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
        ItemStack result = itemStack;
        ItemMeta itemMeta = result.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta meta = itemMeta;
        List<Component> lore = PlatformUtil.INSTANCE.componentLore(meta);
        boolean appendEnd = LoreEditConfigUtil.INSTANCE.getPaperLoreOrderIsEnd();
        ArrayList outList = new ArrayList(1);
        ItemMeta itemMeta2 = second.getItemMeta();
        Intrinsics.checkNotNull(itemMeta2);
        List<String> list = Collections.singletonList(itemMeta2.getDisplayName());
        Intrinsics.checkNotNullExpressionValue(list, "singletonList(...)");
        int colorCost = this.colorLines(player, LoreEditType.APPEND_PAPER, list, outList);
        Object e = outList.get(0);
        Intrinsics.checkNotNullExpressionValue(e, "get(...)");
        Component line = (Component)e;
        if (appendEnd) {
            lore.add(line);
        } else {
            lore.add(0, line);
        }
        PlatformUtil.INSTANCE.setComponentLore(meta, lore);
        result.setItemMeta(meta);
        if (Intrinsics.areEqual(result, first)) {
            return null;
        }
        xpCost.addAndGet(colorCost);
        xpCost.addAndGet(this.baseEditLoreXpCost(first, result, LoreEditType.APPEND_PAPER));
        return result;
    }

    @Nullable
    public final ItemStack handleLoreRemoveByPaper(@NotNull Permissible player, @NotNull ItemStack first, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(xpCost, "xpCost");
        if (!this.hasLoreEditByPaperPermission(player)) {
            return null;
        }
        ItemStack itemStack = first.clone();
        Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
        ItemStack result = itemStack;
        ItemMeta itemMeta = result.getItemMeta();
        Intrinsics.checkNotNull(itemMeta);
        ItemMeta meta = itemMeta;
        boolean removeEnd = LoreEditConfigUtil.INSTANCE.getPaperLoreOrderIsEnd();
        List<Component> lore = DependencyManager.INSTANCE.stripLore(result);
        if (lore.isEmpty()) {
            return null;
        }
        Component line = removeEnd ? lore.remove(lore.size() - 1) : lore.remove(0);
        meta.setLore(null);
        result.setItemMeta(meta);
        DependencyManager.INSTANCE.updateLore(result);
        ArrayList finalLore = new ArrayList();
        finalLore.addAll(PlatformUtil.INSTANCE.componentLore(meta));
        finalLore.addAll(lore);
        PlatformUtil.INSTANCE.setComponentLore(meta, finalLore);
        result.setItemMeta(meta);
        if (Intrinsics.areEqual(result, first)) {
            return null;
        }
        int uncolorCost = this.uncolorLine(player, line, LoreEditType.REMOVE_PAPER);
        xpCost.addAndGet(uncolorCost);
        xpCost.addAndGet(this.baseEditLoreXpCost(first, result, LoreEditType.REMOVE_PAPER));
        return result;
    }

    @Nullable
    public final ItemStack tryLoreEditByPaper(@NotNull HumanEntity player, @NotNull ItemStack first, @NotNull ItemStack second, @NotNull AtomicInteger xpCost) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        Intrinsics.checkNotNullParameter(xpCost, "xpCost");
        Boolean bl = this.paperLoreEditIsAppend(first, second);
        if (bl == null) {
            return null;
        }
        boolean isAppend = bl;
        return isAppend ? this.handleLoreAppendByPaper((Permissible)player, first, second, xpCost) : this.handleLoreRemoveByPaper((Permissible)player, first, xpCost);
    }

    private final int baseEditLoreXpCost(ItemStack first, ItemStack result, LoreEditType editType) {
        int xpCost = editType.getFixedCost();
        return xpCost += AnvilXpUtil.INSTANCE.calculatePenalty(first, null, result, editType.getUseType());
    }

    @NotNull
    public final AnvilColorUtil.ColorPermissions colorPermission(@NotNull Permissible player, @NotNull LoreEditType editType) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)editType, "editType");
        return AnvilColorUtil.INSTANCE.calculatePermissions(player, false, editType.getAllowColorCode(), editType.getAllowHexColor(), editType.getAllowMinimessage(), AnvilColorUtil.ColorUseType.LORE_EDIT);
    }

    private final Component colorLine(String line, AnvilColorUtil.ColorPermissions permission) {
        return AnvilColorUtil.INSTANCE.handleColor(line, permission);
    }

    private final int colorLines(Permissible player, LoreEditType editType, List<String> lines, List<Component> outLines) {
        AnvilColorUtil.ColorPermissions permission = this.colorPermission(player, editType);
        int colorCost = editType.getUseColorCost();
        boolean hasUsedColor = false;
        for (String line : lines) {
            boolean bl;
            Component component = this.colorLine(line, permission);
            if (component != null) {
                hasUsedColor = true;
                bl = outLines.add(component);
                continue;
            }
            TextComponent textComponent = Component.text(line);
            Intrinsics.checkNotNullExpressionValue(textComponent, "text(...)");
            bl = outLines.add(textComponent);
        }
        return hasUsedColor ? colorCost : 0;
    }

    public final int uncolorLines(@NotNull Permissible player, @NotNull List<Component> lines, @NotNull LoreEditType editType) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter((Object)editType, "editType");
        AnvilColorUtil.ColorPermissions permission = this.colorPermission(player, editType);
        boolean hasUndidColor = false;
        Iterator iterator2 = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Component line = (Component)iterator2.next();
            if (line == null) {
                lines.set(index, null);
                continue;
            }
            String clearedLine = AnvilColorUtil.INSTANCE.revertColorSmallest(line, permission);
            String result = null;
            if (clearedLine != null) {
                hasUndidColor = true;
                result = clearedLine;
            } else {
                result = MiniMessageUtil.INSTANCE.getPlain_text_mm().serialize(line);
            }
            lines.set(index, MiniMessageUtil.INSTANCE.getPlain_text_mm().deserialize(result));
        }
        return hasUndidColor ? editType.getRemoveColorCost() : 0;
    }

    public final int uncolorLine(@NotNull Permissible player, @Nullable Component line, @NotNull LoreEditType editType) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)editType, "editType");
        return this.uncolorLine(player, new AtomicReference<Component>(line), editType);
    }

    public final int uncolorLine(@NotNull Permissible player, @NotNull AtomicReference<Component> line, @NotNull LoreEditType editType) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter((Object)editType, "editType");
        Component component = line.get();
        if (component == null) {
            return 0;
        }
        Component coloredComponent = component;
        AnvilColorUtil.ColorPermissions permission = this.colorPermission(player, editType);
        String clearedLine = AnvilColorUtil.INSTANCE.revertColorSmallest(coloredComponent, permission);
        boolean hasUndidColor = false;
        String result = null;
        if (clearedLine != null) {
            hasUndidColor = true;
            result = clearedLine;
        } else {
            result = MiniMessageUtil.INSTANCE.getPlain_text_mm().serialize(coloredComponent);
        }
        line.set(MiniMessageUtil.INSTANCE.getPlain_text_mm().deserialize(result));
        return hasUndidColor ? editType.getRemoveColorCost() : 0;
    }
}

