/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.inventoryframework;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class HumanEntityCache {
    private final Map<HumanEntity, ItemStack[]> inventories = new HashMap<HumanEntity, ItemStack[]>();

    public void storeAndClear(@NotNull HumanEntity humanEntity) {
        this.store(humanEntity);
        PlayerInventory inventory = humanEntity.getInventory();
        for (int i = 0; i < 36; ++i) {
            inventory.clear(i);
        }
    }

    public void restoreAndForget(@NotNull HumanEntity humanEntity) {
        this.restore(humanEntity);
        this.clearCache(humanEntity);
    }

    public void restoreAndForgetAll() {
        this.restoreAll();
        this.clearCache();
    }

    public int add(@NotNull HumanEntity humanEntity, @NotNull ItemStack item) {
        ItemStack[] items = this.inventories.get(humanEntity);
        if (items == null) {
            throw new IllegalStateException("The human entity '" + humanEntity.getUniqueId().toString() + "' does not have a cached inventory");
        }
        int amountPutIn = 0;
        for (int i = 0; i < items.length; ++i) {
            ItemStack itemStack = items[i];
            if (itemStack == null) {
                items[i] = item.clone();
                items[i].setAmount(item.getAmount() - amountPutIn);
                amountPutIn = item.getAmount();
                break;
            }
            if (!itemStack.isSimilar(item)) continue;
            int additionalAmount = Math.min(itemStack.getMaxStackSize() - itemStack.getAmount(), item.getAmount());
            itemStack.setAmount(itemStack.getAmount() + additionalAmount);
            if ((amountPutIn += additionalAmount) == item.getAmount()) break;
        }
        return item.getAmount() - amountPutIn;
    }

    public void store(@NotNull HumanEntity humanEntity) {
        ItemStack[] items = new ItemStack[36];
        for (int i = 0; i < 36; ++i) {
            items[i] = humanEntity.getInventory().getItem(i);
        }
        this.inventories.put(humanEntity, items);
    }

    private void restore(@NotNull HumanEntity humanEntity) {
        ItemStack[] items = this.inventories.get(humanEntity);
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            humanEntity.getInventory().setItem(i, items[i]);
        }
    }

    private void restoreAll() {
        this.inventories.keySet().forEach(this::restore);
    }

    public boolean contains(@NotNull HumanEntity humanEntity) {
        return this.inventories.containsKey(humanEntity);
    }

    public void clearCache(@NotNull HumanEntity humanEntity) {
        this.inventories.remove(humanEntity);
    }

    private void clearCache() {
        this.inventories.clear();
    }
}

