/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.enchant.wrapped;

import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.target.EnchantmentTarget;
import com.willfp.ecoenchants.type.EnchantmentType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.enchant.AdditionalTestEnchantment;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.EnchantmentRarity;
import xyz.alexcrea.cuanvil.enchant.wrapped.CABukkitEnchantment;

public class CAEcoEnchant
extends CABukkitEnchantment
implements AdditionalTestEnchantment {
    @NotNull
    private final EcoEnchant ecoEnchant;

    public CAEcoEnchant(@NotNull EcoEnchant enchant) {
        super(enchant.getEnchantment(), EnchantmentRarity.COMMON);
        this.ecoEnchant = enchant;
    }

    @Override
    public boolean isEnchantConflict(@NotNull Map<CAEnchantment, Integer> enchantments, @NotNull Material itemMat) {
        if (enchantments.isEmpty()) {
            return false;
        }
        if (this.ecoEnchant.getConflictsWithEverything()) {
            return true;
        }
        HashMap<EnchantmentType, Integer> typeAmountMap = new HashMap<EnchantmentType, Integer>();
        for (CAEnchantment other : enchantments.keySet()) {
            CABukkitEnchantment otherVanilla;
            if (other instanceof CABukkitEnchantment && this.ecoEnchant.conflictsWith((otherVanilla = (CABukkitEnchantment)other).getEnchant())) {
                return true;
            }
            if (!(other instanceof CAEcoEnchant)) continue;
            CAEcoEnchant ecoOther = (CAEcoEnchant)other;
            EnchantmentType type = ecoOther.ecoEnchant.getType();
            typeAmountMap.putIfAbsent(type, 0);
            int amount = (Integer)typeAmountMap.get(type) + 1;
            if (amount > type.getLimit()) {
                return true;
            }
            typeAmountMap.put(type, amount);
        }
        return false;
    }

    @Override
    public boolean isItemConflict(@NotNull Map<CAEnchantment, Integer> enchantments, @NotNull Material itemMat, @NotNull ItemStack item) {
        if (Material.ENCHANTED_BOOK.equals((Object)itemMat)) {
            return false;
        }
        for (EnchantmentTarget target : this.ecoEnchant.getTargets()) {
            if (!target.matches(item)) continue;
            return false;
        }
        return true;
    }
}

