/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.group;

import io.delilaheve.CustomAnvil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;
import xyz.alexcrea.cuanvil.group.ExcludeGroup;
import xyz.alexcrea.cuanvil.group.GroupType;
import xyz.alexcrea.cuanvil.group.IncludeGroup;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0006J&\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J.\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u0006R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lxyz/alexcrea/cuanvil/group/ItemGroupManager;", "", "<init>", "()V", "groupMap", "Ljava/util/LinkedHashMap;", "", "Lxyz/alexcrea/cuanvil/group/AbstractMaterialGroup;", "getGroupMap", "()Ljava/util/LinkedHashMap;", "setGroupMap", "(Ljava/util/LinkedHashMap;)V", "prepareGroups", "", "config", "Lorg/bukkit/configuration/ConfigurationSection;", "createGroup", "name", "keys", "", "key", "readGroup", "group", "groupSection", "get", "groupName", "Companion", "CustomAnvil"})
public final class ItemGroupManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public LinkedHashMap<String, AbstractMaterialGroup> groupMap;
    @NotNull
    public static final String GROUP_TYPE_PATH = "type";
    @NotNull
    public static final String MATERIAL_LIST_PATH = "items";
    @NotNull
    public static final String GROUP_LIST_PATH = "groups";
    @NotNull
    private static final Set<String> FUTURE_MATERIAL;

    @NotNull
    public final LinkedHashMap<String, AbstractMaterialGroup> getGroupMap() {
        LinkedHashMap<String, AbstractMaterialGroup> linkedHashMap = this.groupMap;
        if (linkedHashMap != null) {
            return linkedHashMap;
        }
        Intrinsics.throwUninitializedPropertyAccessException("groupMap");
        return null;
    }

    public final void setGroupMap(@NotNull LinkedHashMap<String, AbstractMaterialGroup> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.groupMap = linkedHashMap;
    }

    public final void prepareGroups(@NotNull ConfigurationSection config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.setGroupMap(new LinkedHashMap<String, AbstractMaterialGroup>());
        Set set = config.getKeys(false);
        Intrinsics.checkNotNullExpressionValue(set, "getKeys(...)");
        Set keys2 = set;
        for (String key : keys2) {
            if (this.getGroupMap().containsKey(key)) continue;
            Intrinsics.checkNotNull(key);
            this.createGroup(config, keys2, key);
        }
    }

    @NotNull
    public final AbstractMaterialGroup createGroup(@NotNull ConfigurationSection config, @NotNull String name) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(name, "name");
        Set<String> set = this.getGroupMap().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return this.createGroup(config, set, name);
    }

    private final AbstractMaterialGroup createGroup(ConfigurationSection config, Set<String> keys2, String key) {
        ConfigurationSection configurationSection = config.getConfigurationSection(key);
        Intrinsics.checkNotNull(configurationSection);
        ConfigurationSection groupSection = configurationSection;
        String groupType = groupSection.getString(GROUP_TYPE_PATH, null);
        AbstractMaterialGroup group = null;
        if (groupType != null && GroupType.EXCLUDE.equal(groupType)) {
            group = new ExcludeGroup(key);
        } else {
            group = new IncludeGroup(key);
            if (!GroupType.INCLUDE.equal(groupType)) {
                CustomAnvil.Companion.getInstance().getLogger().warning("Group " + key + " have an invalid group type. default to Include.");
            }
        }
        ((Map)this.getGroupMap()).put(key, group);
        this.readGroup(group, groupSection, config, keys2);
        return group;
    }

    private final void readGroup(AbstractMaterialGroup group, ConfigurationSection groupSection, ConfigurationSection config, Set<String> keys2) {
        List list = groupSection.getStringList(MATERIAL_LIST_PATH);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List materialList = list;
        for (String materialTemp : materialList) {
            String materialName;
            Intrinsics.checkNotNull(materialTemp);
            String string = materialTemp;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            Intrinsics.checkNotNullExpressionValue(string.toUpperCase(locale), "toUpperCase(...)");
            Material material = Material.getMaterial((String)materialName);
            if (material == null) {
                if (FUTURE_MATERIAL.contains(materialName)) continue;
                CustomAnvil.Companion.getInstance().getLogger().warning("Unknown material " + materialTemp + " on group " + group.getName());
                continue;
            }
            group.addToPolicy(material);
        }
        List list2 = groupSection.getStringList(GROUP_LIST_PATH);
        Intrinsics.checkNotNullExpressionValue(list2, "getStringList(...)");
        List groupList = list2;
        for (String groupName : groupList) {
            AbstractMaterialGroup otherGroup;
            if (!keys2.contains(groupName)) {
                CustomAnvil.Companion.getInstance().getLogger().warning("Group " + groupName + " do not exist but is included in group " + group.getName());
                continue;
            }
            if (!this.getGroupMap().containsKey(groupName)) {
                Intrinsics.checkNotNull(groupName);
                v3 = this.createGroup(config, keys2, groupName);
            } else {
                AbstractMaterialGroup abstractMaterialGroup = this.getGroupMap().get(groupName);
                Intrinsics.checkNotNull(abstractMaterialGroup);
                v3 = otherGroup = abstractMaterialGroup;
            }
            if (otherGroup.isReferencing(group)) {
                CustomAnvil.Companion.getInstance().getLogger().warning("Group " + groupName + " is on a reference loop with group " + group.getName() + " !");
                CustomAnvil.Companion.getInstance().getLogger().warning("Please fix it in your item_groups config or the plugin will probably not work as expected.");
                continue;
            }
            group.addToPolicy(otherGroup);
        }
    }

    @Nullable
    public final AbstractMaterialGroup get(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter(groupName, "groupName");
        return this.getGroupMap().get(groupName);
    }

    static {
        String[] stringArray = new String[]{"PIGLIN_HEAD", "BRUSH"};
        FUTURE_MATERIAL = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lxyz/alexcrea/cuanvil/group/ItemGroupManager$Companion;", "", "<init>", "()V", "GROUP_TYPE_PATH", "", "MATERIAL_LIST_PATH", "GROUP_LIST_PATH", "FUTURE_MATERIAL", "", "CustomAnvil"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

