/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.config.SelectMaterialContainer;
import xyz.alexcrea.cuanvil.gui.config.ask.ConfirmActionGui;
import xyz.alexcrea.cuanvil.gui.config.list.MappedElementListConfigGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class MaterialSelectSettingGui
extends MappedElementListConfigGui<Material, GuiItem> {
    private final SelectMaterialContainer selector;
    private final Gui backGui;
    private boolean instantRemove;
    private final List<Material> defaultMaterials;
    private final EnumSet<Material> illegalMaterials;
    private final int defaultMaterialHash;
    private int nowMaterialHash;
    private GuiItem saveItem;
    private GuiItem noChangeItem;
    private GuiItem instantRemoveOn;
    private GuiItem instantRemoveOff;

    public MaterialSelectSettingGui(@NotNull SelectMaterialContainer selector, @NotNull String title, @NotNull Gui backGui) {
        super(title);
        this.selector = selector;
        this.backGui = backGui;
        this.instantRemove = false;
        this.defaultMaterials = new ArrayList<Material>(this.selector.getSelectedMaterials());
        this.illegalMaterials = this.selector.illegalMaterials();
        this.nowMaterialHash = this.defaultMaterialHash = MaterialSelectSettingGui.hashFromMaterialList(this.defaultMaterials);
        this.init();
        this.backgroundPane.bindItem('B', GuiGlobalItems.backItem(backGui));
    }

    @Override
    protected Pattern getBackgroundPattern() {
        return new Pattern("111111111", "100000001", "100000001", "100000001", "100000001", "BT1LAR1IS");
    }

    @Override
    protected void prepareStaticValues() {
        super.prepareStaticValues();
        GuiItem temporaryLeave = GuiGlobalItems.temporaryCloseGuiToSelectItem(Material.YELLOW_STAINED_GLASS_PANE, this);
        this.backgroundPane.bindItem('T', temporaryLeave);
        ItemStack selectItem = new ItemStack(Material.BLUE_STAINED_GLASS_PANE);
        ItemMeta selectMeta = selectItem.getItemMeta();
        assert (selectMeta != null);
        selectMeta.setDisplayName("\u00a7aAdd Item");
        selectMeta.setLore(Arrays.asList("\u00a77Click here with an item to add", "\u00a77it's Material to the list."));
        selectItem.setItemMeta(selectMeta);
        this.backgroundPane.bindItem('A', new GuiItem(selectItem, this.setItemAsCursor(), (Plugin)CustomAnvil.instance));
        this.saveItem = this.prepareSaveItem();
        this.noChangeItem = GuiGlobalItems.noChangeItem();
        this.backgroundPane.bindItem('S', this.noChangeItem);
        ItemStack instantRemoveOnItem = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
        ItemMeta instantRemoveOnMeta = instantRemoveOnItem.getItemMeta();
        assert (instantRemoveOnMeta != null);
        instantRemoveOnMeta.setDisplayName("\u00a7eInstant remove is \u00a7aEnabled \u00a7e!");
        instantRemoveOnMeta.setLore(Collections.singletonList("\u00a77Click here to disable the instant remove"));
        instantRemoveOnItem.setItemMeta(instantRemoveOnMeta);
        ItemStack instantRemoveOffItem = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta instantRemoveOffMeta = instantRemoveOffItem.getItemMeta();
        assert (instantRemoveOffMeta != null);
        instantRemoveOffMeta.setDisplayName("\u00a7eInstant remove is \u00a7cDisabled \u00a7e!");
        instantRemoveOffMeta.setLore(Collections.singletonList("\u00a77Click here to enable the instant remove"));
        instantRemoveOffItem.setItemMeta(instantRemoveOffMeta);
        this.instantRemoveOn = new GuiItem(instantRemoveOnItem, event -> {
            this.instantRemove = false;
            this.backgroundPane.bindItem('I', this.instantRemoveOff);
            this.update();
        }, (Plugin)CustomAnvil.instance);
        this.instantRemoveOff = new GuiItem(instantRemoveOffItem, event -> {
            this.instantRemove = true;
            this.backgroundPane.bindItem('I', this.instantRemoveOn);
            this.update();
        }, (Plugin)CustomAnvil.instance);
        this.backgroundPane.bindItem('I', this.instantRemoveOff);
    }

    private GuiItem prepareSaveItem() {
        ItemStack saveItemStack = new ItemStack(GuiGlobalItems.DEFAULT_SAVE_ITEM);
        ItemMeta saveMeta = saveItemStack.getItemMeta();
        assert (saveMeta != null);
        saveMeta.setDisplayName("\u00a7aSave");
        saveItemStack.setItemMeta(saveMeta);
        return new GuiItem(saveItemStack, event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage("\u00a7cYou do not have permission to edit the config");
                return;
            }
            if (this.testCantSave()) {
                return;
            }
            EnumSet<Material> result = EnumSet.noneOf(Material.class);
            result.addAll(this.elementGuiMap.keySet());
            if (!this.selector.setSelectedMaterials(result)) {
                player.sendMessage("\u00a7cSomething went wrong while saving the change of value.");
            }
            this.backGui.show(player);
        }, (Plugin)CustomAnvil.instance);
    }

    protected Consumer<InventoryClickEvent> setItemAsCursor() {
        return event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            ItemStack cursor = player.getItemOnCursor();
            Material cursorMat = cursor.getType();
            if (cursorMat.isAir()) {
                return;
            }
            if (this.illegalMaterials.contains(cursorMat)) {
                return;
            }
            if (!this.elementGuiMap.containsKey(cursorMat)) {
                this.updateValueForGeneric(cursorMat, true);
                this.nowMaterialHash ^= cursorMat.hashCode();
                this.setSaveItem();
                this.update();
            }
        };
    }

    @Override
    protected ItemStack createItemForGeneric(Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName("\u00a7a" + CasedStringUtil.snakeToUpperSpacedCase(material.name().toLowerCase()));
        meta.setLore(Collections.singletonList("\u00a77Click here to remove this material from the list"));
        meta.addItemFlags(ItemFlag.values());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    protected Collection<Material> getEveryDisplayableInstanceOfGeneric() {
        return this.defaultMaterials;
    }

    @Override
    protected void updateElement(Material material, GuiItem element) {
    }

    @Override
    protected GuiItem newElementRequested(Material material, GuiItem newItem) {
        newItem.setAction(event -> {
            if (this.instantRemove) {
                this.removeMaterial(material);
            } else {
                String materialName = CasedStringUtil.snakeToUpperSpacedCase(material.name().toLowerCase());
                ConfirmActionGui confirmGui = new ConfirmActionGui("Remove " + materialName, "\u00a77Confirm Remove " + materialName.toLowerCase() + " from this list.", this, this, () -> {
                    this.removeMaterial(material);
                    return true;
                }, false);
                confirmGui.show(event.getWhoClicked());
            }
        });
        return newItem;
    }

    private void removeMaterial(Material material) {
        if (this.elementGuiMap.containsKey(material)) {
            this.nowMaterialHash ^= material.hashCode();
            this.setSaveItem();
            this.removeGeneric(material);
        }
    }

    @Override
    protected GuiItem findItemFromElement(Material generic, GuiItem element) {
        return element;
    }

    @Override
    protected GuiItem findGuiItemForRemoval(Material generic, GuiItem element) {
        return element;
    }

    private static int hashFromMaterialList(List<Material> materialList) {
        int defaultMaterialHash = 0;
        for (Material material : materialList) {
            defaultMaterialHash ^= material.hashCode();
        }
        return defaultMaterialHash;
    }

    private void setSaveItem() {
        if (this.testCantSave()) {
            this.backgroundPane.bindItem('S', this.noChangeItem);
        } else {
            this.backgroundPane.bindItem('S', this.saveItem);
        }
    }

    private boolean testCantSave() {
        return this.defaultMaterialHash == this.nowMaterialHash;
    }

    @Override
    protected GuiItem prepareCreateNewItem() {
        return null;
    }

    @Override
    protected Consumer<String> prepareCreateItemConsumer(HumanEntity player) {
        return null;
    }

    @Override
    protected String genericDisplayedName() {
        return null;
    }
}

