/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.update.minecraft;

import io.delilaheve.CustomAnvil;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.update.Version;

public abstract class MCUpdate {
    public final Version version;

    public MCUpdate(Version version) {
        this.version = version;
    }

    public boolean handleUpdate(Version current, boolean hadUpdate) {
        Version version;
        if (this.version.greaterThan(current)) {
            return false;
        }
        String oldVersion = ConfigHolder.DEFAULT_CONFIG.getConfig().getString("lowMinecraftVersion");
        if (oldVersion != null && this.version.lesserEqual(version = Version.fromString(oldVersion))) {
            return false;
        }
        if (!hadUpdate) {
            CustomAnvil.instance.getLogger().info("Updating config to support minecraft " + String.valueOf(current) + " ...");
        }
        this.doUpdate();
        return true;
    }

    protected abstract void doUpdate();
}

