/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.util;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.recipe.AnvilCustomRecipe;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\f"}, d2={"Lxyz/alexcrea/cuanvil/util/CustomRecipeUtil;", "", "<init>", "()V", "getCustomRecipe", "Lxyz/alexcrea/cuanvil/recipe/AnvilCustomRecipe;", "leftItem", "Lorg/bukkit/inventory/ItemStack;", "rightItem", "getCustomRecipeAmount", "", "recipe", "CustomAnvil"})
public final class CustomRecipeUtil {
    @NotNull
    public static final CustomRecipeUtil INSTANCE = new CustomRecipeUtil();

    private CustomRecipeUtil() {
    }

    @Nullable
    public final AnvilCustomRecipe getCustomRecipe(@NotNull ItemStack leftItem, @Nullable ItemStack rightItem) {
        Intrinsics.checkNotNullParameter(leftItem, "leftItem");
        ArrayList<AnvilCustomRecipe> arrayList = ConfigHolder.CUSTOM_RECIPE_HOLDER.getRecipeManager().getRecipeByMat().get(leftItem.getType());
        if (arrayList == null) {
            return null;
        }
        ArrayList<AnvilCustomRecipe> recipeList = arrayList;
        CustomAnvil.Companion.verboseLog("Testing " + recipeList.size() + " recipe...");
        Iterator<AnvilCustomRecipe> iterator2 = recipeList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<AnvilCustomRecipe> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            AnvilCustomRecipe recipe;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!recipe.testItem(leftItem, rightItem)) continue;
            return recipe;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getCustomRecipeAmount(@NotNull AnvilCustomRecipe recipe, @NotNull ItemStack leftItem, @Nullable ItemStack rightItem) {
        int n;
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        Intrinsics.checkNotNullParameter(leftItem, "leftItem");
        if (recipe.getExactCount()) {
            int n2 = leftItem.getAmount();
            ItemStack itemStack = recipe.getLeftItem();
            Intrinsics.checkNotNull(itemStack);
            if (n2 != itemStack.getAmount()) {
                return 0;
            }
            if (rightItem == null) return 1;
            int n3 = rightItem.getAmount();
            ItemStack itemStack2 = recipe.getRightItem();
            Intrinsics.checkNotNull(itemStack2);
            if (n3 == itemStack2.getAmount()) return 1;
            return 0;
        }
        ItemStack itemStack = recipe.getResultItem();
        Intrinsics.checkNotNull(itemStack);
        ItemStack resultItem = itemStack;
        int maxResultAmount = resultItem.getMaxStackSize() / resultItem.getAmount();
        int n4 = leftItem.getAmount();
        ItemStack itemStack3 = recipe.getLeftItem();
        Intrinsics.checkNotNull(itemStack3);
        int maxLeftAmount = n4 / itemStack3.getAmount();
        ItemStack itemStack4 = rightItem;
        if (itemStack4 == null) {
            n = maxLeftAmount;
        } else {
            int n5 = itemStack4.getAmount();
            ItemStack itemStack5 = recipe.getRightItem();
            Intrinsics.checkNotNull(itemStack5);
            n = n5 / itemStack5.getAmount();
        }
        int maxRightAmount = n;
        CustomAnvil.Companion.verboseLog("resultItem: " + resultItem + ", maxResultAmount: " + maxResultAmount + ", maxLeftAmount: " + maxLeftAmount + ", maxRightAmount: " + maxRightAmount);
        int n6 = Math.min(Math.min(maxResultAmount, maxLeftAmount), maxRightAmount);
        return n6;
    }
}

