/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.inventoryframework.gui.type.util;

import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.inventoryframework.adventuresupport.StringHolder;
import xyz.alexcrea.inventoryframework.adventuresupport.TextHolder;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;

public abstract class NamedGui
extends Gui {
    @NotNull
    private TextHolder title;
    private boolean dirty = false;

    public NamedGui(@NotNull String title) {
        this(StringHolder.of(title));
    }

    public NamedGui(@NotNull TextHolder title) {
        this(title, (Plugin)JavaPlugin.getProvidingPlugin(NamedGui.class));
    }

    public NamedGui(@NotNull String title, @NotNull Plugin plugin) {
        this(StringHolder.of(title), plugin);
    }

    public NamedGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(plugin);
        this.title = title;
    }

    public void setTitle(@NotNull String title) {
        this.setTitle(StringHolder.of(title));
    }

    public void setTitle(@NotNull TextHolder title) {
        this.title = title;
        this.dirty = true;
    }

    @NotNull
    @Contract(pure=true)
    public String getTitle() {
        return this.title.asLegacyString();
    }

    @NotNull
    @Contract(pure=true)
    public TextHolder getTitleHolder() {
        return this.title;
    }

    @Contract(pure=true)
    public boolean isDirty() {
        return this.dirty;
    }

    public void markChanges() {
        this.dirty = false;
    }
}

